/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;

public class PeekReader
extends Reader
implements StreamLocationProvider {
    public static final int DEFAULT_PEEK_BUFFER_SIZE = 8192;
    private Reader underlyingReader;
    private int peekLength;
    private char[] peekBuffer;
    private int bufferStartPos = -1;
    private int bufferContentLength = -1;
    private long characterOffset = 0L;
    private long lineNumber = 0L;
    private long columnNumber = 0L;

    public PeekReader(Reader reader, int n) throws IOException {
        super((Object)reader);
        this.underlyingReader = reader;
        this.peekLength = n;
        this.initPeekBuffer();
    }

    public PeekReader(Reader reader) throws IOException {
        this(reader, 8192);
    }

    @Override
    public long getCharacterOffset() {
        return this.characterOffset;
    }

    @Override
    public long getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public long getColumnNumber() {
        return this.columnNumber;
    }

    private int getBufferEndPos() {
        if (this.bufferContentLength == 0) {
            return -1;
        }
        int n = this.bufferStartPos - (this.peekLength - this.bufferContentLength);
        if (n < 0) {
            n = this.peekLength + n;
        }
        return n;
    }

    public int getAvailablePeek() {
        return this.bufferContentLength;
    }

    @Override
    public void close() throws IOException {
        this.underlyingReader.close();
    }

    @Override
    public boolean markSupported() {
        return this.underlyingReader.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.underlyingReader.reset();
    }

    private void initPeekBuffer() throws IOException {
        this.bufferStartPos = 0;
        this.peekBuffer = new char[this.peekLength];
        this.bufferContentLength = this.underlyingReader.read(this.peekBuffer);
    }

    public int peek(char[] cArray) {
        return this.peek(cArray, 0, cArray.length);
    }

    public int peek(char[] cArray, int n, int n2) {
        int n3 = Math.min(n2, this.bufferContentLength);
        int n4 = Math.min(n3, this.peekLength - this.bufferStartPos);
        System.arraycopy(this.peekBuffer, this.bufferStartPos, cArray, n, n4);
        int n5 = n3 - n4;
        if (n5 > 0) {
            System.arraycopy(this.peekBuffer, 0, cArray, n + n4, n5);
        }
        return n3;
    }

    private String charArrayToString(char[] cArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public String peekString(int n) {
        char[] cArray = new char[n];
        int n2 = this.peek(cArray);
        return this.charArrayToString(cArray, n2);
    }

    public String readString(int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = this.read(cArray);
        if (n2 == -1) {
            return "";
        }
        return this.charArrayToString(cArray, n2);
    }

    private void writeToPeekBuffer(char[] cArray, int n) {
        if (n == -1) {
            n = 0;
        }
        if (n > 0) {
            if (n >= this.peekLength) {
                System.arraycopy(cArray, cArray.length - this.peekLength, this.peekBuffer, 0, this.peekLength);
                this.bufferContentLength = this.peekLength;
                this.bufferStartPos = 0;
            } else {
                int n2 = Math.min(this.peekLength - this.bufferStartPos, cArray.length);
                System.arraycopy(cArray, 0, this.peekBuffer, this.bufferStartPos, n2);
                if (n2 < cArray.length) {
                    int n3 = cArray.length - n2;
                    System.arraycopy(cArray, n2, this.peekBuffer, 0, n3);
                    this.bufferStartPos = n3;
                } else {
                    this.bufferStartPos += n2;
                    if (this.bufferStartPos >= this.peekLength) {
                        this.bufferStartPos -= this.peekLength;
                    }
                }
            }
            this.bufferContentLength = Math.max(0, this.bufferContentLength - (cArray.length - n));
        } else {
            this.bufferStartPos += cArray.length;
            if (this.bufferStartPos >= this.peekLength) {
                this.bufferStartPos -= this.peekLength;
            }
            this.bufferContentLength = Math.max(0, this.bufferContentLength - cArray.length);
        }
    }

    private boolean isCharNextInBuffer(char c, char[] cArray, int n, int n2) {
        if (n + 1 < n2) {
            return cArray[n + 1] == c;
        }
        int n3 = this.peek();
        return n3 != -1 && (char)n3 == c;
    }

    private void countPositionChange(char[] cArray, int n, int n2) {
        this.characterOffset += (long)n2;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (cArray[i] == '\r' && !this.isCharNextInBuffer('\n', cArray, i, n3) || cArray[i] == '\n') {
                ++this.lineNumber;
                this.columnNumber = 0L;
                continue;
            }
            ++this.columnNumber;
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        char[] cArray2 = new char[n2];
        int n3 = this.underlyingReader.read(cArray2);
        if (n3 == -1 && this.getAvailablePeek() == 0) {
            return -1;
        }
        int n4 = this.peek(cArray, n, n2);
        int n5 = Math.min(n3, n2 - n4);
        if (n5 > 0) {
            System.arraycopy(cArray2, 0, cArray, n + n4, n5);
            n4 += n5;
        }
        this.writeToPeekBuffer(cArray2, n3);
        this.countPositionChange(cArray, n, n4);
        return n4;
    }

    public char readChar() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException("The end of the underlying stream was already reached.");
        }
        return (char)n;
    }

    public char peekChar() throws EOFException {
        if (this.getAvailablePeek() > 0) {
            return this.peekBuffer[this.bufferStartPos];
        }
        throw new EOFException("There are no more characters available in this stream.");
    }

    public int peek() {
        if (this.getAvailablePeek() > 0) {
            return this.peekBuffer[this.bufferStartPos];
        }
        return -1;
    }

    public char peekChar(int n) throws IndexOutOfBoundsException, EOFException {
        if (this.getAvailablePeek() > n) {
            int n2 = this.bufferStartPos + n;
            if (n2 >= this.peekBuffer.length) {
                n2 -= this.peekBuffer.length;
            }
            return this.peekBuffer[n2];
        }
        if (this.getAvailablePeek() < this.peekLength && this.peekLength > n) {
            throw new EOFException("The specified offset lies behind the end of the stream.");
        }
        throw new IndexOutOfBoundsException("The specified offset (" + n + ") is outside the current buffer range.");
    }

    public int peek(int n) throws IndexOutOfBoundsException {
        try {
            return this.peekChar(n);
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public ReadResult peekLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.peek();
        int n2 = 0;
        while (n2 < this.getAvailablePeek() && n != -1 && !StringUtils.isNewLineChar((char)n)) {
            stringBuilder.append((char)n);
            if (++n2 >= this.peekBuffer.length) continue;
            n = this.peek(n2);
        }
        return new ReadResult(stringBuilder, n == -1 || n2 < this.getAvailablePeek());
    }

    public boolean isNewLineNext() {
        try {
            return StringUtils.isNewLineChar(this.peekChar());
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    public boolean isNext(String string) throws IllegalArgumentException {
        try {
            for (int i = 0; i < string.length(); ++i) {
                int n = this.peek(i);
                if (n != -1 && string.charAt(i) == (char)n) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("The specified sequence is longer than the available peek length (" + string.length() + " > " + this.getAvailablePeek() + ")");
        }
    }

    public boolean isNext(String[] stringArray) throws IllegalArgumentException {
        return this.whichIsNext(stringArray) != -1;
    }

    public int whichIsNext(String[] stringArray) throws IllegalArgumentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isNext(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public int consumeNewLine() throws IOException {
        int n = 0;
        if (this.isNewLineNext()) {
            int n2 = this.read();
            ++n;
            if (n2 != -1) {
                try {
                    if (n2 == 13 && this.peekChar() == '\n') {
                        this.read();
                        ++n;
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public ReadResult readLine() throws IOException {
        return this.readLine(Integer.MAX_VALUE);
    }

    public ReadResult readLine(int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (stringBuffer.length() < n && !bl && !this.isNewLineNext()) {
            n2 = this.read();
            if (n2 == -1) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)n2);
        }
        n2 = 1;
        if (!bl && (n2 = this.consumeNewLine()) == 0 && this.peek() == -1) {
            n2 = 1;
        }
        return new ReadResult(stringBuffer, n2 > 0);
    }

    public ReadResult readUntil(String string) throws IOException {
        return this.readUntil(Integer.MAX_VALUE, string);
    }

    public ReadResult readUntil(int n, String string) throws IOException {
        return this.readUntil(n, new String[]{string}, false);
    }

    public ReadResult readUntilWhitespace(int n, String string) throws IOException {
        return this.readUntil(n, new String[]{string}, true);
    }

    public ReadResult readUntil(String[] stringArray) throws IOException {
        return this.readUntil(Integer.MAX_VALUE, stringArray, false);
    }

    public ReadResult readUntilWhitespace(String[] stringArray) throws IOException {
        return this.readUntil(Integer.MAX_VALUE, stringArray, true);
    }

    public ReadResult readUntil(int n, String[] stringArray) throws IOException {
        return this.readUntil(n, stringArray, false);
    }

    public ReadResult readUntilWhitespace(int n, String[] stringArray) throws IOException {
        return this.readUntil(n, stringArray, true);
    }

    protected ReadResult readUntil(int n, String[] stringArray, boolean bl) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n) continue;
            throw new IllegalArgumentException("The allowed maximal length must be greater of equal to the length of the termination sequence.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n2 = this.peek();
        while (!(stringBuffer.length() >= n || bl2 || this.isNext(stringArray) || bl && Character.isWhitespace(n2))) {
            if (n2 == -1) {
                bl2 = true;
            } else {
                stringBuffer.append((char)n2);
            }
            this.skip(1L);
            n2 = this.peek();
        }
        boolean bl3 = bl2;
        if (Character.isWhitespace(n2)) {
            this.skip(1L);
            bl3 = true;
        } else {
            int n3 = this.whichIsNext(stringArray);
            if (!bl2 && n3 != -1) {
                this.skip(stringArray[n3].length());
                bl3 = true;
            } else {
                bl3 = bl3 || this.peek() == -1;
            }
        }
        return new ReadResult(stringBuffer, bl3);
    }

    public ReadResult readRegExp(String string, boolean bl) throws IOException {
        return this.readRegExp(Integer.MAX_VALUE, string, bl);
    }

    public ReadResult readRegExp(int n, String string, boolean bl) throws IOException {
        return this.readRegExp(n, Pattern.compile(string), bl);
    }

    public ReadResult readRegExp(Pattern pattern, boolean bl) throws IOException {
        return this.readRegExp(Integer.MAX_VALUE, pattern, bl);
    }

    public ReadResult readRegExp(int n, Pattern pattern, boolean bl) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        while (stringBuffer.length() < n && !bl2 && !pattern.matcher(stringBuffer).matches()) {
            n2 = this.read();
            if (n2 == -1) {
                bl2 = true;
                continue;
            }
            stringBuffer.append((char)n2);
        }
        if (bl) {
            while (stringBuffer.length() < n && !bl2) {
                n2 = this.peek();
                if (n2 == -1) {
                    bl2 = true;
                    continue;
                }
                stringBuffer.append((char)n2);
                if (pattern.matcher(stringBuffer).matches()) {
                    this.read();
                    continue;
                }
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                break;
            }
        }
        return new ReadResult(stringBuffer, bl2 || pattern.matcher(stringBuffer).matches() || this.peek() == -1);
    }

    public static class ReadResult {
        private CharSequence sequence;
        private boolean completelyRead;

        public ReadResult(CharSequence charSequence, boolean bl) {
            this.sequence = charSequence;
            this.completelyRead = bl;
        }

        public CharSequence getSequence() {
            return this.sequence;
        }

        public boolean isCompletelyRead() {
            return this.completelyRead;
        }
    }
}

