/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.IOProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IOUtils {
    public static final int EOF = -1;

    public static String getClassLocation(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " ");
    }

    public static String getClassDir(Class<?> clazz) {
        File file = new File(IOUtils.getClassLocation(clazz));
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return file.getParent();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy(inputStream, outputStream, null);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        IOUtils.copy(inputStream, outputStream, bl, null);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, IOProgressListener iOProgressListener) throws IOException {
        IOUtils.copy(inputStream, outputStream, true, iOProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl, IOProgressListener iOProgressListener) throws IOException {
        try {
            int n;
            long l = 0L;
            if (iOProgressListener != null) {
                iOProgressListener.ioStarts();
            }
            byte[] byArray = new byte[65535];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                if (iOProgressListener == null) continue;
                iOProgressListener.ioProgress(l += (long)n);
            }
        }
        finally {
            if (bl) {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            if (iOProgressListener != null) {
                iOProgressListener.ioFinished();
            }
        }
    }

    public static void copy(File file, File file2, IOProgressListener iOProgressListener) throws IOException {
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(file2), iOProgressListener);
    }

    public static void copy(File file, File file2) throws IOException {
        IOUtils.copy(file, file2, null);
    }

    public static void copyFromResource(String string, OutputStream outputStream) throws IOException {
        IOUtils.copyFromResource(string, outputStream, null);
    }

    public static void copyFromResource(String string, OutputStream outputStream, IOProgressListener iOProgressListener) throws IOException {
        IOUtils.copy(Object.class.getResource(string).openStream(), outputStream, iOProgressListener);
    }

    public static void extractFile(ZipFile zipFile, String string, OutputStream outputStream, IOProgressListener iOProgressListener) throws IOException {
        IOUtils.copy(zipFile.getInputStream(zipFile.getEntry(string)), outputStream, iOProgressListener);
    }

    public static void extractFile(ZipFile zipFile, String string, OutputStream outputStream) throws IOException {
        IOUtils.extractFile(zipFile, string, outputStream, null);
    }

    public static void extractFile(ZipFile zipFile, String string, File file, IOProgressListener iOProgressListener) throws IOException {
        IOUtils.copy(zipFile.getInputStream(zipFile.getEntry(string)), (OutputStream)new FileOutputStream(file), iOProgressListener);
    }

    public static void extractFile(ZipFile zipFile, String string, File file) throws IOException {
        IOUtils.copy(zipFile.getInputStream(zipFile.getEntry(string)), (OutputStream)new FileOutputStream(file), null);
    }

    public static void extractDir(ZipFile zipFile, String string, String string2, IOProgressListener iOProgressListener) throws IOException {
        if (!string2.endsWith(System.getProperty("file.separator"))) {
            string2 = string2 + System.getProperty("file.separator");
        }
        new File(string2).mkdirs();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(string) || zipEntry.isDirectory()) continue;
            File file = new File(string2 + zipEntry.getName().substring(string.length(), zipEntry.getName().length()));
            file.createNewFile();
            if (iOProgressListener != null) {
                iOProgressListener.newFile(zipEntry.getName(), file.getAbsolutePath(), zipEntry.getSize());
            }
            IOUtils.extractFile(zipFile, zipEntry.getName(), file, iOProgressListener);
        }
    }

    public static void extractDir(ZipFile zipFile, String string, String string2) throws IOException {
        IOUtils.extractDir(zipFile, string, string2, null);
    }

    public static long dirSize(ZipFile zipFile, String string) {
        long l = 0L;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(string) || zipEntry.isDirectory()) continue;
            l += zipEntry.getSize();
        }
        return l;
    }
}

