/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.SystemUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    public static final char EXTENSION_SEPARATOR = '.';
    private String description;
    private List<String> extensionsList;

    public ExtensionFileFilter(String string, boolean bl, String ... stringArray) {
        this(string, bl, Arrays.asList(stringArray));
    }

    public ExtensionFileFilter(String string, boolean bl, List<String> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("At least one file extension needs to be specified.");
        }
        for (String string2 : list) {
            if (string2 != null) continue;
            throw new NullPointerException("A file extension must not be null.");
        }
        this.extensionsList = Collections.unmodifiableList(list);
        this.description = this.processDescription(string, bl);
    }

    public String getExtensionsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.extensionsList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append('*');
            stringBuilder.append('.');
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(File.pathSeparatorChar);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private String processDescription(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("The description must not be null.");
        }
        if (bl) {
            return string + " (" + this.getExtensionsAsString() + ")";
        }
        return string;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        for (String string : this.extensionsList) {
            if (!file.getName().endsWith('.' + string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(new File(file.getAbsolutePath() + SystemUtils.FILE_SEPARATOR + string));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDefaultExtension() {
        return this.extensionsList.get(0);
    }

    public List<String> getExtensions() {
        return this.extensionsList;
    }
}

