/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.io;

import info.bioinfweb.commons.io.ExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;

public abstract class ContentExtensionFileFilter
extends ExtensionFileFilter {
    private TestStrategy testStrategy;
    private boolean acceptFilesWithExceptions;

    public ContentExtensionFileFilter(String string, boolean bl, TestStrategy testStrategy, boolean bl2, String ... stringArray) {
        super(string, bl, stringArray);
        this.testStrategy = testStrategy;
        this.acceptFilesWithExceptions = bl2;
    }

    public ContentExtensionFileFilter(String string, boolean bl, String ... stringArray) {
        this(string, bl, TestStrategy.BOTH, false, stringArray);
    }

    public TestStrategy getTestStrategy() {
        return this.testStrategy;
    }

    public void setTestStrategy(TestStrategy testStrategy) throws NullPointerException {
        if (testStrategy == null) {
            throw new NullPointerException("The test strategy must not be null.");
        }
        this.testStrategy = testStrategy;
    }

    public boolean isAcceptFilesWithExceptions() {
        return this.acceptFilesWithExceptions;
    }

    public void setAcceptFilesWithExceptions(boolean bl) {
        this.acceptFilesWithExceptions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acceptContent(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        try {
            boolean bl;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                bl = this.acceptContent(fileInputStream);
            }
            return bl;
        }
        catch (Exception exception) {
            return this.isAcceptFilesWithExceptions();
        }
    }

    protected abstract boolean acceptContent(FileInputStream var1) throws Exception;

    @Override
    public boolean accept(File file) {
        switch (this.getTestStrategy()) {
            case EXTENSION: {
                return super.accept(file);
            }
            case CONTENT: {
                return this.acceptContent(file);
            }
            case BOTH: {
                return super.accept(file) && this.acceptContent(file);
            }
        }
        throw new InternalError("Unsupported test strategy " + (Object)((Object)this.getTestStrategy()) + ".");
    }

    public static enum TestStrategy {
        EXTENSION,
        CONTENT,
        BOTH;

    }
}

