/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.graphics;

import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ZoomableFont {
    private double originalHeight = 10.0;
    private int style = 0;
    private String name = "SansSerif";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ZoomableFont() {
    }

    public ZoomableFont(String string, int n, double d) {
        this.originalHeight = d;
        this.style = n;
        this.name = string;
    }

    public double getOriginalHeight() {
        return this.originalHeight;
    }

    public void setOriginalHeight(double d) {
        if (this.originalHeight != d) {
            double d2 = this.originalHeight;
            this.originalHeight = d;
            this.propertyChangeSupport.firePropertyChange("originalHeight", d2, d);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n) {
            int n2 = this.style;
            this.style = n;
            this.propertyChangeSupport.firePropertyChange("style", n2, n);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != string) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange("name", string2, string);
        }
    }

    public Font createFont(double d) {
        return new Font(this.getName(), this.getStyle(), 10).deriveFont((float)(this.getOriginalHeight() * d));
    }

    public void adjustFromFont(Font font) {
        this.setName(font.getName());
        this.setStyle(font.getStyle());
        this.setOriginalHeight(font.getSize2D());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }
}

