/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.graphics;

import info.bioinfweb.commons.Math2;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GraphicsUtils {
    public static int rgbToGrayValue(Color color) {
        return (color.getRed() + color.getGreen() + color.getBlue()) / 3;
    }

    public static Color rgbToGrayColor(Color color) {
        int n = GraphicsUtils.rgbToGrayValue(color);
        return new Color(n, n, n, color.getAlpha());
    }

    public static Color multiplyColorChannels(Color color, float f) {
        return new Color(Math2.moveBetween(Math.round((float)color.getRed() * f), 0, 255), Math2.moveBetween(Math.round((float)color.getGreen() * f), 0, 255), Math2.moveBetween(Math.round((float)color.getBlue() * f), 0, 255), color.getAlpha());
    }

    public static Color addToColorChannels(Color color, int n) {
        return new Color(Math2.moveBetween(color.getRed() + n, 0, 255), Math2.moveBetween(color.getGreen() + n, 0, 255), Math2.moveBetween(color.getBlue() + n, 0, 255), color.getAlpha());
    }

    public static Color moveColorToCenter(Color color, float f) {
        if (GraphicsUtils.rgbToGrayValue(color) > 127) {
            f = 1.0f / f;
        }
        return GraphicsUtils.multiplyColorChannels(color, f);
    }

    public static int brightnessDifference(Color color, Color color2) {
        return Math.abs(color.getBlue() - color2.getBlue()) + Math.abs(color.getRed() - color2.getRed()) + Math.abs(color.getGreen() - color2.getGreen());
    }

    public static Color invertColor(Color color) {
        return new Color(-(color.getRed() - 255), -(color.getGreen() - 255), -(color.getBlue() - 255));
    }

    public static Color getContrastColor(Color color, Color color2, int n) {
        if (GraphicsUtils.brightnessDifference(color, color2) < n) {
            return GraphicsUtils.invertColor(color);
        }
        return color;
    }

    public static Color blend(Color ... colorArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < colorArray.length; ++i) {
            n += colorArray[i].getRed();
            n2 += colorArray[i].getGreen();
            n3 += colorArray[i].getBlue();
        }
        return new Color(n / colorArray.length, n2 / colorArray.length, n3 / colorArray.length);
    }

    public static String colorToHexString(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void drawStringInRectangle(Graphics2D graphics2D, Rectangle2D rectangle2D, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawString(string, (int)Math.round(rectangle2D.getX() + 0.5 * (rectangle2D.getWidth() - (double)fontMetrics.stringWidth(string))), (int)Math.round(rectangle2D.getY() + 0.5 * (rectangle2D.getHeight() - (double)fontMetrics.getHeight()) + (double)fontMetrics.getAscent()));
    }
}

