/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections.observable;

import info.bioinfweb.commons.collections.ListDecorator;
import info.bioinfweb.commons.collections.observable.ListAddEvent;
import info.bioinfweb.commons.collections.observable.ListChangeListener;
import info.bioinfweb.commons.collections.observable.ListRemoveEvent;
import info.bioinfweb.commons.collections.observable.ListReplaceEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObservableList<E>
extends ListDecorator<E> {
    private List<ListChangeListener<E>> changeListeners = new ArrayList<ListChangeListener<E>>();

    public ObservableList(List<E> list) {
        super(list);
    }

    public void addListChangeListener(ListChangeListener<E> listChangeListener) {
        this.changeListeners.add(listChangeListener);
    }

    public boolean removeListChangeListener(ListChangeListener<E> listChangeListener) {
        return this.changeListeners.remove(listChangeListener);
    }

    @Override
    protected void beforeAdd(int n, Collection<? extends E> collection) {
        ListAddEvent<Collection<? extends E>> listAddEvent = new ListAddEvent<Collection<? extends E>>(this, n, collection);
        for (ListChangeListener<Collection<? extends E>> listChangeListener : this.changeListeners) {
            listChangeListener.beforeElementsAdded(listAddEvent);
        }
    }

    @Override
    protected void afterAdd(int n, Collection<? extends E> collection) {
        ListAddEvent<Collection<? extends E>> listAddEvent = new ListAddEvent<Collection<? extends E>>(this, n, collection);
        for (ListChangeListener<Collection<? extends E>> listChangeListener : this.changeListeners) {
            listChangeListener.afterElementsAdded(listAddEvent);
        }
    }

    @Override
    protected void beforeReplace(int n, E e, E e2) {
        ListReplaceEvent<E> listReplaceEvent = new ListReplaceEvent<E>(this, n, e, e2);
        for (ListChangeListener<E> listChangeListener : this.changeListeners) {
            listChangeListener.beforeElementReplaced(listReplaceEvent);
        }
    }

    @Override
    protected void afterReplace(int n, E e, E e2) {
        ListReplaceEvent<E> listReplaceEvent = new ListReplaceEvent<E>(this, n, e, e2);
        for (ListChangeListener<E> listChangeListener : this.changeListeners) {
            listChangeListener.afterElementReplaced(listReplaceEvent);
        }
    }

    @Override
    protected void beforeRemove(int n, Collection<Object> collection) {
        ListRemoveEvent listRemoveEvent = new ListRemoveEvent(this, n, collection);
        for (ListChangeListener listChangeListener : this.changeListeners) {
            listChangeListener.beforeElementsRemoved(listRemoveEvent);
        }
    }

    @Override
    protected void afterRemove(int n, Collection<? extends E> collection) {
        ListRemoveEvent listRemoveEvent = new ListRemoveEvent(this, n, collection);
        for (ListChangeListener<Collection<? extends E>> listChangeListener : this.changeListeners) {
            listChangeListener.afterElementsRemoved(listRemoveEvent);
        }
    }
}

