/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections.observable;

import info.bioinfweb.commons.collections.ListChangeType;
import info.bioinfweb.commons.collections.observable.ListChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListMultipleChangesEvent<E>
extends ListChangeEvent<E> {
    private Collection<E> affectedElements;

    public ListMultipleChangesEvent(List<E> list, ListChangeType listChangeType, int n, Collection<? extends E> collection) {
        super(list, listChangeType, n);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("At least one affected element has to be specified.");
        }
        this.affectedElements = Collections.unmodifiableCollection(collection);
    }

    public ListMultipleChangesEvent(List<E> list, ListChangeType listChangeType, int n, E e) {
        super(list, listChangeType, n);
        if (e == null) {
            throw new NullPointerException("Null is not a valid value for the affected element.");
        }
        this.affectedElements = Collections.nCopies(1, e);
    }

    public Collection<? extends E> getAffectedElements() {
        return this.affectedElements;
    }

    public E getAffectedElement() {
        if (!this.getAffectedElements().isEmpty()) {
            return this.getAffectedElements().iterator().next();
        }
        throw new RuntimeException("The list affected elements was empty.");
    }
}

