/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class NumberedStringsIterator
implements Iterator<String> {
    private String prefix;
    private long startIndex;
    private long endIndex;

    public NumberedStringsIterator(String string, long l, long l2) {
        this.prefix = string;
        this.startIndex = l;
        this.endIndex = l + l2;
    }

    public NumberedStringsIterator(String string, long l) {
        this(string, 0L, l);
    }

    @Override
    public boolean hasNext() {
        return this.startIndex < this.endIndex;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            ++this.startIndex;
            return this.prefix + (this.startIndex - 1L);
        }
        throw new NoSuchElementException("This iterator does not have more elements.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing elements from this iterator is not legal.");
    }

    public static long extractLongIndexFromString(String string, String string2) {
        if (string.startsWith(string2)) {
            try {
                return Long.parseLong(string.substring(string2.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("\"" + string + "\" is not valid.");
    }

    public static int extractIntIndexFromString(String string, String string2) {
        if (string.startsWith(string2)) {
            try {
                return Integer.parseInt(string.substring(string2.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("\"" + string + "\" is not valid.");
    }
}

