/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.appversion;

import info.bioinfweb.commons.appversion.ApplicationType;

public class ApplicationVersion
implements Comparable<ApplicationVersion>,
Cloneable {
    private int majorRelease = 0;
    private int minorRelease = 0;
    private int patchLevel = 0;
    private long buildNumber = 0L;
    private ApplicationType type = ApplicationType.STABLE;

    public ApplicationVersion() {
    }

    public ApplicationVersion(int n, int n2, int n3, long l, ApplicationType applicationType) {
        this.majorRelease = n;
        this.minorRelease = n2;
        this.patchLevel = n3;
        this.buildNumber = l;
        this.type = applicationType;
    }

    public long getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorRelease() {
        return this.majorRelease;
    }

    public int getMinorRelease() {
        return this.minorRelease;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public void setBuildNumber(long l) {
        this.buildNumber = l;
    }

    public void setMajorRelease(int n) {
        this.majorRelease = n;
    }

    public void setMinorRelease(int n) {
        this.minorRelease = n;
    }

    public void setPatchLevel(int n) {
        this.patchLevel = n;
    }

    public void setType(ApplicationType applicationType) {
        this.type = applicationType;
    }

    public String toString() {
        return this.getMajorRelease() + "." + this.getMinorRelease() + "." + this.getPatchLevel() + "-" + this.getBuildNumber() + " " + (Object)((Object)this.getType());
    }

    public boolean equals(Object object) {
        if (object instanceof ApplicationVersion) {
            ApplicationVersion applicationVersion = (ApplicationVersion)object;
            return applicationVersion.getMajorRelease() == this.getMajorRelease() && applicationVersion.getMinorRelease() == this.getMinorRelease() && applicationVersion.getPatchLevel() == this.getPatchLevel() && applicationVersion.getBuildNumber() == this.getBuildNumber();
        }
        return false;
    }

    @Override
    public int compareTo(ApplicationVersion applicationVersion) {
        if (this.getMajorRelease() == applicationVersion.getMajorRelease()) {
            if (this.getMinorRelease() == applicationVersion.getMinorRelease()) {
                if (this.getPatchLevel() == applicationVersion.getPatchLevel()) {
                    if (this.getBuildNumber() == applicationVersion.getBuildNumber()) {
                        return 0;
                    }
                    if (this.getBuildNumber() > applicationVersion.getBuildNumber()) {
                        return 1;
                    }
                    return -1;
                }
                return this.getPatchLevel() - applicationVersion.getPatchLevel();
            }
            return this.getMinorRelease() - applicationVersion.getMinorRelease();
        }
        return this.getMajorRelease() - applicationVersion.getMajorRelease();
    }

    public ApplicationVersion clone() {
        return new ApplicationVersion(this.getMajorRelease(), this.getMinorRelease(), this.getPatchLevel(), this.getBuildNumber(), this.getType());
    }
}

