/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons;

import info.bioinfweb.commons.Math2;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;

public class RandomValues {
    private static final SecureRandom RANDOM = new SecureRandom();

    public static int randInt(int n, int n2) {
        return (int)(Math.random() * (double)(n2 - n)) + n;
    }

    public static long randLong(long l, long l2) {
        return (long)(Math.random() * (double)(l2 - l)) + l;
    }

    public static float randFloat(float f, float f2) {
        return (float)(Math.random() * (double)(f2 - f)) + f;
    }

    public static double randDouble(double d, double d2) {
        return Math.random() * (d2 - d) + d;
    }

    public static BigDecimal randBigDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return new BigDecimal(Math.random()).multiply(bigDecimal2.subtract(bigDecimal)).add(bigDecimal);
    }

    public static BigInteger randBigInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        return Math2.floorBigDecimalToBigInteger(new BigDecimal(Math.random()).multiply(new BigDecimal(bigInteger2.subtract(bigInteger).toString()))).add(bigInteger);
    }

    public static BigInteger randBigInteger(int n) {
        return new BigInteger(n, RANDOM);
    }

    public static String randHexForBits(int n) {
        return String.format("%x", RandomValues.randBigInteger(n)).toUpperCase();
    }

    public static String randHexForChars(int n) {
        return RandomValues.randChars("0123456789ABCDEF", n);
    }

    public static String randChars(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string.charAt((int)(Math.random() * (double)string.length())));
        }
        return stringBuffer.toString();
    }

    public static <E> void listSwap(List<E> list, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = RandomValues.randInt(0, list.size());
            int n3 = RandomValues.randInt(0, list.size());
            E e = list.get(n2);
            list.set(n2, list.get(n3));
            list.set(n3, e);
        }
    }
}

