/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.commons.bio;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.text.StringUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SequenceUtils {
    public static final char GAP_CHAR = '-';
    public static final char MISSING_DATA_CHAR = '?';
    public static final char MATCH_CHAR = '.';
    public static final char STOP_CODON_CHAR = '*';
    public static final String DNA_CHARS = "CGAT";
    public static final String ALL_DNA_CHARS = "CGATYRKMBVDHN";
    public static final String RNA_CHARS = "CGAU";
    public static final String ALL_RNA_CHARS = "CGAUYRKMBVDHN";
    private static final Map<Character, NucleotideInfo> nucleotideInfoMap = SequenceUtils.createNucleotideInfoMap();
    private static final Map<String, AminoAcidInfo> aminoAcidInfoMap = SequenceUtils.createAminoAcidInfoMap();

    private static Map<Character, NucleotideInfo> createNucleotideInfoMap() {
        TreeMap<Character, NucleotideInfo> treeMap = new TreeMap<Character, NucleotideInfo>();
        treeMap.put(Character.valueOf('A'), new NucleotideInfo('T', new char[0]));
        treeMap.put(Character.valueOf('T'), new NucleotideInfo('A', new char[0]));
        treeMap.put(Character.valueOf('U'), new NucleotideInfo('A', new char[0]));
        treeMap.put(Character.valueOf('C'), new NucleotideInfo('G', new char[0]));
        treeMap.put(Character.valueOf('G'), new NucleotideInfo('C', new char[0]));
        treeMap.put(Character.valueOf('Y'), new NucleotideInfo('R', new char[]{'C', 'T'}));
        treeMap.put(Character.valueOf('R'), new NucleotideInfo('Y', new char[]{'A', 'G'}));
        treeMap.put(Character.valueOf('K'), new NucleotideInfo('M', new char[]{'G', 'T'}));
        treeMap.put(Character.valueOf('M'), new NucleotideInfo('K', new char[]{'A', 'C'}));
        treeMap.put(Character.valueOf('W'), new NucleotideInfo('W', new char[]{'A', 'T'}));
        treeMap.put(Character.valueOf('S'), new NucleotideInfo('S', new char[]{'C', 'G'}));
        treeMap.put(Character.valueOf('B'), new NucleotideInfo('V', new char[]{'C', 'G', 'T'}));
        treeMap.put(Character.valueOf('V'), new NucleotideInfo('B', new char[]{'A', 'C', 'G'}));
        treeMap.put(Character.valueOf('D'), new NucleotideInfo('H', new char[]{'A', 'G', 'T'}));
        treeMap.put(Character.valueOf('H'), new NucleotideInfo('D', new char[]{'A', 'C', 'T'}));
        treeMap.put(Character.valueOf('N'), new NucleotideInfo('N', new char[]{'A', 'T', 'C', 'G'}));
        treeMap.put(Character.valueOf('X'), new NucleotideInfo('X', new char[]{'A', 'T', 'C', 'G'}));
        treeMap.put(Character.valueOf('?'), new NucleotideInfo('?', new char[]{'A', 'T', 'C', 'G', '-'}));
        return treeMap;
    }

    private static void putAminoAcidInfo(Map<String, AminoAcidInfo> map, char c, String string, char ... cArray) {
        AminoAcidInfo aminoAcidInfo = new AminoAcidInfo(c, string, cArray);
        map.put(Character.toString(c), aminoAcidInfo);
        map.put(string.toUpperCase(), aminoAcidInfo);
    }

    private static Map<String, AminoAcidInfo> createAminoAcidInfoMap() {
        TreeMap<String, AminoAcidInfo> treeMap = new TreeMap<String, AminoAcidInfo>();
        SequenceUtils.putAminoAcidInfo(treeMap, 'A', "Ala", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'C', "Cys", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'D', "Asp", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'E', "Glu", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'F', "Phe", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'G', "Gly", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'H', "His", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'I', "Ile", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'K', "Lys", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'L', "Leu", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'M', "Met", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'N', "Asn", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'P', "Pro", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'Q', "Gln", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'R', "Arg", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'S', "Ser", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'T', "Thr", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'V', "Val", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'W', "Trp", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'Y', "Tyr", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'O', "Pyl", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'U', "Sec", new char[0]);
        SequenceUtils.putAminoAcidInfo(treeMap, 'B', "Asx", 'N', 'D');
        SequenceUtils.putAminoAcidInfo(treeMap, 'Z', "Glx", 'Q', 'E');
        SequenceUtils.putAminoAcidInfo(treeMap, 'J', "Xle", 'I', 'L');
        AminoAcidInfo aminoAcidInfo = new AminoAcidInfo('X', "Xaa", new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y', 'O', 'U'});
        treeMap.put("X", aminoAcidInfo);
        treeMap.put("XAA", aminoAcidInfo);
        treeMap.put("UNK", aminoAcidInfo);
        SequenceUtils.putAminoAcidInfo(treeMap, '?', "?", 'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y', 'O', 'U', '-', '*');
        return treeMap;
    }

    public static Set<Character> getNucleotideCharacters() {
        TreeSet<Character> treeSet = new TreeSet<Character>();
        treeSet.addAll(nucleotideInfoMap.keySet());
        treeSet.remove(Character.valueOf('?'));
        return treeSet;
    }

    public static char[] nucleotideConstituents(char c) {
        NucleotideInfo nucleotideInfo = nucleotideInfoMap.get(Character.valueOf(c = Character.toUpperCase(c)));
        if (nucleotideInfo == null) {
            return new char[0];
        }
        return Arrays.copyOf(nucleotideInfo.constituents, nucleotideInfo.constituents.length);
    }

    public static char[] rnaConstituents(char c) {
        char[] cArray = SequenceUtils.nucleotideConstituents(c);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != 'T') continue;
            cArray[i] = 85;
        }
        return cArray;
    }

    public static boolean isNonAmbiguityNucleotide(char c) {
        return (c = Character.toUpperCase(c)) == 'A' || c == 'T' || c == 'C' || c == 'G' || c == 'U';
    }

    public static boolean isNucleotideAmbuguityCode(char c) {
        return SequenceUtils.nucleotideConstituents(c).length > 1;
    }

    public static Set<Character> getAminoAcidOneLetterCodes(boolean bl) {
        TreeSet<Character> treeSet = new TreeSet<Character>();
        for (String string : aminoAcidInfoMap.keySet()) {
            if (string.length() != 1) continue;
            treeSet.add(Character.valueOf(string.charAt(0)));
        }
        if (!bl) {
            treeSet.remove(Character.valueOf('B'));
            treeSet.remove(Character.valueOf('Z'));
            treeSet.remove(Character.valueOf('J'));
            treeSet.remove(Character.valueOf('X'));
        }
        treeSet.remove(Character.valueOf('?'));
        return treeSet;
    }

    public static Set<String> getAminoAcidThreeLetterCodes(boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : aminoAcidInfoMap.keySet()) {
            if (string.length() != 3) continue;
            treeSet.add(string);
        }
        if (!bl) {
            treeSet.remove("ASX");
            treeSet.remove("GLX");
            treeSet.remove("XLE");
            treeSet.remove("XAA");
            treeSet.remove("UNK");
        }
        return treeSet;
    }

    public static char oneLetterAminoAcidByThreeLetter(String string) {
        if (string.length() == 3) {
            AminoAcidInfo aminoAcidInfo = aminoAcidInfoMap.get(string.toUpperCase());
            if (aminoAcidInfo != null) {
                return aminoAcidInfo.oneLetterCode;
            }
            if (string.charAt(0) == string.charAt(1) && string.charAt(0) == string.charAt(2)) {
                return string.charAt(0);
            }
        }
        throw new IllegalArgumentException("The specified string \"" + string + "\" is not a valid three letter amino acid code.");
    }

    public static String threeLetterAminoAcidByOneLetter(char c) {
        AminoAcidInfo aminoAcidInfo = aminoAcidInfoMap.get(Character.toString(c));
        if (aminoAcidInfo != null) {
            return aminoAcidInfo.threeLetterCode;
        }
        return StringUtils.repeat((CharSequence)Character.toString(c), (int)3);
    }

    public static char[] oneLetterAminoAcidConstituents(String string) {
        AminoAcidInfo aminoAcidInfo = aminoAcidInfoMap.get(string.toUpperCase());
        if (aminoAcidInfo != null) {
            return Arrays.copyOf(aminoAcidInfo.constituents, aminoAcidInfo.constituents.length);
        }
        return new char[0];
    }

    public static String[] threeLetterAminoAcidConstituents(String string) {
        char[] cArray = SequenceUtils.oneLetterAminoAcidConstituents(string);
        if (cArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[cArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = SequenceUtils.threeLetterAminoAcidByOneLetter(cArray[i]);
        }
        return stringArray;
    }

    public static boolean isNonAmbiguityAminoAcid(String string) {
        AminoAcidInfo aminoAcidInfo = aminoAcidInfoMap.get(string.toUpperCase());
        return aminoAcidInfo != null && aminoAcidInfo.constituents.length == 0;
    }

    public static boolean isAminoAcidAmbiguityCode(String string) {
        char[] cArray = SequenceUtils.oneLetterAminoAcidConstituents(string);
        return cArray != null && cArray.length > 1;
    }

    public static String reverse(CharSequence charSequence) {
        return StringUtils.invert((CharSequence)charSequence);
    }

    public static char complement(char c) {
        NucleotideInfo nucleotideInfo = nucleotideInfoMap.get(Character.valueOf(Character.toUpperCase(c)));
        if (nucleotideInfo != null) {
            if (Character.isUpperCase(c)) {
                return nucleotideInfo.complement;
            }
            return Character.toLowerCase(nucleotideInfo.complement);
        }
        return c;
    }

    public static String complement(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            stringBuffer.append(SequenceUtils.complement(charSequence.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String reverseComplement(CharSequence charSequence) {
        return SequenceUtils.reverse(SequenceUtils.complement(charSequence));
    }

    public static String rnaToDNA(String string) {
        return string.replaceAll("U", "T").replaceAll("u", "t");
    }

    public static String dnaToRNA(String string) {
        return string.replaceAll("T", "U").replaceAll("t", "u");
    }

    public static boolean isDNAChar(char c) {
        return SequenceUtils.isInTokenSet(Character.toUpperCase(c), ALL_DNA_CHARS);
    }

    public static boolean isRNAChar(char c) {
        return SequenceUtils.isInTokenSet(Character.toUpperCase(c), ALL_RNA_CHARS);
    }

    public static boolean isInTokenSet(char c, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static int lengthWOGaps(CharSequence charSequence) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == '-') continue;
            ++n;
        }
        return n;
    }

    public static String leftSubsequence(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && n3 < n; ++n2) {
            if (string.charAt(n2) == '-') continue;
            ++n3;
        }
        return string.substring(0, n2);
    }

    public static String rightSubsequence(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = string.length() - 1; n2 >= 0 && n3 < n; --n2) {
            if (string.charAt(n2) == '-') continue;
            ++n3;
        }
        return string.substring(n2 + 1);
    }

    public static String deleteFromLeft(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && n3 < n; ++n2) {
            if (string.charAt(n2) == '-') continue;
            ++n3;
        }
        if (n3 < n) {
            throw new IllegalArgumentException("The specified sequence does not contains enough non-gap characters (" + n + ").");
        }
        return string.substring(n2);
    }

    public static String deleteFromRight(String string, int n) {
        int n2;
        int n3 = 0;
        for (n2 = string.length() - 1; n2 >= 0 && n3 < n; --n2) {
            if (string.charAt(n2) == '-') continue;
            ++n3;
        }
        if (n3 < n) {
            throw new IllegalArgumentException("The specified sequence does not contains enough non-gap characters (" + n + ").");
        }
        return string.substring(0, n2 + 1);
    }

    public static String deleteLeadingGaps(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == '-'; ++n) {
        }
        return string.substring(n);
    }

    public static String deleteTrailingGaps(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == '-'; --n) {
        }
        return string.substring(0, n + 1);
    }

    public static String deleteGapsFromLeft(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '-' && n2 < n) {
                ++n2;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String deleteGapsFromRight(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == '-' && n2 < n) {
                ++n2;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return StringUtils.invert((CharSequence)stringBuilder);
    }

    public static String deleteLeadingTrailingGaps(String string) {
        return SequenceUtils.deleteLeadingGaps(SequenceUtils.deleteTrailingGaps(string));
    }

    public static String deleteAllGaps(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == '-') continue;
            stringBuffer.append(charSequence.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String randSequence(boolean bl, int n, double d, double d2, double d3) {
        double[] dArray;
        dArray = new double[]{0.0, d, d + d2, dArray[2] + d3, 1.0};
        String string = DNA_CHARS;
        if (!bl) {
            string = RNA_CHARS;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            double d4 = Math.random();
            int n2 = 0;
            while (!Math2.isBetween((double)d4, (double)dArray[n2], (double)dArray[n2 + 1])) {
                ++n2;
            }
            stringBuffer.append(string.charAt(n2));
        }
        return stringBuffer.toString();
    }

    public static String randSequence(boolean bl, int n, double d) {
        double d2 = d / 2.0;
        return SequenceUtils.randSequence(bl, n, d2, d2, (1.0 - d) / 2.0);
    }

    public static Map<Character, Double> nucleotideFrequencies(char[] cArray) {
        Object object;
        TreeMap<Character, Double> treeMap = new TreeMap<Character, Double>();
        treeMap.put(Character.valueOf('A'), 0.0);
        treeMap.put(Character.valueOf('T'), 0.0);
        treeMap.put(Character.valueOf('C'), 0.0);
        treeMap.put(Character.valueOf('G'), 0.0);
        double d = 0.0;
        for (int i = 0; i < cArray.length; ++i) {
            object = SequenceUtils.nucleotideConstituents(cArray[i]);
            if (((char[])object).length == 0) {
                object = new char[]{cArray[i]};
            }
            double d2 = 1.0 / (double)((char[])object).length;
            for (int j = 0; j < ((char[])object).length; ++j) {
                if (!SequenceUtils.isNonAmbiguityNucleotide(object[j])) continue;
                treeMap.put(Character.valueOf(object[j]), (Double)treeMap.get(Character.valueOf(object[j])) + d2);
                d += d2;
            }
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Character)iterator.next();
            treeMap.put((Character)object, (Double)treeMap.get(object) / d);
        }
        return treeMap;
    }

    public static char nucleotideConsensus(char[] cArray) {
        Map<Character, Double> map = SequenceUtils.nucleotideFrequencies(cArray);
        char c = ' ';
        double d = -1.0;
        for (Character c2 : map.keySet()) {
            if (!(map.get(c2) > d)) continue;
            c = c2.charValue();
            d = map.get(c2);
        }
        return c;
    }

    public static Map<Character, Double> aminoAcidFrequencies(String[] stringArray) {
        Object object;
        TreeMap<Character, Double> treeMap = new TreeMap<Character, Double>();
        for (Character c : SequenceUtils.getAminoAcidOneLetterCodes(false)) {
            treeMap.put(c, 0.0);
        }
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            object = SequenceUtils.oneLetterAminoAcidConstituents(stringArray[i]);
            if (((char[])object).length == 0) {
                object = stringArray[i].length() == 1 ? new char[]{stringArray[i].charAt(0)} : new char[]{SequenceUtils.oneLetterAminoAcidByThreeLetter(stringArray[i])};
            }
            if (object == null || ((char[])object).length > 2) continue;
            double d2 = 1.0 / (double)((char[])object).length;
            for (int j = 0; j < ((char[])object).length; ++j) {
                if (!SequenceUtils.isNonAmbiguityAminoAcid(Character.toString(object[j]))) continue;
                treeMap.put(Character.valueOf(object[j]), (Double)treeMap.get(Character.valueOf(object[j])) + d2);
                d += d2;
            }
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Character)iterator.next();
            treeMap.put((Character)object, (Double)treeMap.get(object) / d);
        }
        return treeMap;
    }

    public static char aminoAcidConsensus(String[] stringArray) {
        Map<Character, Double> map = SequenceUtils.aminoAcidFrequencies(stringArray);
        char c = ' ';
        double d = -1.0;
        for (Character c2 : map.keySet()) {
            if (!(map.get(c2) > d)) continue;
            c = c2.charValue();
            d = map.get(c2);
        }
        return c;
    }

    private static class AminoAcidInfo {
        private char oneLetterCode;
        private String threeLetterCode;
        private char[] constituents;

        public AminoAcidInfo(char c, String string, char[] cArray) {
            this.oneLetterCode = c;
            this.threeLetterCode = string;
            this.constituents = cArray;
        }
    }

    private static class NucleotideInfo {
        public char complement;
        public char[] constituents;

        public NucleotideInfo(char c, char[] cArray) {
            this.complement = c;
            this.constituents = cArray;
        }
    }
}

