/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.wikihelp.client;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class WikiHelp {
    public static final String CODE_REDIRECTOR = "redirect/";
    public static final String WIKI_FOLDER = "wiki/";
    public static final String INDEX_TOPIC = "Special:Allpages";
    private String wikiURL = null;
    private String redirectURL = null;

    public WikiHelp(String wikiHelpURL) {
        this.wikiURL = String.valueOf(wikiHelpURL) + WIKI_FOLDER;
        this.redirectURL = String.valueOf(wikiHelpURL) + CODE_REDIRECTOR;
    }

    public WikiHelp(String wikiURL, String redirectURL) {
        this.wikiURL = wikiURL;
        this.redirectURL = redirectURL;
    }

    public void displayTopic(int code) {
        this.setPage(String.valueOf(this.redirectURL) + code);
    }

    public void displayTopic(String name) {
        this.setPage(String.valueOf(this.wikiURL) + name);
    }

    public void displayContents() {
        this.displayTopic("");
    }

    public void displayIndex() {
        this.displayTopic(INDEX_TOPIC);
    }

    public void setPage(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

