/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.wikihelp.client;

import info.bioinfweb.wikihelp.client.WikiHelp;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class JHTMLLabel
extends JEditorPane {
    public static final String WIKI_HELP_PROTOCOL = "wikihelp://";
    private final JHTMLLabel THIS = this;
    private WikiHelp wikiHelp = null;
    public final HyperlinkListener HYPERLINK_LISTENER = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            block8: {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        if (e.getDescription().startsWith(JHTMLLabel.WIKI_HELP_PROTOCOL)) {
                            String text = e.getDescription().substring(JHTMLLabel.WIKI_HELP_PROTOCOL.length());
                            int topic = -1;
                            try {
                                topic = Integer.parseInt(text);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (topic > -1) {
                                JHTMLLabel.this.getWikiHelp().displayTopic(topic);
                            } else {
                                JHTMLLabel.this.getWikiHelp().displayTopic(text);
                            }
                            break block8;
                        }
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(JHTMLLabel.this.THIS), "An error occurred when trying open the selected link.", "Navigation failed,", 0);
                    }
                }
            }
        }
    };

    public JHTMLLabel() {
        this.setBackground(SystemColor.menu);
        this.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(bodyRule);
        this.setEditable(false);
        this.setBorder(null);
        this.addHyperlinkListener(this.HYPERLINK_LISTENER);
    }

    public JHTMLLabel(WikiHelp wikiHelp) {
        this();
        this.wikiHelp = wikiHelp;
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.setCaretPosition(0);
    }

    public void setHTMLContent(String content) {
        this.setText("<html><body>" + content + "</body></html>");
    }

    public WikiHelp getWikiHelp() {
        return this.wikiHelp;
    }

    public void setWikiHelp(WikiHelp wikiHelp) {
        this.wikiHelp = wikiHelp;
    }
}

