/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

class nexim {
    nexim(String filename, ArrayList sequences, ArrayList primers, ArrayList charsets, Vector taxSets, boolean removePrimers) throws IOException {
        sequences.clear();
        File file = new File(filename);
        FileReader fr = new FileReader(file);
        this.tokenize(fr, sequences, primers, charsets, taxSets, removePrimers);
        this.alignNames(sequences);
        fr.close();
    }

    void alignNames(ArrayList sequences) {
        int maxLength = 0;
        Iterator i = sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            if (maxLength >= s.name.length()) continue;
            maxLength = s.name.length();
        }
        Iterator i2 = sequences.iterator();
        while (i2.hasNext()) {
            sequence s = (sequence)i2.next();
            for (int c = 0; c <= maxLength - s.name.length() + 1; ++c) {
                s.nameAligned = s.nameAligned + " ";
            }
        }
    }

    void tokenize(FileReader r, ArrayList sequences, ArrayList primers, ArrayList charsets, Vector taxsets, boolean removePrimers) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.eolIsSignificant(false);
        int seqlen = 0;
        do {
            tok.nextToken();
            if (tok.ttype != -1) continue;
            throw new IOException();
        } while (!tok.sval.equalsIgnoreCase("matrix"));
        do {
            tok.nextToken();
            String nam = tok.sval;
            if (tok.ttype != -1) {
                tok.nextToken();
            }
            String seq = tok.sval;
            sequence s = new sequence(nam, seq);
            if (!s.name.equals(";")) {
                s.sequence = s.sequence.toUpperCase();
                sequences.add(s);
                seqlen = s.sequence.length();
            }
        } while (tok.ttype != -1 && !tok.sval.equalsIgnoreCase("end;"));
        tok.whitespaceChars(61, 61);
        charsets.clear();
        taxsets.clear();
        do {
            tok.nextToken();
            if (tok.ttype == -3) {
                String name;
                ArrayList<String> parts;
                if (tok.sval.equalsIgnoreCase("charset")) {
                    parts = new ArrayList<String>();
                    tok.nextToken();
                    name = tok.sval;
                    do {
                        tok.nextToken();
                        parts.add(tok.sval);
                    } while (!tok.sval.endsWith(";"));
                    charset cs = new charset(name, parts);
                    charsets.add(cs);
                }
                if (tok.sval.equalsIgnoreCase("taxset")) {
                    parts = new ArrayList();
                    tok.nextToken();
                    name = tok.sval;
                    do {
                        tok.nextToken();
                        parts.add(tok.sval);
                    } while (!tok.sval.endsWith(";"));
                    taxset ts = new taxset(name, parts);
                    taxsets.add(ts);
                }
            }
        } while (tok.ttype != -1);
        ListIterator iS = sequences.listIterator();
        int counter = 0;
        int start = 0;
        int end = 0;
        while (iS.hasNext()) {
            sequence s = (sequence)iS.next();
            counter = 0;
            start = 0;
            end = 0;
            for (int i = 0; i < s.sequence.length(); ++i) {
                if (s.sequence.charAt(i) == '?' || s.sequence.charAt(i) == '-') continue;
                if (start == 0) {
                    start = i;
                }
                end = i;
                ++counter;
            }
            if (!removePrimers || counter >= 30 || counter <= 10) continue;
            primer p = new primer(start, end, s.name, s.sequence);
            Iterator pi = primers.iterator();
            boolean alreadythere = false;
            while (pi.hasNext()) {
                primer pp = (primer)pi.next();
                if (!pp.name.equals(p.name)) continue;
                alreadythere = true;
            }
            if (!alreadythere) {
                p.countNts();
                p.RC();
                p.isAligned = true;
                p.readFromAlignment = true;
                primers.add(p);
            }
            alreadythere = false;
            if (!removePrimers) continue;
            iS.remove();
        }
        boolean alreadythere = false;
        Iterator pit = primers.iterator();
        while (pit.hasNext()) {
            primer pp = (primer)pit.next();
            if (!pp.sequence.equals("outside")) continue;
            alreadythere = true;
        }
        if (!alreadythere) {
            primer pOut1 = new primer(-30, -10, "upstream F", "outside");
            primer pOut2 = new primer(seqlen + 10, seqlen + 30, "downstream R", "outside");
            pOut1.external = true;
            pOut2.external = true;
            pOut1.comment1 = "Forward primer upstream of matrix";
            pOut1.comment2 = "(one of those used to amplify the region).";
            pOut1.comment3 = "Added by SeqState to accommodate gaps at 5' end.";
            pOut1.designedBy = "[this is no actual primer]";
            pOut2.comment1 = "Reverse primer downstream of matrix";
            pOut2.comment2 = "(one of those used to amplify the region).";
            pOut2.comment3 = "Added by SeqState to accommodate gaps at 3' end.";
            pOut2.designedBy = "[this is no actual primer]";
            primers.add(pOut1);
            primers.add(pOut2);
        }
        System.out.println(sequences.size() + " taxa read:");
        ListIterator iN1 = sequences.listIterator();
        int a = 0;
        while (iN1.hasNext()) {
            sequence s = (sequence)iN1.next();
            System.out.println(++a + "\t" + s.name);
        }
        ListIterator CSi = charsets.listIterator();
        if (CSi.hasNext()) {
            System.out.println("\n" + charsets.size() + " charsets recognized: \n");
        } else {
            System.out.println("no charsets");
        }
        while (CSi.hasNext()) {
            charset cs = (charset)CSi.next();
            System.out.print(cs.name + ": ");
            ListIterator pi = cs.parts.listIterator();
            while (pi.hasNext()) {
                charset.part p = (charset.part)pi.next();
                if (pi.hasNext()) {
                    System.out.print(p.from + " to " + p.to + ", ");
                    continue;
                }
                System.out.println(p.from + " to " + p.to);
            }
        }
        Iterator ti = taxsets.iterator();
        if (ti.hasNext()) {
            System.out.println("\n" + charsets.size() + " taxsets recognized: \n");
        } else {
            System.out.println("no taxsets");
        }
        while (ti.hasNext()) {
            taxset ts = (taxset)ti.next();
            System.out.print(ts.name + ": ");
            ListIterator pi = ts.parts.listIterator();
            while (pi.hasNext()) {
                taxset.part p = (taxset.part)pi.next();
                if (pi.hasNext()) {
                    System.out.print(p.from + " to " + p.to + ", ");
                    continue;
                }
                System.out.println(p.from + " to " + p.to);
            }
        }
    }
}

