/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class SiteStrucStat
extends JFrame {
    private JButton jButton1;
    private JButton cds2;
    private JButton cds;
    private JTextField jTextField1;

    public SiteStrucStat() {
        this.initComponents();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.cds = new JButton();
        this.cds2 = new JButton();
        this.jTextField1 = new JTextField();
        this.setTitle("SiteStruct- Statistic");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SiteStrucStat.this.exitForm(evt);
            }
        });
        this.jButton1.setText("import");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SiteStrucStat.this.jButton1ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton1, "Center");
        this.cds.setText("create cds");
        this.cds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SiteStrucStat.this.cdsActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.cds, "North");
        this.cds2.setText("cds2");
        this.cds2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SiteStrucStat.this.cds2ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.cds2, "West");
        this.jTextField1.setText("100");
        this.getContentPane().add((Component)this.jTextField1, "South");
        this.pack();
    }

    private void cds2ActionPerformed(ActionEvent evt) {
        FileDialog fd = new FileDialog((Frame)this, "Import list with sites (first = number of AllChars, second = number of observed in list)...");
        fd.setVisible(true);
        String file = fd.getDirectory() + fd.getFile();
        try {
            FileReader fr = new FileReader(file);
            System.out.println("opened " + file + "\n");
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            int nrOfAllChars = 1;
            int nchar = 1;
            int[] observedSites = new int[10000];
            for (int i = 0; i < 10000; ++i) {
                observedSites[i] = -1;
            }
            tok.nextToken();
            nrOfAllChars = Integer.parseInt(tok.sval);
            tok.nextToken();
            nchar = Integer.parseInt(tok.sval);
            int ctr = 0;
            while (true) {
                if (tok.nextToken() == -1) break;
                observedSites[ctr] = Integer.parseInt(tok.sval);
                ++ctr;
            }
            int nrOfObs = ctr;
            ctr = 0;
            int nrOfSampled = (int)(0.6321205588285577 * (double)nrOfAllChars);
            System.out.println("sampled chars:" + nrOfSampled + "\n");
            try {
                File f = new File(file + ".cds");
                FileWriter fw = new FileWriter(f);
                fw.write("begin PAUP;\n\n");
                fw.write("factory;\n");
                fw.write("set maxtrees=1 incr=no;\n");
                fw.write("set status=no;\n");
                fw.write("log file=SiteStruct.log;");
                for (int i = 0; i < 100; ++i) {
                    int k;
                    fw.write("include all;\n ");
                    int[] PosChosen = new int[nrOfSampled];
                    for (k = 0; k < nrOfSampled; ++k) {
                        do {
                            PosChosen[k] = (int)(Math.random() * (double)nrOfAllChars + 1.0);
                        } while (this.alreadyThere(PosChosen, k));
                    }
                    fw.write("[!" + i + "a cycle: all included (1-(1/e) only)]\n");
                    fw.write("include ");
                    for (k = 0; k < nrOfSampled; ++k) {
                        fw.write(PosChosen[k] + " ");
                    }
                    fw.write("/only;\n");
                    fw.write("include ");
                    for (k = 0; k < nrOfObs; ++k) {
                        fw.write(observedSites[k] + " ");
                    }
                    fw.write(";\n");
                    fw.write("bootstr search=faststep nrep=100;\n");
                    fw.write("[!" + i + "b cycle: observedSites deleted (no matter whether present atall]\n");
                    fw.write("exclude ");
                    for (k = 0; k < nrOfObs; ++k) {
                        fw.write(observedSites[k] + " ");
                    }
                    fw.write(";\n");
                    fw.write("bootstr search=faststep nrep=100;\n");
                }
                fw.write("end;\n");
                fw.flush();
                fw.close();
                System.out.println("cds written");
            }
            catch (IOException e) {
                System.out.println("file error");
            }
        }
        catch (IOException e) {
            System.out.println("file error");
        }
    }

    private void cdsActionPerformed(ActionEvent evt) {
        FileDialog fd = new FileDialog((Frame)this, "Import list with sites (all pi; first = nchar)...");
        fd.setVisible(true);
        String file = fd.getDirectory() + fd.getFile();
        try {
            FileReader fr = new FileReader(file);
            System.out.println("opened " + file + "\n");
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            int nchar = 1;
            int[] observedSites = new int[10000];
            for (int i = 0; i < 10000; ++i) {
                observedSites[i] = -1;
            }
            tok.nextToken();
            nchar = Integer.parseInt(tok.sval);
            int ctr = 0;
            while (true) {
                if (tok.nextToken() == -1) break;
                observedSites[ctr] = Integer.parseInt(tok.sval);
                ++ctr;
            }
            int nrOfObs = ctr;
            ctr = 0;
            try {
                File f = new File(file + ".cds");
                FileWriter fw = new FileWriter(f);
                fw.write("begin PAUP;\n\n");
                fw.write("factory;\n");
                fw.write("set maxtrees=1 incr=no;\n");
                fw.write("set status=no;\n");
                fw.write("log file=SiteStruct.log;");
                for (int i = 0; i < 500; ++i) {
                    int k;
                    fw.write("[!" + i + "a cycle: all observed excluded]\n");
                    fw.write("include all;\n");
                    fw.write("exclude ");
                    for (int k2 = 0; k2 < nrOfObs; ++k2) {
                        fw.write(observedSites[k2] + " ");
                    }
                    fw.write(";\n");
                    fw.write("bootstr search=faststep nrep=100;\n");
                    int[] PosChosen = new int[nrOfObs];
                    for (k = 0; k < nrOfObs; ++k) {
                        do {
                            PosChosen[k] = (int)(Math.random() * (double)nchar + 1.0);
                        } while (this.alreadyThere(PosChosen, k));
                    }
                    fw.write("[!" + i + "b cycle: control (nrOfObs excluded from all sites randomly)]\n");
                    fw.write("include all;\n");
                    fw.write("exclude ");
                    for (k = 0; k < nrOfObs; ++k) {
                        fw.write(PosChosen[k] + " ");
                    }
                    fw.write(";\n");
                    fw.write("bootstr search=faststep nrep=100;\n");
                }
                fw.write("end;\n");
                fw.flush();
                fw.close();
                System.out.println("cds written");
            }
            catch (IOException e) {
                System.out.println("file error");
            }
        }
        catch (IOException e) {
            System.out.println("file error");
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int nrOfNodes = Integer.parseInt(this.jTextField1.getText()) - 2;
        System.out.println("\n" + nrOfNodes + "nodes\n");
        FileDialog fd = new FileDialog((Frame)this, "Import SiteStruct export file...");
        fd.setVisible(true);
        String file = fd.getDirectory() + fd.getFile();
        try {
            FileReader fr = new FileReader(file);
            System.out.println("opened " + file + "\n");
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            double[] anyDel = new double[10000];
            double[] testedDel = new double[10000];
            double[] Dif = new double[10000];
            for (int i = 0; i < 10000; ++i) {
                anyDel[i] = -1000.0;
                testedDel[i] = -1000.0;
                Dif[i] = -1000.0;
            }
            int ctr = 0;
            String number = "";
            do {
                tok.nextToken();
                if (tok.ttype == -1) break;
                anyDel[ctr] = Double.parseDouble(tok.sval) / (double)nrOfNodes;
                tok.nextToken();
                if (tok.ttype == -1) break;
                testedDel[ctr] = Double.parseDouble(tok.sval) / (double)nrOfNodes;
                Dif[ctr] = anyDel[ctr] - testedDel[ctr];
                System.out.println(Dif[ctr]);
                ++ctr;
            } while (tok.ttype != -1);
            System.out.println("\n\nread " + ctr + "\n\n");
            double sumDif = 0.0;
            double meanDif = 0.0;
            ctr = 0;
            while (ctr <= 10000 && Dif[ctr] != -1000.0) {
                if (Dif[ctr] == -1000.0) continue;
                sumDif += Dif[ctr];
                ++ctr;
            }
            System.out.println("\n\n" + ctr + "\n\n");
            meanDif = sumDif / (double)ctr;
            ctr = 0;
            double sqrsumDif = 0.0;
            while (ctr <= 10000 && Dif[ctr] != -1000.0) {
                if (Dif[ctr] == -1000.0) continue;
                sqrsumDif += (meanDif - Dif[ctr]) * (meanDif - Dif[ctr]);
                ++ctr;
            }
            System.out.println("\nN:" + ctr + "\n");
            System.out.println("mean d:" + meanDif + "\n");
            System.out.println("sqrsumDif: " + sqrsumDif + "\n");
            double var = 1.0 / ((double)ctr - 1.0) * sqrsumDif;
            double se = Math.sqrt(var);
            System.out.println("se: " + se);
            System.out.println("confidence interval 0.95: " + (meanDif - 1.96 * se) + " - " + meanDif + " - " + (meanDif + 1.96 * se) + "\n");
        }
        catch (IOException e) {
            System.out.println("file error");
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new SiteStrucStat().show();
    }

    boolean alreadyThere(int[] PosChosen, int x) {
        for (int a = 0; a < x; ++a) {
            if (PosChosen[a] != PosChosen[x]) continue;
            return true;
        }
        return false;
    }
}

