/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class SimpleIndelCoding {
    ArrayList indels;
    ArrayList sequences;
    String file = "";
    String version = "";
    String date = "";
    int sequenceLength = 0;
    int nameLength = 0;
    int singletons = 0;
    String st = "";
    boolean barriel = false;
    boolean bena = false;
    int fifthWithBena = 0;

    public SimpleIndelCoding(ArrayList sequences, String filepath, String version, String date, boolean filter, boolean ignore, String st, boolean includeBorderIndels) {
        this.version = version;
        this.date = date;
        this.st = st;
        if (st.equalsIgnoreCase("Barriel (1994)")) {
            this.barriel = true;
        }
        if (st.equalsIgnoreCase("Bena et al. (1998) - 5th states")) {
            this.bena = true;
        }
        this.indels = new ArrayList();
        this.sequences = sequences;
        this.file = this.removeFileExtension(filepath);
        IndelScreening is = new IndelScreening(sequences, this.indels, filter, ignore, includeBorderIndels);
        if (this.barriel) {
            Iterator ii = sequences.iterator();
            while (ii.hasNext()) {
                sequence ss = (sequence)ii.next();
                ss.barSeq = ss.sequence;
            }
            Iterator ind = this.indels.iterator();
            while (ind.hasNext()) {
                Indel indel = (Indel)ind.next();
                if (indel.from != indel.to) continue;
                int seqNr = 0;
                Iterator it = sequences.iterator();
                while (it.hasNext()) {
                    sequence se = (sequence)it.next();
                    if (indel.stateInTaxa[seqNr] == '1') {
                        int b = se.sequence.length();
                        char[] buf = new char[b];
                        buf = se.barSeq.toCharArray();
                        buf[indel.from - 1] = 35;
                        se.barSeq = "";
                        for (int a = 0; a < b; ++a) {
                            se.barSeq = se.barSeq + buf[a];
                        }
                    }
                    ++seqNr;
                }
            }
        } else if (this.bena) {
            Iterator ind = this.indels.iterator();
            int curFrom = 0;
            while (ind.hasNext()) {
                Indel indel = (Indel)ind.next();
                if (indel.from <= curFrom) continue;
                Vector<Indel> IndelsWithSameStart = new Vector<Indel>();
                IndelsWithSameStart.add(indel);
                curFrom = indel.from;
                Iterator ind2 = this.indels.iterator();
                while (ind2.hasNext()) {
                    Indel indel2 = (Indel)ind2.next();
                    if (indel.from != indel2.from || indel.to == indel2.to) continue;
                    curFrom = indel2.from;
                    IndelsWithSameStart.add(indel2);
                }
                String availableChars = "0123456789#$EF.IJ&L%>OPQ/'U:*X<Z\"";
                int seqNr = 0;
                ++this.fifthWithBena;
                Iterator it = sequences.iterator();
                while (it.hasNext()) {
                    sequence se = (sequence)it.next();
                    for (int bb = 0; bb < IndelsWithSameStart.size(); ++bb) {
                        Indel indel3 = (Indel)IndelsWithSameStart.elementAt(bb);
                        if (indel3.stateInTaxa[seqNr] != '1') continue;
                        int b = se.benaSeq.length();
                        char[] buf = new char[b];
                        buf = se.benaSeq.toCharArray();
                        if (bb >= availableChars.length()) {
                            System.out.print("Bena- encoding impossible, too many states required at " + indel3.name);
                            return;
                        }
                        buf[indel3.from - 1] = availableChars.charAt(bb);
                        se.benaSeq = "";
                        for (int a = 0; a < b; ++a) {
                            se.benaSeq = se.benaSeq + buf[a];
                        }
                    }
                    ++seqNr;
                }
            }
        }
        try {
            this.writeSimpleCoding();
            System.out.print("\nDone\n");
        }
        catch (Exception e) {
            System.out.print("\nWriter problem");
        }
    }

    public void writeSimpleCoding() throws IOException {
        String str = "_sic.nex";
        if (this.barriel) {
            str = "_br.nex";
        }
        if (this.bena) {
            str = "_be.nex";
        }
        File f = new File(this.file + str);
        FileWriter fw = new FileWriter(f);
        this.writeNexHead(fw);
        fw.write("\nMATRIX\n\n");
        Iterator it0 = this.sequences.iterator();
        sequence s0 = (sequence)it0.next();
        this.sequenceLength = s0.sequence.length();
        this.nameLength = s0.nameAligned.length();
        this.writeNumbersAbove(1, this.sequenceLength, this.nameLength + 1, fw);
        Iterator it = this.sequences.iterator();
        while (it.hasNext()) {
            sequence s = (sequence)it.next();
            if (this.barriel) {
                fw.write(s.nameAligned + " " + s.barSeq + "\n");
                continue;
            }
            if (this.bena) {
                fw.write(s.nameAligned + " " + s.benaSeq + "\n");
                continue;
            }
            fw.write(s.nameAligned + " " + s.sequence + "\n");
        }
        fw.write("\n\n");
        fw.write("[" + this.indels.size() + " indels coded]\n\n");
        if (this.barriel) {
            fw.write("[" + this.singletons + " of them as fifth states ('#') in the matrix]\n\n");
        }
        if (this.bena) {
            fw.write("[as 5th, 6th, etc., states in the matrix]\n\n");
        }
        if (!this.bena) {
            this.writeNumbersAbove(this.sequenceLength + 1, this.sequenceLength + this.indels.size(), this.nameLength + 1, fw);
            if (this.fifthWithBena == this.indels.size() || this.singletons == this.indels.size()) {
                fw.write("[");
            }
            Iterator si = this.sequences.iterator();
            int seqNr = 0;
            while (si.hasNext()) {
                sequence s = (sequence)si.next();
                fw.write(s.nameAligned + " ");
                Iterator ini = this.indels.iterator();
                while (ini.hasNext()) {
                    Indel ind = (Indel)ini.next();
                    if (this.barriel && ind.to == ind.from) continue;
                    fw.write(ind.stateInTaxa[seqNr]);
                }
                ++seqNr;
                fw.write("\n");
            }
            if (this.fifthWithBena == this.indels.size() || this.singletons == this.indels.size()) {
                fw.write("]");
            }
        }
        fw.write(";\n");
        fw.write("END;\n");
        fw.write("\nBEGIN SETS;\n");
        Iterator itt = this.sequences.iterator();
        sequence s = (sequence)itt.next();
        int charNr = s.sequence.length();
        if (!this.bena && !this.barriel) {
            fw.write("  CHARSET indels = " + (charNr + 1) + "-" + (charNr + this.indels.size() - this.singletons) + ";\n");
        }
        fw.write("END;\n\n");
        fw.write("BEGIN PAUP;\n");
        fw.write("END;\n");
        this.writeIndelInfo(fw);
        fw.flush();
        fw.close();
    }

    public void writeNexHead(FileWriter fw) throws IOException {
        fw.write("#NEXUS\n");
        fw.write("[!matrix with indels coded according to " + this.st + "]\n");
        Date d = new Date();
        fw.write("[!compiled on " + d + " with SeqState version " + this.version + " build " + this.date + "]\n\n");
        fw.write("BEGIN CHARACTERS;\n");
        fw.write("DIMENSIONS newtaxa ntax=" + this.sequences.size() + " NCHAR=");
        Iterator it = this.sequences.iterator();
        sequence s = (sequence)it.next();
        int charNr = s.sequence.length();
        this.singletons = 0;
        if (this.barriel) {
            Iterator ini = this.indels.iterator();
            while (ini.hasNext()) {
                Indel ind = (Indel)ini.next();
                if (!this.barriel || ind.to != ind.from) continue;
                ++this.singletons;
            }
            fw.write(charNr + this.indels.size() - this.singletons + ";\n");
        } else if (this.bena) {
            fw.write(charNr + ";\n");
        } else {
            fw.write(charNr + this.indels.size() + ";\n");
        }
        fw.write("FORMAT \n");
        fw.write("\tDATATYPE = standard \n");
        fw.write("\tGAP = - \n");
        fw.write("\tMISSING = ? \n");
        fw.write("\tsymbols=\"0123456789A#C$EFG.IJ&L%>OPQ/'TU:*X<Z\" \n");
        fw.write("\tequate=\"R={AG} Y={CT} M={AC} K={GT} S={CG} W={AT} H={ACT} B={CGT} V={ACG} D={AGT} N={ACGT} r={AG} y={CT} m={AC} k={GT} s={CG} w={AT} h={ACT} b={CGT} v={ACG} d={AGT} n={ACGT}\"\n");
        fw.write("INTERLEAVE;\n");
        if (!this.bena) {
            fw.write("CHARSTATELABELS\n");
            Iterator ii = this.indels.iterator();
            while (ii.hasNext()) {
                ++charNr;
                Indel in = (Indel)ii.next();
                if (this.barriel && in.to == in.from) {
                    --charNr;
                    continue;
                }
                fw.write("\t" + charNr + "\t" + "indel" + in.nr + "_" + in.name + "\n");
            }
            fw.write(";\n");
        }
    }

    public String removeFileExtension(String longname) {
        int pos = longname.length();
        for (int i = longname.length() - 1; i >= 0; --i) {
            if (longname.charAt(i) != '.') continue;
            pos = i;
            break;
        }
        return longname.substring(0, pos);
    }

    public void writeIndelInfo(FileWriter fw) throws IOException {
        fw.write("\n\n[Indels:\n\nNo.\textension\n\n");
        Iterator ini = this.indels.iterator();
        while (ini.hasNext()) {
            fw.write(" ");
            Indel in = (Indel)ini.next();
            fw.write(in.nr + "\t" + in.from + "-" + in.to + "\n");
        }
        fw.write("]\n\n");
    }

    public void writeNumbersAbove(int start, int end, int indent, FileWriter fw) throws IOException {
        Vector<String> nrLabels = new Vector<String>();
        String rows = Integer.toString(end);
        int height = rows.length();
        for (int i = start; i <= end; ++i) {
            String nr = Integer.toString(i);
            nrLabels.add(nr);
        }
        for (int c = 0; c < height; ++c) {
            int d;
            if (c == 0) {
                for (d = 0; d < indent - 1; ++d) {
                    fw.write(" ");
                }
                fw.write("[");
            } else {
                for (d = 0; d < indent; ++d) {
                    fw.write(" ");
                }
            }
            Iterator it = nrLabels.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.length() > c) {
                    fw.write(s.charAt(c));
                    continue;
                }
                fw.write(" ");
            }
            if (c == height - 1) {
                fw.write("]");
            }
            fw.write("\n");
        }
        fw.write("\n");
    }
}

