/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;

public class SeqState
extends Frame {
    Comparator byName = new PrimerNameComparator();
    Comparator byRegion = new PrimerRegionComparator();
    Comparator byTaxa = new PrimerTaxaComparator();
    Comparator byLabcode = new PrimerLabcodeComparator();
    Comparator byDesign = new PrimerDesignComparator();
    Comparator byReference = new PrimerReferenceComparator();
    Comparator charSetsByLocation = new CharSetComparator();
    String version = "1.4.1";
    String date = "02.10.2009";
    int nrep = 100;
    int toSample = 0;
    boolean interleave = false;
    boolean inBlocks = false;
    int blockSize = 10;
    boolean whole = false;
    boolean border = false;
    boolean filter = false;
    boolean PaupCorrOfInco = false;
    ArrayList sequences;
    ArrayList primers;
    ArrayList completeSequences;
    ArrayList newprimers;
    ArrayList charsets;
    Vector taxsets;
    static int nrOfCodings = 10;
    int nrOfChar = 0;
    int nrOfTaxa = 0;
    int nrOfCharsets = 0;
    int nrOfPrimers = 0;
    String GenBankFile = "";
    String GenBankList = "";
    String primersLoaded = "";
    String primersSaved = "";
    String filename = "";
    String msg;
    String dis;
    String curFile = "no data file loaded";
    String charset1 = "";
    String charset2 = "";
    String indelCodingMethod = null;
    int loopsize = 15;
    int lowerMotifBoundary = 5;
    int upperMotifBoundary = 100;
    int costMatrixSize = 15;
    double maxMismatchScore = 0.15;
    boolean outputBases = false;
    String PaupIniBlock = "BEGIN PAUP;\n\tSet autoclose=yes warnreset=no notifybeep=no warntsave=no\n\t\tmaxtrees=1000 increase=auto;\nEND;";
    String PaupBlock = "BEGIN PAUP;\n\tSet criterion=distance;\n\tDset distance=neili;\n\tHsearch swap=tbr; \n\tConTree all/grpfreq=no showtree=yes usetreewts=no strict=yes \n\t\troot=outgroup outroot=polytomy treefile=CRAPXXXdist.tre append;\nEND;";
    String endBlock = "quit;\t";
    int ignore = 50;
    int len = 600;
    int maxdis = 200;
    NumberFormat df = DecimalFormat.getInstance();
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Window window;
    Image image;
    ProgressMonitor pm;
    int ROSEruns = 100;
    String ROSEfilename = "";
    String curROSEFile = "";
    Vector datasets = new Vector();
    double probP = 25.0;
    double probA = 25.0;
    double probC = 25.0;
    private Desktop desktop;
    double probG = 25.0;
    double probT = 25.0;
    int gapLengthSimple = 50;
    private MenuItem About;
    private MenuItem Charsets;
    private MenuItem Design;
    private MenuItem Design2;
    private Menu File;
    private MenuItem GapSettings;
    private Menu Gaps;
    private MenuItem GenBank;
    private MenuItem Help;
    private Menu HelpMenu;
    private Menu Indels;
    private MenuItem InvSettings;
    private Menu Inversions;
    private CheckboxMenuItem PaupCorr;
    private Menu Primers;
    private Menu Settings;
    private Menu StatAnalysis;
    private Menu Statistics;
    private MenuItem Tex;
    private MenuItem add;
    private MenuItem barriel;
    private MenuItem baum;
    private MenuItem bena;
    private Menu boot;
    private CheckboxMenuItem bootOnOff;
    private CheckboxMenuItem borderItem;
    private JLabel charsLabel;
    private JLabel charsetsLabel;
    private CheckboxMenuItem checkboxMenuItem1;
    private CheckboxMenuItem checkboxMenuItem2;
    private CheckboxMenuItem checkboxMenuItem3;
    private CheckboxMenuItem checkboxMenuItem4;
    private MenuItem close;
    private MenuItem complex;
    private MenuItem complexMixInc;
    private MenuItem complexMixSize;
    private MenuItem complexPC;
    private MenuItem complexSimm;
    private MenuItem contrMenuItem;
    private MenuItem expFasta;
    private MenuItem expNexus;
    private MenuItem extrMenuItem;
    private MenuItem fifth;
    private MenuItem findInversions;
    private MenuItem gapped;
    private MenuItem getR;
    private CheckboxMenuItem ignoreMiss;
    private MenuItem loadEvolver;
    private MenuItem loadFasta;
    private MenuItem loadNexus;
    private MenuItem loadPrimers;
    private MenuItem loadROSE;
    private MenuItem localize;
    private MenuItem manual;
    private MenuBar menuBar1;
    private MenuItem miss;
    private JLabel msgLabel;
    public MenuItem nexN;
    private JPanel panel1;
    private MenuItem pertSet;
    private MenuItem primerSettings;
    private JLabel primersLabel;
    public CheckboxMenuItem readPrimers;
    public MenuItem roseN;
    public MenuItem roseP;
    public MenuItem roseW;
    private MenuItem savePrimers;
    private MenuItem htmlPrimers;
    private MenuItem setMix;
    private MenuItem showPrimers;
    private MenuItem simple;
    private Menu sortBy;
    private MenuItem sortByName;
    private MenuItem sortByRegion;
    private MenuItem sortByTaxa;
    private MenuItem sortByLabcode;
    private MenuItem sortByDesign;
    private MenuItem sortByReference;
    private MenuItem stat;
    private Menu statSettings;
    private CheckboxMenuItem taxSetsOnOff;
    private JLabel taxaLabel;
    private TextArea textArea1;
    private CheckboxMenuItem three;
    private MenuItem toBinary;
    private MenuItem wholeDataset;

    public SeqState(String path, String indelCodingMethod, String border) {
        System.out.println("called with 3 arg\n");
        this.initComponents();
        this.refreshLabels();
        this.sequences = new ArrayList();
        this.primers = new ArrayList();
        this.completeSequences = new ArrayList();
        this.newprimers = new ArrayList();
        this.charsets = new ArrayList();
        this.taxsets = new Vector();
        this.filename = "";
        this.msg = "current data file: " + this.curFile;
        int width = 800;
        int height = 600;
        Dimension d = new Dimension(width, height);
        Dimension scrnSize = this.toolkit.getScreenSize();
        this.setSize(d);
        this.setLocation(scrnSize.width / 2 - width / 2, scrnSize.height / 2 - height / 2);
        this.setResizable(true);
        this.setTitle("SeqState version " + this.version);
        this.msgLabel.setText(this.msg);
        this.readPrimers.setState(false);
        this.setLabels();
        this.pack();
        this.df.setMaximumFractionDigits(3);
        this.df.setMinimumFractionDigits(3);
        this.textArea1.setFont(new Font("Courier", 0, 11));
        this.textArea1.setText("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\t\t\t\t\t\t\"File\" -> \"load NEXUS file\"\n\n\t\t\t\t\t\thelp@ kaimueller@uni-bonn.de");
        if (path != null) {
            try {
                this.filename = path;
                this.displayTextfile(this.filename);
                this.setLabels();
                this.toFront();
                Toolkit.getDefaultToolkit().sync();
                new nexim(this.filename, this.sequences, this.primers, this.charsets, this.taxsets, false);
                this.msg = "loaded " + this.filename;
                this.nrOfTaxa = this.sequences.size();
                Iterator i = this.sequences.iterator();
                if (i.hasNext()) {
                    sequence s = (sequence)i.next();
                    this.nrOfChar = s.sequence.length();
                }
                this.nrOfCharsets = this.charsets.size();
                this.setLabels();
                this.toFront();
                Toolkit.getDefaultToolkit().sync();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "nexim Exception");
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "?? nexim Exception");
            }
        }
        if (indelCodingMethod != null) {
            this.indelCodingMethod = indelCodingMethod;
        }
        if (border.equalsIgnoreCase("border")) {
            this.border = true;
        }
        if (this.indelCodingMethod.equalsIgnoreCase("MCIC")) {
            this.modifiedComplex();
        } else if (this.indelCodingMethod.equalsIgnoreCase("SIC")) {
            this.simple();
        } else {
            System.out.print("\nError: unknown coding method requested: " + this.indelCodingMethod + "\n");
        }
        System.gc();
        System.exit(0);
    }

    public SeqState(String path) {
        System.out.println("called with 1 arg\n");
        try {
            this.window = new Window(this);
            URL u = SeqState.class.getResource("rs/SeqState.jpg");
            this.image = this.toolkit.getImage(u);
            ImageCanvas canvas = new ImageCanvas(this.image);
            this.window.add((Component)canvas, "Center");
            Dimension scrnSize = this.toolkit.getScreenSize();
            int imgWidth = this.image.getWidth(this);
            int imgHeight = this.image.getHeight(this);
            this.window.setLocation(scrnSize.width / 2 - imgWidth / 2, scrnSize.height / 2 - imgHeight / 2);
            this.window.setSize(imgWidth, imgHeight);
            this.window.setVisible(true);
            this.window.toFront();
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.window.dispose();
        }
        catch (Exception e) {
            System.out.print("image no work");
        }
        this.initComponents();
        this.refreshLabels();
        this.sequences = new ArrayList();
        this.primers = new ArrayList();
        this.completeSequences = new ArrayList();
        this.newprimers = new ArrayList();
        this.charsets = new ArrayList();
        this.taxsets = new Vector();
        this.filename = "";
        this.msg = "current data file: " + this.curFile;
        int width = 800;
        int height = 600;
        Dimension d = new Dimension(width, height);
        Dimension scrnSize = this.toolkit.getScreenSize();
        this.setSize(d);
        this.setLocation(scrnSize.width / 2 - width / 2, scrnSize.height / 2 - height / 2);
        Dimension d1 = new Dimension(width - 40, height - 150);
        this.setResizable(true);
        this.setTitle("SeqState version " + this.version);
        this.readPrimers.setState(false);
        this.setLabels();
        this.df.setMaximumFractionDigits(3);
        this.df.setMinimumFractionDigits(3);
        this.textArea1.setFont(new Font("Courier", 0, 11));
        this.textArea1.setText("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\t\t\t\t\t\t\"File\" -> \"load NEXUS file\"\n\n\t\t\t\t\t\thelp@ kaimueller@uni-bonn.de");
        this.show();
        if (path != null) {
            try {
                this.curFile = "PhydeExport";
                this.filename = path;
                this.displayTextfile(this.filename);
                this.setLabels();
                this.toFront();
                Toolkit.getDefaultToolkit().sync();
                new nexim(this.filename, this.sequences, this.primers, this.charsets, this.taxsets, false);
                Toolkit.getDefaultToolkit().beep();
                this.msg = "loaded " + this.filename;
                this.nrOfTaxa = this.sequences.size();
                Iterator i = this.sequences.iterator();
                if (i.hasNext()) {
                    sequence s = (sequence)i.next();
                    this.nrOfChar = s.sequence.length();
                }
                this.nrOfCharsets = this.charsets.size();
                this.setLabels();
                this.toFront();
                Toolkit.getDefaultToolkit().sync();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "nexim Exception");
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "?? nexim Exception");
            }
        }
    }

    public void refreshLabels() {
        this.complexMixSize.setLabel("modified complex coding - gaps > " + this.gapLengthSimple + " = simple");
        this.loadROSE.setLabel("Load " + this.ROSEruns + " data sets from ROSE file");
        this.loadEvolver.setLabel("Load " + this.ROSEruns + " data sets from Evolver file");
        this.nexN.setLabel("1 NEXUS > " + nrOfCodings + " codings > " + nrOfCodings + " NEXUS");
        this.roseW.setLabel(this.ROSEruns + " ROSE runs > " + this.ROSEruns + " FASTA (for Clustal)");
        this.roseN.setLabel(this.ROSEruns + " ROSE runs > " + 2 + " codings > " + 2 + " NEXUS \u00e0 " + this.ROSEruns);
        this.roseP.setLabel(this.ROSEruns + " ROSE runs > perturb > " + nrOfCodings + " codings > " + nrOfCodings + " NEXUS \u00e0 " + this.ROSEruns);
    }

    private void initComponents() {
        this.textArea1 = new TextArea();
        this.panel1 = new JPanel();
        this.msgLabel = new JLabel();
        this.charsLabel = new JLabel();
        this.taxaLabel = new JLabel();
        this.charsetsLabel = new JLabel();
        this.primersLabel = new JLabel();
        this.menuBar1 = new MenuBar();
        this.File = new Menu();
        this.loadNexus = new MenuItem();
        this.loadFasta = new MenuItem();
        this.loadROSE = new MenuItem();
        this.loadEvolver = new MenuItem();
        this.expNexus = new MenuItem();
        this.expFasta = new MenuItem();
        this.GenBank = new MenuItem();
        this.readPrimers = new CheckboxMenuItem();
        this.nexN = new MenuItem();
        this.roseW = new MenuItem();
        this.roseN = new MenuItem();
        this.roseP = new MenuItem();
        this.pertSet = new MenuItem();
        this.toBinary = new MenuItem();
        this.Tex = new MenuItem();
        this.close = new MenuItem();
        this.Gaps = new Menu();
        this.GapSettings = new MenuItem();
        this.Design = new MenuItem();
        this.Primers = new Menu();
        this.loadPrimers = new MenuItem();
        this.savePrimers = new MenuItem();
        this.htmlPrimers = new MenuItem();
        this.showPrimers = new MenuItem();
        this.add = new MenuItem();
        this.manual = new MenuItem();
        this.Design2 = new MenuItem();
        this.primerSettings = new MenuItem();
        this.localize = new MenuItem();
        this.Statistics = new Menu();
        this.StatAnalysis = new Menu();
        this.wholeDataset = new MenuItem();
        this.Charsets = new MenuItem();
        this.statSettings = new Menu();
        this.sortBy = new Menu();
        this.sortByName = new MenuItem();
        this.sortByRegion = new MenuItem();
        this.sortByTaxa = new MenuItem();
        this.sortByLabcode = new MenuItem();
        this.sortByDesign = new MenuItem();
        this.sortByReference = new MenuItem();
        this.bootOnOff = new CheckboxMenuItem();
        this.taxSetsOnOff = new CheckboxMenuItem();
        this.boot = new Menu();
        this.checkboxMenuItem1 = new CheckboxMenuItem();
        this.checkboxMenuItem2 = new CheckboxMenuItem();
        this.checkboxMenuItem3 = new CheckboxMenuItem();
        this.checkboxMenuItem4 = new CheckboxMenuItem();
        this.contrMenuItem = new MenuItem();
        this.extrMenuItem = new MenuItem();
        this.getR = new MenuItem();
        this.Indels = new Menu();
        this.complex = new MenuItem();
        this.complexPC = new MenuItem();
        this.complexMixInc = new MenuItem();
        this.complexMixSize = new MenuItem();
        this.setMix = new MenuItem();
        this.simple = new MenuItem();
        this.complexSimm = new MenuItem();
        this.baum = new MenuItem();
        this.barriel = new MenuItem();
        this.bena = new MenuItem();
        this.fifth = new MenuItem();
        this.miss = new MenuItem();
        this.gapped = new MenuItem();
        this.stat = new MenuItem();
        this.Settings = new Menu();
        this.borderItem = new CheckboxMenuItem();
        this.three = new CheckboxMenuItem();
        this.ignoreMiss = new CheckboxMenuItem();
        this.PaupCorr = new CheckboxMenuItem();
        this.Inversions = new Menu();
        this.findInversions = new MenuItem();
        this.InvSettings = new MenuItem();
        this.HelpMenu = new Menu();
        this.About = new MenuItem();
        this.Help = new MenuItem();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 252));
        this.setName("");
        this.setTitle("SeqState");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SeqState.this.exitForm(evt);
            }
        });
        this.textArea1.setFont(new Font("Arial Black", 0, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.textArea1, gridBagConstraints);
        this.panel1.setLayout(new GridBagLayout());
        this.panel1.setBackground(new Color(255, 255, 255));
        this.msgLabel.setFont(new Font("Dialog", 0, 12));
        this.msgLabel.setForeground(new Color(0, 0, 204));
        this.msgLabel.setHorizontalAlignment(2);
        this.msgLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 90;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.panel1.add((Component)this.msgLabel, gridBagConstraints);
        this.charsLabel.setFont(new Font("Dialog", 0, 12));
        this.charsLabel.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.panel1.add((Component)this.charsLabel, gridBagConstraints);
        this.taxaLabel.setFont(new Font("Dialog", 0, 12));
        this.taxaLabel.setText("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.panel1.add((Component)this.taxaLabel, gridBagConstraints);
        this.charsetsLabel.setFont(new Font("Dialog", 0, 12));
        this.charsetsLabel.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.panel1.add((Component)this.charsetsLabel, gridBagConstraints);
        this.primersLabel.setFont(new Font("Dialog", 0, 12));
        this.primersLabel.setText("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.panel1.add((Component)this.primersLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.panel1, gridBagConstraints);
        this.menuBar1.setFont(new Font("Arial", 1, 12));
        this.File.setFont(new Font("Arial", 1, 12));
        this.File.setLabel("File");
        this.File.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.FileActionPerformed(evt);
            }
        });
        this.loadNexus.setLabel("Load NEXUS file");
        this.loadNexus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.loadNexusActionPerformed(evt);
            }
        });
        this.File.add(this.loadNexus);
        this.loadFasta.setLabel("Load FASTA file");
        this.loadFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.loadFastaActionPerformed(evt);
            }
        });
        this.File.add(this.loadFasta);
        this.loadROSE.setLabel("Load ROSE file");
        this.loadROSE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.loadROSEActionPerformed(evt);
            }
        });
        this.File.add(this.loadROSE);
        this.loadEvolver.setLabel("Load Evolver file");
        this.loadEvolver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.loadEvolverActionPerformed(evt);
            }
        });
        this.File.add(this.loadEvolver);
        this.File.addSeparator();
        this.expNexus.setLabel("Export NEXUS");
        this.expNexus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.expNexusActionPerformed(evt);
            }
        });
        this.File.add(this.expNexus);
        this.expFasta.setLabel("Export FASTA");
        this.expFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.expFastaActionPerformed(evt);
            }
        });
        this.File.add(this.expFasta);
        this.GenBank.setLabel("Export GenBank FASTA & description");
        this.GenBank.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.GenBankActionPerformed(evt);
            }
        });
        this.File.add(this.GenBank);
        this.File.addSeparator();
        this.readPrimers.setLabel("identify primers by  <30 nu (toggle)");
        this.File.add(this.readPrimers);
        this.File.addSeparator();
        this.nexN.setLabel(".nex > code > .nex");
        this.nexN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.nexNActionPerformed(evt);
            }
        });
        this.File.add(this.nexN);
        this.roseW.setActionCommand("Import ROSE output...");
        this.roseW.setLabel("ROSE > ClustalW");
        this.roseW.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.roseWActionPerformed(evt);
            }
        });
        this.File.add(this.roseW);
        this.roseN.setLabel("ROSE > code > .nex");
        this.roseN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.roseNActionPerformed(evt);
            }
        });
        this.File.add(this.roseN);
        this.roseP.setLabel("ROSE > perturb > code > .nex");
        this.roseP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.rosePActionPerformed(evt);
            }
        });
        this.File.add(this.roseP);
        this.File.addSeparator();
        this.pertSet.setLabel("Settings...");
        this.pertSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.pertSetActionPerformed(evt);
            }
        });
        this.File.add(this.pertSet);
        this.File.addSeparator();
        this.toBinary.setLabel("To binary...");
        this.toBinary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.toBinaryActionPerformed(evt);
            }
        });
        this.File.add(this.toBinary);
        this.File.addSeparator();
        this.Tex.setLabel("To LaTeX...");
        this.Tex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.TexActionPerformed(evt);
            }
        });
        this.File.add(this.Tex);
        this.File.addSeparator();
        this.close.setLabel("Exit");
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.closeActionPerformed(evt);
            }
        });
        this.File.add(this.close);
        this.menuBar1.add(this.File);
        this.Gaps.setFont(new Font("Dialog", 1, 12));
        this.Gaps.setLabel("Gaps");
        this.Gaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.GapsActionPerformed(evt);
            }
        });
        this.GapSettings.setLabel("Settings...");
        this.GapSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.GapSettingsActionPerformed(evt);
            }
        });
        this.Gaps.add(this.GapSettings);
        this.Gaps.addSeparator();
        this.Design.setLabel("Find gaps and choose/design primers");
        this.Design.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.DesignActionPerformed(evt);
            }
        });
        this.Gaps.add(this.Design);
        this.menuBar1.add(this.Gaps);
        this.Primers.setFont(new Font("Arial", 1, 12));
        this.Primers.setLabel("Primers");
        this.Primers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.PrimersActionPerformed(evt);
            }
        });
        this.loadPrimers.setLabel("Load primers...");
        this.loadPrimers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.loadPrimersActionPerformed(evt);
            }
        });
        this.Primers.add(this.loadPrimers);
        this.savePrimers.setLabel("Save primers....");
        this.savePrimers.setName("");
        this.savePrimers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.savePrimersActionPerformed(evt);
            }
        });
        this.Primers.add(this.savePrimers);
        this.htmlPrimers.setLabel("Export to HTML...");
        this.htmlPrimers.setName("");
        this.htmlPrimers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.htmlPrimersActionPerformed(evt);
            }
        });
        this.Primers.add(this.htmlPrimers);
        this.Primers.addSeparator();
        this.showPrimers.setLabel("Show / edit / delete primers...");
        this.showPrimers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.showPrimersActionPerformed(evt);
            }
        });
        this.Primers.add(this.showPrimers);
        this.sortBy.setLabel("Sort by ...");
        this.sortByName.setLabel("name");
        this.sortByName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByNameActionPerformed(evt);
            }
        });
        this.sortByRegion.setLabel("target region");
        this.sortByRegion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByRegionActionPerformed(evt);
            }
        });
        this.sortByTaxa.setLabel("used for (taxa)");
        this.sortByTaxa.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByTaxaActionPerformed(evt);
            }
        });
        this.sortByLabcode.setLabel("lab code");
        this.sortByLabcode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByLabcodeActionPerformed(evt);
            }
        });
        this.sortByDesign.setLabel("design by");
        this.sortByDesign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByDesignActionPerformed(evt);
            }
        });
        this.sortByReference.setLabel("publication");
        this.sortByReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.sortByReferenceActionPerformed(evt);
            }
        });
        this.sortBy.add(this.sortByName);
        this.sortBy.add(this.sortByRegion);
        this.sortBy.add(this.sortByTaxa);
        this.sortBy.add(this.sortByLabcode);
        this.sortBy.add(this.sortByReference);
        this.sortBy.add(this.sortByDesign);
        this.Primers.add(this.sortBy);
        this.Primers.addSeparator();
        this.add.setLabel("Add new primer...");
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.addActionPerformed(evt);
            }
        });
        this.Primers.add(this.add);
        this.manual.setLabel("Manual input / primer pair...");
        this.manual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.manualActionPerformed(evt);
            }
        });
        this.Primers.add(this.manual);
        this.Primers.addSeparator();
        this.Design2.setLabel("Choose/design primers to fill  gaps");
        this.Design2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.Design2ActionPerformed(evt);
            }
        });
        this.Primers.add(this.Design2);
        this.Primers.addSeparator();
        this.primerSettings.setLabel("Analysis settings...");
        this.primerSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.primerSettingsActionPerformed(evt);
            }
        });
        this.Primers.add(this.primerSettings);
        this.localize.setLabel("Localize primers in alignment");
        this.localize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.localizeActionPerformed(evt);
            }
        });
        this.Primers.add(this.localize);
        this.menuBar1.add(this.Primers);
        this.Statistics.setFont(new Font("Arial", 1, 12));
        this.Statistics.setLabel("Statistics");
        this.Statistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.StatisticsActionPerformed(evt);
            }
        });
        this.StatAnalysis.setLabel("Analyse");
        this.wholeDataset.setLabel("whole dataset");
        this.wholeDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.wholeDatasetActionPerformed(evt);
            }
        });
        this.StatAnalysis.add(this.wholeDataset);
        this.Charsets.setLabel("charsets");
        this.Charsets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.CharsetsActionPerformed(evt);
            }
        });
        this.StatAnalysis.add(this.Charsets);
        this.Statistics.add(this.StatAnalysis);
        this.Statistics.addSeparator();
        this.statSettings.setLabel("Statistics settings...");
        this.bootOnOff.setLabel("SE via bootstrap");
        this.statSettings.add(this.bootOnOff);
        this.statSettings.addSeparator();
        this.taxSetsOnOff.setEnabled(false);
        this.taxSetsOnOff.setLabel("contrast taxSets");
        this.taxSetsOnOff.setName("contrast taxSets");
        this.statSettings.add(this.taxSetsOnOff);
        this.statSettings.addSeparator();
        this.boot.setLabel("bootstrapping...");
        this.boot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.bootActionPerformed(evt);
            }
        });
        this.checkboxMenuItem1.setLabel("50 reps");
        this.boot.add(this.checkboxMenuItem1);
        this.checkboxMenuItem2.setLabel("100 reps");
        this.boot.add(this.checkboxMenuItem2);
        this.checkboxMenuItem3.setLabel("500 reps");
        this.boot.add(this.checkboxMenuItem3);
        this.checkboxMenuItem4.setLabel("1000 reps");
        this.checkboxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.checkboxMenuItem4ActionPerformed(evt);
            }
        });
        this.boot.add(this.checkboxMenuItem4);
        this.statSettings.add(this.boot);
        this.Statistics.add(this.statSettings);
        this.Statistics.addSeparator();
        this.contrMenuItem.setLabel("Contrast charsets...");
        this.contrMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.contrMenuItemActionPerformed(evt);
            }
        });
        this.Statistics.add(this.contrMenuItem);
        this.extrMenuItem.setLabel("Extract...");
        this.extrMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.extrMenuItemActionPerformed(evt);
            }
        });
        this.Statistics.add(this.extrMenuItem);
        this.getR.setLabel("get single R...");
        this.getR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.getRActionPerformed(evt);
            }
        });
        this.Statistics.add(this.getR);
        this.menuBar1.add(this.Statistics);
        this.Indels.setFont(new Font("Arial", 1, 12));
        this.Indels.setLabel("IndelCoder");
        this.Indels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.IndelsActionPerformed(evt);
            }
        });
        this.complex.setLabel("modified complex coding");
        this.complex.setName("complex indel coding");
        this.complex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.complexActionPerformed(evt);
            }
        });
        this.Indels.add(this.complex);
        this.complexPC.setLabel("modified complex coding - no correction");
        this.complexPC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.complexPCActionPerformed(evt);
            }
        });
        this.Indels.add(this.complexPC);
        this.complexMixInc.setLabel("modified complex coding - inconsistent = simple");
        this.complexMixInc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.complexMixIncActionPerformed(evt);
            }
        });
        this.Indels.add(this.complexMixInc);
        this.complexMixSize.setLabel("modified complex coding - gaps > [length] = simple");
        this.complexMixSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.complexMixSizeActionPerformed(evt);
            }
        });
        this.Indels.add(this.complexMixSize);
        this.setMix.setFont(new Font("Dialog", 0, 10));
        this.setMix.setLabel("                   Set length ...");
        this.setMix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.setMixActionPerformed(evt);
            }
        });
        this.Indels.add(this.setMix);
        this.simple.setLabel("Simmons & Ochoterena (2000) - simple coding");
        this.simple.setName("simple indel coding");
        this.simple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.simpleActionPerformed(evt);
            }
        });
        this.Indels.add(this.simple);
        this.complexSimm.setLabel("Simmons & Ochoterena (2000) - complex coding");
        this.complexSimm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.complexSimmActionPerformed(evt);
            }
        });
        this.Indels.add(this.complexSimm);
        this.baum.setLabel("Baum et al. (1994)");
        this.baum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.baumActionPerformed(evt);
            }
        });
        this.Indels.add(this.baum);
        this.barriel.setLabel("Barriel (1994)");
        this.barriel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.barrielActionPerformed(evt);
            }
        });
        this.Indels.add(this.barriel);
        this.bena.setLabel("Bena et al. (1998) - 5th states");
        this.bena.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.benaActionPerformed(evt);
            }
        });
        this.Indels.add(this.bena);
        this.fifth.setLabel("Giribet & Wheeler (1999) - 5th states");
        this.fifth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.fifthActionPerformed(evt);
            }
        });
        this.Indels.add(this.fifth);
        this.miss.setLabel("PAUP* default - missing data");
        this.miss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.missActionPerformed(evt);
            }
        });
        this.Indels.add(this.miss);
        this.gapped.setLabel("exclude gapped positions");
        this.gapped.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.gappedActionPerformed(evt);
            }
        });
        this.Indels.add(this.gapped);
        this.Indels.addSeparator();
        this.stat.setLabel("output #indels per charset");
        this.stat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.statActionPerformed(evt);
            }
        });
        this.Indels.add(this.stat);
        this.Indels.addSeparator();
        this.Settings.setLabel("Settings");
        this.borderItem.setLabel("include indels at matrix borders");
        this.borderItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.borderItemActionPerformed(evt);
            }
        });
        this.Settings.add(this.borderItem);
        this.Settings.addSeparator();
        this.three.setLabel("ignore gaps not multiple of 3 (not recommended)");
        this.Settings.add(this.three);
        this.Settings.addSeparator();
        this.ignoreMiss.setLabel("ignore gaps bordered by ?");
        this.ignoreMiss.setState(true);
        this.Settings.add(this.ignoreMiss);
        this.Settings.addSeparator();
        this.PaupCorr.setLabel("enforce PAUP's correction of step matrix inconsistencies");
        this.Settings.add(this.PaupCorr);
        this.Indels.add(this.Settings);
        this.menuBar1.add(this.Indels);
        this.Inversions.setFont(new Font("Dialog", 1, 12));
        this.Inversions.setLabel("Inversions");
        this.findInversions.setLabel("Find Inversions...");
        this.findInversions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.findInversionsActionPerformed(evt);
            }
        });
        this.Inversions.add(this.findInversions);
        this.Inversions.addSeparator();
        this.InvSettings.setLabel("Settings...");
        this.InvSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.InvSettingsActionPerformed(evt);
            }
        });
        this.Inversions.add(this.InvSettings);
        this.menuBar1.add(this.Inversions);
        this.HelpMenu.setFont(new Font("Arial", 1, 12));
        this.HelpMenu.setLabel("Help");
        this.HelpMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.HelpMenuActionPerformed(evt);
            }
        });
        this.About.setLabel("About...");
        this.About.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.AboutActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.About);
        this.HelpMenu.addSeparator();
        this.Help.setLabel("Help...");
        this.Help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeqState.this.HelpActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.Help);
        this.menuBar1.add(this.HelpMenu);
        this.setMenuBar(this.menuBar1);
        this.pack();
    }

    private void InvSettingsActionPerformed(ActionEvent evt) {
        InversionSettingsDialog is = new InversionSettingsDialog(this, true, this.loopsize, this.maxMismatchScore, this.lowerMotifBoundary, this.upperMotifBoundary);
        is.setTitle("InversionScreener Settings");
        is.pack();
        is.setLocationRelativeTo(this);
        is.setVisible(true);
        if (is.getReturnStatus() == 1) {
            this.loopsize = is.returnLoop();
            this.maxMismatchScore = is.returnMism();
            this.lowerMotifBoundary = is.returnLower();
            this.upperMotifBoundary = is.returnUpper();
        }
        System.out.print("new Settings: " + this.loopsize + " " + this.maxMismatchScore + " " + this.lowerMotifBoundary + " " + this.upperMotifBoundary + "\n");
    }

    private void findInversionsActionPerformed(ActionEvent evt) {
        InversionScreener IS = new InversionScreener(this.sequences, this.loopsize, this.maxMismatchScore, this.lowerMotifBoundary, this.upperMotifBoundary, this.filename);
    }

    private void getRActionPerformed(ActionEvent evt) {
        this.extract();
    }

    private void borderItemActionPerformed(ActionEvent evt) {
    }

    private void TexActionPerformed(ActionEvent evt) {
        this.filename = this.removeFileExtension(this.filename);
        String TeXfilename = this.filename + ".tex";
        File f = new File(TeXfilename);
        Date d = new Date();
        try {
            FileWriter fw = new FileWriter(f);
            fw.write("%created with SeqState " + this.version + "  build " + this.date + " on " + d + " \n\n");
            fw.write("\\documentclass{book}\n\\pagestyle{empty}\n\\usepackage{color}\n\\usepackage{courier}\n\n\\definecolor{grau}{gray}{0.5}\n\\definecolor{hgrau}{gray}{0.7}\n\n");
            fw.write("\\newcommand{\\nc}{\\fcolorbox{white}{grau}{\\textcolor{grau}{A}}}\n");
            fw.write("\\newcommand{\\gp}{\\fcolorbox{white}{white}{-}}\n");
            fw.write("\\newcommand{\\ba}[1]{\\fcolorbox{white}{hgrau}{\\textcolor{black}{#1}}}\n\n");
            fw.write("\\begin{document}\n\n");
            fw.write("\\ttfamily\n\n");
            fw.write("\\tiny\n\n");
            fw.write("\\setlength{\\tabcolsep}{1mm}\n\n");
            fw.write("\\begin{tabular}{|ll|}\n\\hline\n&\\\\\n");
            Iterator i = this.sequences.iterator();
            while (i.hasNext()) {
                sequence s = (sequence)i.next();
                fw.write(s.name + " & ");
                for (int a = 0; a < s.sequence.length(); ++a) {
                    if (s.sequence.charAt(a) == '-') {
                        fw.write("\\gp");
                        continue;
                    }
                    if (this.outputBases) {
                        fw.write("\\ba{" + s.sequence.charAt(a) + "}");
                        continue;
                    }
                    fw.write("\\nc");
                }
                fw.write("\\\\\n");
            }
            fw.write("\n&\\\\\n\\hline\n");
            fw.write("\\end{tabular}\n\n");
            fw.write("\\end{document}");
            fw.flush();
            fw.close();
            this.displayTextfile(TeXfilename);
            this.msg = "exportet to " + TeXfilename;
            this.setLabels();
        }
        catch (Exception e) {
            System.out.print("error: TeXfilename");
        }
    }

    private void loadEvolverActionPerformed(ActionEvent evt) {
        this.inBlocks = true;
        this.getEvolver();
        this.datasets.clear();
        try {
            this.parseEvolver(false);
            this.msg = this.datasets.size() + " Evolver datasets read.";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "Evolver import failed";
            this.setLabels();
        }
    }

    public void testOutputDatasets() {
        Iterator i = this.datasets.iterator();
        while (i.hasNext()) {
            dataset d = (dataset)i.next();
            System.out.print(d.name + ":  ");
            Iterator it = d.sequences.iterator();
            System.out.print("\n" + d.sequences.size() + " tx \n");
            int a = 1;
            while (it.hasNext()) {
                sequence s = (sequence)it.next();
                System.out.print(s.name + " " + s.sequence.length() + " " + s.sequence + "\n");
                ++a;
            }
        }
    }

    public void parseEvolver(boolean interleave) throws IOException {
        File file = new File(this.ROSEfilename);
        FileReader fr = new FileReader(file);
        StreamTokenizer tok = new StreamTokenizer(fr);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.whitespaceChars(61, 61);
        tok.whitespaceChars(59, 59);
        tok.eolIsSignificant(false);
        String seq = "";
        String nam = "";
        boolean seqlen = false;
        this.datasets.clear();
        try {
            for (int i = 0; i < this.ROSEruns; ++i) {
                int nchar = 0;
                int ntax = 0;
                this.sequences.clear();
                do {
                    tok.nextToken();
                    if (tok.sval.equalsIgnoreCase("nchar")) {
                        tok.nextToken();
                        nchar = Integer.parseInt(tok.sval);
                    }
                    if (tok.sval.equalsIgnoreCase("ntax")) {
                        tok.nextToken();
                        ntax = Integer.parseInt(tok.sval);
                    }
                    if (tok.ttype != -1) continue;
                    throw new Exception("no\"-file");
                } while (!tok.sval.equalsIgnoreCase("matrix"));
                do {
                    seq = "";
                    nam = "";
                    tok.nextToken();
                    nam = tok.sval;
                    while (seq.length() < nchar) {
                        tok.nextToken();
                        seq = seq + tok.sval;
                    }
                    this.sequences.add(new sequence(nam, seq));
                    if (this.sequences.size() >= ntax) break;
                } while (tok.ttype != -1);
                this.datasets.add(new dataset(this.sequences, i + 1, "dataset " + (i + 1)));
            }
        }
        catch (Exception e) {
            this.msg = "ROSE file could not be parsed";
            this.setLabels();
        }
    }

    public void getEvolver() {
        this.msg = "Evolver...";
        this.setLabels();
        FileDialog fd = new FileDialog((Frame)this, "Import Evolver output...");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.curROSEFile = fd.getFile();
            this.ROSEfilename = fd.getDirectory() + fd.getFile();
            this.displayTextfile(this.ROSEfilename);
        }
    }

    private void extrMenuItemActionPerformed(ActionEvent evt) {
        Vector allReps = new Vector();
        this.extract(allReps);
        double[] allRDiffs = new double[this.nrep];
        double[] R1s = new double[this.nrep];
        double[] R2s = new double[this.nrep];
        double RDiffSum = this.getRs(allReps, allRDiffs, R1s, R2s);
        double meanRDiff = RDiffSum / (double)this.nrep;
        double sumOfSquares = 0.0;
        for (int c = 0; c < this.nrep; ++c) {
            double mDiff = meanRDiff - allRDiffs[c];
            sumOfSquares += Math.pow(mDiff, 2.0);
        }
        double se = Math.sqrt(sumOfSquares / (double)(this.nrep - 1));
        se = Math.pow(se, 2.0);
        se = Math.sqrt(se / (double)this.nrep);
        String result = this.charset1 + " - " + this.charset2;
        result = result + "\n\n-------------------\n\n";
        result = result + "mean R difference:" + meanRDiff + "\n\n";
        result = result + "s.e.: " + se + "\n\n";
        result = result + "confidence interval 0.95: " + (meanRDiff - 1.96 * se) + " ... " + (meanRDiff + 1.96 * se) + "\n\n";
        result = result + "(calculated using " + this.nrep + " replicates)\n\n-------------------\n\n";
        result = result + "output for sign test:\n\n";
        int pctg2gr = 0;
        for (int c = 0; c < this.nrep; ++c) {
            result = result + R1s[c] + "\t" + R2s[c] + "\t" + allRDiffs[c] + "\n";
            if (!(R2s[c] > R1s[c])) continue;
            ++pctg2gr;
        }
        double pctg2grd = (double)pctg2gr / (double)this.nrep * 100.0;
        result = result + "\n\n" + this.charset2 + " > " + this.charset1 + ": " + pctg2grd + "%.\n";
        result = result + "\n\n-------------------\n\n";
        result = result + "output for U test:\n\n";
        for (int c = 0; c < this.nrep; ++c) {
            result = result + R1s[c] + "\t" + this.charset1 + "\n" + R2s[c] + "\t" + this.charset2 + "\n";
        }
        result = result + "\n\n-------------------\n\n";
        this.textArea1.setText(result);
    }

    public double getRs(Vector allReps, double[] allRDiffs, double[] R1s, double[] R2s) {
        double RDiffSum = 0.0;
        Iterator a = allReps.iterator();
        int ctr = 0;
        while (a.hasNext()) {
            double R1 = 0.0;
            double R2 = 0.0;
            double diff = 0.0;
            double sum1 = 0.0;
            double sum2 = 0.0;
            Vector indivPercentages1 = (Vector)a.next();
            Iterator i1 = indivPercentages1.iterator();
            sum1 = this.sumOfIndivPctgs(i1);
            Vector indivPercentages2 = (Vector)a.next();
            Iterator i2 = indivPercentages2.iterator();
            sum2 = this.sumOfIndivPctgs(i2);
            R1 = sum1 / (double)(this.nrOfTaxa - 2);
            R2 = sum2 / (double)(this.nrOfTaxa - 2);
            R1s[ctr] = R1;
            R2s[ctr] = R2;
            allRDiffs[ctr] = diff = R1 - R2;
            RDiffSum += diff;
            ++ctr;
        }
        return RDiffSum;
    }

    public double sumOfIndivPctgs(Iterator i) {
        double sum = 0.0;
        while (i.hasNext()) {
            String number = (String)i.next();
            int pctg = Integer.parseInt(number);
            double dpctg = ((double)pctg - 49.0) / 51.0;
            sum += dpctg;
        }
        return sum;
    }

    public double sumOfIndivPctgs(Iterator i, int nrep) {
        double sum = 0.0;
        System.out.print("\n");
        while (i.hasNext()) {
            String number = (String)i.next();
            int hits = Integer.parseInt(number);
            double dpctg = (double)hits / (double)nrep * 100.0;
            System.out.print(dpctg + ", ");
            dpctg = (dpctg - 49.0) / 51.0;
            sum += dpctg;
        }
        return sum;
    }

    public void extract() {
        FileDialog fd = new FileDialog((Frame)this, "get log file...", 0);
        fd.setFile("*.log");
        fd.setVisible(true);
        String logfile = "";
        if (fd.getFile() != null) {
            logfile = fd.getDirectory() + fd.getFile();
        }
        try {
            FileReader fr = new FileReader(logfile);
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            do {
                tok.nextToken();
            } while (tok.ttype != -1 && !tok.sval.equalsIgnoreCase("Freq"));
            tok.nextToken();
            tok.nextToken();
            tok.nextToken();
            String number = "";
            Vector<String> indivPercentages = new Vector<String>();
            int nrep = 10000;
            do {
                tok.nextToken();
                number = tok.sval;
                if (Integer.parseInt(tok.sval) >= nrep / 2) {
                    indivPercentages.add(tok.sval);
                }
                tok.nextToken();
                tok.nextToken();
            } while (Integer.parseInt(number) >= nrep / 2);
            double R = 0.0;
            double sum = 0.0;
            Iterator i1 = indivPercentages.iterator();
            sum = this.sumOfIndivPctgs(i1, nrep);
            int nrOfTaxa = 29;
            R = sum / (double)(nrOfTaxa - 2);
            this.textArea1.setText(logfile + ":\n\nR = " + "" + R + "\n");
            System.out.print("\n\n" + logfile + ":\n\nR = " + "" + R + "\n\n******************");
        }
        catch (Exception e) {
            System.out.print("\nlog file problem");
        }
    }

    public void extract(Vector allReps) {
        FileDialog fd = new FileDialog((Frame)this, "get log file...", 0);
        fd.setFile("*.log");
        fd.setVisible(true);
        String logfile = "";
        if (fd.getFile() != null) {
            logfile = fd.getDirectory() + fd.getFile();
        }
        try {
            FileReader fr = new FileReader(logfile);
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            do {
                tok.nextToken();
            } while (!tok.sval.equalsIgnoreCase("#rep/tax"));
            tok.nextToken();
            this.nrep = Integer.parseInt(tok.sval);
            tok.nextToken();
            this.nrOfTaxa = Integer.parseInt(tok.sval);
            tok.nextToken();
            this.charset1 = tok.sval;
            tok.nextToken();
            this.charset2 = tok.sval;
            for (int i = 0; i < this.nrep * 2; ++i) {
                Vector<String> indivPercentages = new Vector<String>();
                do {
                    tok.nextToken();
                } while (tok.ttype != -1 && !tok.sval.equalsIgnoreCase("****rep"));
                do {
                    tok.nextToken();
                } while (tok.ttype != -1 && !tok.sval.equalsIgnoreCase("Freq"));
                tok.nextToken();
                tok.nextToken();
                String number = "";
                do {
                    tok.nextToken();
                    number = tok.sval;
                    if (Integer.parseInt(tok.sval) >= 50) {
                        indivPercentages.add(tok.sval);
                    }
                    tok.nextToken();
                } while (Integer.parseInt(number) >= 50);
                allReps.add(indivPercentages);
            }
        }
        catch (Exception e) {
            System.out.print("\nlog file problem");
        }
    }

    private void contrMenuItemActionPerformed(ActionEvent evt) {
        this.createContrastDialog();
    }

    public void contrast(Vector charsetsToCompare) {
        Iterator it = charsetsToCompare.iterator();
        charset cs1 = new charset();
        charset cs2 = new charset();
        while (it.hasNext()) {
            cs1 = (charset)it.next();
            cs2 = (charset)it.next();
        }
        int[] randoms1 = new int[this.toSample];
        int[] randoms2 = new int[this.toSample];
        for (int i = 0; i < this.toSample; ++i) {
            randoms1[i] = -1;
            randoms2[i] = -1;
        }
        try {
            File f = new File(this.filename + "_" + cs1.name + "_" + cs2.name + ".nex");
            FileWriter fw = new FileWriter(f);
            this.writeRNexHead(fw);
            fw.write("[!\n\n#rep/tax " + this.nrep + " " + this.nrOfTaxa + " " + cs1.name + " " + cs2.name + "\n\n]");
            fw.flush();
            for (int a = 0; a < this.nrep; ++a) {
                for (int c = 0; c < this.toSample; ++c) {
                    float selected = (float)Math.random();
                    int chosenPos1 = Math.round(selected * (float)(cs1.to - cs1.from) + (float)cs1.from);
                    int chosenPos2 = Math.round(selected * (float)(cs2.to - cs2.from) + (float)cs2.from);
                    while (this.alreadyThere(chosenPos1, randoms1, c)) {
                        selected = (float)Math.random();
                        chosenPos1 = Math.round(selected * (float)(cs1.to - cs1.from) + (float)cs1.from);
                    }
                    randoms1[c] = chosenPos1;
                    while (this.alreadyThere(chosenPos2, randoms2, c)) {
                        selected = (float)Math.random();
                        chosenPos2 = Math.round(selected * (float)(cs2.to - cs2.from) + (float)cs2.from);
                    }
                    randoms2[c] = chosenPos2;
                }
                fw.write("\n[!\n****rep " + (a + 1) + ", " + cs1.name + "\n]\n");
                this.writeRandMatrix(fw, randoms1);
                this.writeSearch(fw);
                fw.write("\n[!\n****rep " + (a + 1) + ", " + cs2.name + "\n]\n");
                this.writeRandMatrix(fw, randoms2);
                this.writeSearch(fw);
            }
            fw.write("log stop;\n");
            fw.flush();
            fw.close();
            this.msg = "command file written for " + charsetsToCompare.size() + " contrasts...using " + this.toSample + " chars + " + this.nrep + " replicates";
            this.setLabels();
        }
        catch (Exception e) {
            System.out.print("\ncontrast: file error");
        }
    }

    public boolean alreadyThere(int chosenPos, int[] randoms, int c) {
        for (int i = 0; i < c; ++i) {
            if (randoms[i] != chosenPos) continue;
            return true;
        }
        return false;
    }

    public void writeSearch(FileWriter fw) throws IOException {
        fw.write("\nBEGIN PAUP;\n");
        fw.write("boot nrep=100 /addseq=simple multrees=no;\n");
        fw.write("END;\n\n");
    }

    public void writeRNexHead(FileWriter fw) throws IOException {
        Date d = new Date();
        fw.write("#NEXUS;\n");
        fw.write("[!compiled on " + d + " with SeqState version " + this.version + " build " + this.date + "]\n\n");
        fw.write("log file=" + this.curFile + ".log;\n");
        fw.write("set status=no;\n\n");
    }

    public void writeRandMatrix(FileWriter fw, int[] randoms) throws IOException {
        fw.write("BEGIN CHARACTERS;\n");
        fw.write("DIMENSIONS newtaxa ntax=" + this.sequences.size() + " NCHAR=" + randoms.length + ";\n");
        fw.write("FORMAT \n");
        fw.write("\tDATATYPE = DNA \n");
        fw.write("\tGAP = - \n");
        fw.write("\tMISSING = ? \n");
        fw.write(";\n\n");
        fw.write("MATRIX\n\n");
        Iterator i = this.sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            fw.write(s.nameAligned + "  ");
            for (int c = 0; c < randoms.length; ++c) {
                fw.write(s.sequence.charAt(randoms[c] - 1));
            }
            fw.write("\n");
        }
        fw.write(";\n");
        fw.write("END;\n");
    }

    public void createContrastDialog() {
        contrastDialog cd = new contrastDialog((Frame)this, true);
        boolean needToSet = false;
        if (this.toSample == 0) {
            this.toSample = this.nrOfChar;
            needToSet = true;
        }
        if (this.charsets.size() == 0) {
            cd.choosePanel.add(new JLabel("<no charsets defined>"));
        } else {
            Iterator i = this.charsets.iterator();
            while (i.hasNext()) {
                charset c = (charset)i.next();
                cd.choosePanel.add(new JCheckBox(c.name, true));
                if (!needToSet) continue;
                this.toSample = Math.min(c.to - c.from + 1, this.toSample);
            }
        }
        cd.sampleTextField.setText(this.toSample + "");
        cd.nrepTextField.setText(this.nrep + "");
        cd.pack();
        cd.setLocationRelativeTo(this);
        cd.show();
        if (cd.getReturnStatus() == 1) {
            Vector<charset> charsetsToCompare = new Vector<charset>();
            this.nrep = Integer.parseInt(cd.nrepTextField.getText());
            this.toSample = Integer.parseInt(cd.sampleTextField.getText());
            int a = cd.choosePanel.getComponentCount();
            for (int i = 0; i < a; ++i) {
                JCheckBox j = (JCheckBox)cd.choosePanel.getComponent(i);
                if (!j.isSelected()) continue;
                Iterator it = this.charsets.iterator();
                while (it.hasNext()) {
                    charset ch = (charset)it.next();
                    if (!ch.name.equalsIgnoreCase(j.getText())) continue;
                    charsetsToCompare.add(ch);
                }
            }
            this.contrast(charsetsToCompare);
        }
    }

    private void toBinaryActionPerformed(ActionEvent evt) {
        this.msg = "translating to binary sequences...";
        this.setLabels();
        try {
            this.pm = new ProgressMonitor(this, "Recoding...", "", 0, this.datasets.size());
            BinaryThread bt = new BinaryThread();
            bt.start();
        }
        catch (Exception e) {
            String s;
            this.msg = s = "problem with running BinaryThread";
            this.setLabels();
            System.out.print(s);
        }
    }

    private void loadFastaActionPerformed(ActionEvent evt) {
        this.sequences.clear();
        this.msg = "FASTA...";
        this.setLabels();
        FileDialog fd = new FileDialog((Frame)this, "Import FASTA...");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.curFile = fd.getFile();
            this.filename = fd.getDirectory() + fd.getFile();
            this.displayTextfile(this.filename);
        }
        try {
            File file = new File(this.filename);
            FileReader fr = new FileReader(file);
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            String seq = "";
            String nam = "";
            boolean seqlen = false;
            do {
                sequence y;
                tok.nextToken();
                if (tok.ttype == -1) {
                    nam = nam.substring(1, nam.length());
                    this.nrOfChar = seq.length();
                    y = new sequence(nam, seq);
                    this.sequences.add(y);
                    break;
                }
                if (tok.sval.startsWith(">")) {
                    if (!nam.equalsIgnoreCase("")) {
                        nam = nam.substring(1, nam.length());
                        y = new sequence(nam, seq);
                        this.sequences.add(y);
                    }
                    nam = tok.sval;
                    seq = "";
                } else {
                    if (tok.ttype == -1) {
                        nam = nam.substring(1, nam.length());
                        y = new sequence(nam, seq);
                        this.sequences.add(y);
                        break;
                    }
                    seq = seq + tok.sval;
                }
            } while (tok.ttype != -1);
            this.nrOfTaxa = this.sequences.size();
            this.msg = "done.";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "error -not a FASTA file?";
            this.setLabels();
        }
        this.setLabels();
    }

    private void expFastaActionPerformed(ActionEvent evt) {
        this.filename = this.removeFileExtension(this.filename);
        String ss = this.filename + ".fas";
        try {
            File f = new File(ss);
            FileWriter fw = new FileWriter(f);
            Iterator i = this.sequences.iterator();
            while (i.hasNext()) {
                sequence s = (sequence)i.next();
                fw.write(">" + s.name + "\n");
                fw.write(s.sequence + "\n\n");
            }
            fw.flush();
            fw.close();
            this.displayTextfile(ss);
            this.msg = "FASTA saved to " + ss;
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "error.";
            this.setLabels();
        }
    }

    private void expNexusActionPerformed(ActionEvent evt) {
        this.filename = this.removeFileExtension(this.filename);
        this.miss();
    }

    private void loadROSEActionPerformed(ActionEvent evt) {
        this.datasets.clear();
        this.getROSE();
        try {
            this.parseROSE(true);
            this.msg = this.datasets.size() + " ROSE datasets read.";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "ROSE import failed";
            this.setLabels();
        }
    }

    private void nexNActionPerformed(ActionEvent evt) {
        this.ROSEfilename = this.filename;
        this.datasets.add(new dataset(this.sequences, 1, "NEXUSdataset", true));
        try {
            this.pm = new ProgressMonitor(this, "Encoding...", "", 0, nrOfCodings);
            CodeAllThread c = new CodeAllThread();
            c.start();
        }
        catch (Exception e) {
            System.out.print(this.nexN.getLabel() + " error");
        }
        this.msg = this.filename + " run through all coding procedures. Saved in files \"..._all_... .nex\".";
        this.setLabels();
    }

    private void complexMixSizeActionPerformed(ActionEvent evt) {
        String s = "\n\n\"" + this.complexMixSize.getLabel() + "\" has been replaced by \"" + this.complexMixInc.getLabel() + "\".";
        this.textArea1.setText(s);
        this.msg = s;
        this.setLabels();
    }

    private void complexMixIncActionPerformed(ActionEvent evt) {
        this.complexMix();
    }

    public void complexMix() {
        ComplexIndelCoding cic = new ComplexIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), false, this.complexMixInc.getLabel(), this.borderItem.getState());
        String s = cic.removeFileExtension(this.filename);
        s = s + "_mcic_mix.nex";
        this.msg = "matrix (" + this.complexMixInc.getLabel() + ")saved to " + s;
        this.setLabels();
        System.out.print(this.complexMixInc.getLabel() + " coding done\n");
        this.displayTextfile(s);
    }

    public void complexPC() {
        ComplexIndelCoding cic = new ComplexIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), false, this.complexPC.getLabel(), this.borderItem.getState());
        String s = cic.removeFileExtension(this.filename);
        s = s + "_mcic_pc.nex";
        this.msg = "matrix (" + this.complexPC.getLabel() + ")saved to " + s;
        this.setLabels();
        System.out.print(this.complexPC.getLabel() + " coding done\n");
        this.displayTextfile(s);
    }

    private void complexPCActionPerformed(ActionEvent evt) {
        this.complexPC();
    }

    private void setMixActionPerformed(ActionEvent evt) {
        GapLength g = new GapLength((Frame)this, true);
        g.jTextField1.setText("" + this.gapLengthSimple);
        g.pack();
        g.setLocationRelativeTo(this);
        g.setVisible(true);
        this.gapLengthSimple = g.returnGapLength();
        this.refreshLabels();
    }

    private void roseNActionPerformed(ActionEvent evt) {
        this.datasets.clear();
        this.getROSE();
        try {
            this.parseROSE(true);
            this.msg = this.datasets.size() + " ROSE datasets read. Running all through Coder...";
            this.setLabels();
            this.pm = new ProgressMonitor(this, "Encoding...", "", 0, 2 * this.datasets.size());
            CodeAllThread c = new CodeAllThread();
            c.start();
            this.msg = "All " + this.datasets.size() + " ROSE datasets run through all coding procedures. Saved in files \"..._all_... .nex\".";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "ROSE -> nex failed";
            this.setLabels();
        }
    }

    public void alignNames(ArrayList sequences) {
        int maxLength = 0;
        Iterator i = sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            if (maxLength >= s.name.length()) continue;
            maxLength = s.name.length();
        }
        Iterator i2 = sequences.iterator();
        while (i2.hasNext()) {
            sequence s = (sequence)i2.next();
            for (int c = 0; c <= maxLength - s.name.length() + 1; ++c) {
                s.nameAligned = s.nameAligned + " ";
            }
        }
    }

    public String removeFileExtension(String longname) {
        int pos = longname.length();
        for (int i = longname.length() - 1; i >= 0; --i) {
            if (longname.charAt(i) != '.') continue;
            pos = i;
            break;
        }
        return longname.substring(0, pos);
    }

    private void pertSetActionPerformed(ActionEvent evt) {
        Perturb p = new Perturb((Frame)this, true);
        p.setTitle("File attributes, -modifications");
        p.pGes.setText("" + this.probP);
        p.pGes.selectAll();
        p.pA.setText("" + this.probA);
        p.pA.selectAll();
        p.pC.setText("" + this.probC);
        p.pC.selectAll();
        p.pG.setText("" + this.probG);
        p.pG.selectAll();
        p.pT.setText("" + this.probT);
        p.pT.selectAll();
        p.jTextField1.setColumns(6);
        p.jTextField1.setText("" + this.ROSEruns);
        p.jTextField1.selectAll();
        p.initialBlock.setText(this.PaupIniBlock);
        p.initialBlock.selectAll();
        p.PaupBlock.setText(this.PaupBlock);
        p.PaupBlock.selectAll();
        p.endBlock.setText(this.endBlock);
        p.endBlock.selectAll();
        if (this.outputBases) {
            p.exactNus.setSelected(true);
        }
        p.pack();
        p.setLocationRelativeTo(this);
        p.setVisible(true);
        this.probP = p.returnP();
        this.probA = p.returnA();
        this.probC = p.returnC();
        this.probG = p.returnG();
        this.probT = p.returnT();
        this.ROSEruns = p.returnRuns();
        this.outputBases = p.returnExactNus();
        this.PaupIniBlock = p.returnIni();
        this.PaupBlock = p.returnPaupBl();
        this.endBlock = p.returnEndBl();
        this.refreshLabels();
        String news = this.ROSEruns + " will be read from file opened via ";
        news = news + "\"" + this.loadROSE.getLabel() + "\"" + " or " + "\"" + this.loadEvolver.getLabel() + "\"";
        news = news + "\n\ncommands added when \"to binary\" is chosen:\n\n";
        news = news + "~~~~~~~~file beginning:\n\n";
        news = news + this.PaupIniBlock;
        news = news + "\n\n~~~~~~~~" + this.ROSEruns + " Paup Blocks:\n\n";
        news = news + this.PaupBlock;
        news = news + "\n\n~~~~~~~~file end:\n\n";
        news = news + this.endBlock;
        this.textArea1.setText(news);
    }

    private void roseWActionPerformed(ActionEvent evt) {
        this.datasets.clear();
        this.getROSE();
        try {
            this.parseROSE(false);
            this.writeFastaFiles();
            this.msg = this.datasets.size() + " unaligned ROSE datasets read and written to " + this.datasets.size() + " individual FASTA files.";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "ROSE file could not be parsed";
            this.setLabels();
        }
    }

    public void writeFastaFiles() throws IOException {
        Iterator it = this.datasets.iterator();
        String file = this.removeFileExtension(this.ROSEfilename);
        while (it.hasNext()) {
            dataset d = (dataset)it.next();
            System.out.print("\n" + d.name);
            File f = new File(file + d.name + ".fas");
            FileWriter fw = new FileWriter(f);
            Iterator i = d.sequences.iterator();
            while (i.hasNext()) {
                sequence s = (sequence)i.next();
                fw.write(s.name + "\n");
                fw.write(s.sequence + "\n\n");
            }
            fw.flush();
            fw.close();
        }
    }

    private void rosePActionPerformed(ActionEvent evt) {
        this.datasets.clear();
        this.getROSE();
        try {
            this.parseROSE(true);
            this.msg = this.datasets.size() + " ROSE datasets read";
            this.setLabels();
            System.out.print("\n\nparsing succesful\n");
            this.perturbAll();
            this.pm = new ProgressMonitor(this, "Encoding...", "", 0, nrOfCodings);
            CodeAllThread c = new CodeAllThread();
            c.start();
            this.msg = "All " + this.datasets.size() + " perturbed ROSE datasets run through all coding procedures. Saved in files \"..._all_... .nex\".";
            this.setLabels();
        }
        catch (Exception e) {
            this.msg = "perturbation failed";
            this.setLabels();
        }
    }

    public void perturbAll() {
        Iterator it = this.datasets.iterator();
        while (it.hasNext()) {
            dataset d = (dataset)it.next();
            this.perturbSingle(d);
            this.alignNames(d.sequences);
        }
    }

    public void perturbSingle(dataset d) {
        d.name = d.name + "; perturbed: P" + this.probP + " -- A" + this.probA + " - C" + this.probC + " - G" + this.probG + " - T" + this.probT;
        ListIterator<sequence> i = d.sequences.listIterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            String se = s.sequence;
            char[] arr = new char[se.length()];
            arr = se.toCharArray();
            for (int a = 0; a < se.length(); ++a) {
                double comp;
                if (se.charAt(a) == '-' || !((comp = Math.random()) <= this.probP / 100.0)) continue;
                comp = Math.random();
                if (comp >= 0.0 && comp < this.probA / 100.0) {
                    arr[a] = 65;
                }
                if (comp >= this.probA / 100.0 && comp < this.probA / 100.0 + this.probC / 100.0) {
                    arr[a] = 67;
                }
                if (comp >= this.probA / 100.0 + this.probC / 100.0 && comp < this.probA / 100.0 + this.probC / 100.0 + this.probG / 100.0) {
                    arr[a] = 71;
                }
                if (!(comp >= this.probA / 100.0 + this.probC / 100.0 + this.probG / 100.0) || !(comp < 1.0)) continue;
                arr[a] = 84;
            }
            String sst = "";
            for (int u = 0; u < se.length(); ++u) {
                sst = sst + arr[u];
            }
            i.remove();
            i.add(new sequence(s.name, sst));
        }
    }

    public void parseROSE(boolean aligned) throws IOException {
        File file = new File(this.ROSEfilename);
        FileReader fr = new FileReader(file);
        StreamTokenizer tok = new StreamTokenizer(fr);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.eolIsSignificant(false);
        String seq = "";
        String nam = "";
        boolean seqlen = false;
        if (aligned) {
            try {
                for (int i = 0; i < this.ROSEruns; ++i) {
                    this.sequences.clear();
                    seq = "";
                    nam = "";
                    do {
                        tok.nextToken();
                        if (tok.ttype != -1) continue;
                        throw new Exception("no\"-file");
                    } while (!tok.sval.equalsIgnoreCase("Alignment:"));
                    do {
                        sequence y;
                        tok.nextToken();
                        if (tok.sval.startsWith(">")) {
                            if (!nam.equalsIgnoreCase("")) {
                                nam = nam.substring(1, nam.length());
                                y = new sequence(nam, seq);
                                this.sequences.add(y);
                            }
                            nam = tok.sval;
                            seq = "";
                        } else {
                            if (tok.sval.startsWith("PHYLIP")) {
                                nam = nam.substring(1, nam.length());
                                y = new sequence(nam, seq);
                                this.sequences.add(y);
                                break;
                            }
                            seq = seq + tok.sval;
                        }
                    } while (tok.ttype != -1);
                    this.datasets.add(new dataset(this.sequences, i + 1, "dataset " + (i + 1)));
                }
            }
            catch (Exception e) {
                this.msg = "ROSE file could not be parsed";
                this.setLabels();
            }
        } else {
            try {
                for (int i = 0; i < 10; ++i) {
                    this.sequences.clear();
                    seq = "";
                    nam = "";
                    do {
                        tok.nextToken();
                        if (tok.ttype != -1) continue;
                        throw new Exception("no\"-file");
                    } while (!tok.sval.equalsIgnoreCase("Sequences:"));
                    do {
                        tok.nextToken();
                        if (tok.sval.startsWith(">")) {
                            if (!nam.equalsIgnoreCase("")) {
                                this.sequences.add(new sequence(nam, seq));
                            }
                            nam = tok.sval;
                            seq = "";
                        } else {
                            if (tok.sval.startsWith("Alignment:") || tok.sval.startsWith("PHYLIP")) {
                                this.sequences.add(new sequence(nam, seq));
                                break;
                            }
                            seq = seq + tok.sval;
                        }
                    } while (tok.ttype != -1);
                    this.datasets.add(new dataset(this.sequences, i + 1, "dataset" + (i + 1)));
                }
            }
            catch (Exception e) {
                this.msg = "ROSE file could not be parsed";
                this.setLabels();
            }
        }
    }

    public void getROSE() {
        this.msg = "ROSE...";
        this.setLabels();
        FileDialog fd = new FileDialog((Frame)this, "Import ROSE output...");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.curROSEFile = fd.getFile();
            this.ROSEfilename = fd.getDirectory() + fd.getFile();
            this.displayTextfile(this.ROSEfilename);
        }
    }

    private void benaActionPerformed(ActionEvent evt) {
        this.bena();
    }

    private void barrielActionPerformed(ActionEvent evt) {
        this.barriel();
    }

    private void baumActionPerformed(ActionEvent evt) {
        this.baum();
    }

    private void complexSimmActionPerformed(ActionEvent evt) {
        this.complexSimm();
    }

    public void bena() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.bena.getLabel(), this.borderItem.getState());
        String s = this.removeFileExtension(this.filename);
        s = s + "_be.nex";
        this.msg = "file (" + this.bena.getLabel() + ", _be.nex) saved. ";
        this.setLabels();
        this.displayTextfile(s);
    }

    public void barriel() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.barriel.getLabel(), this.borderItem.getState());
        String s = sic.removeFileExtension(this.filename);
        s = s + "_br.nex";
        this.msg = "file (" + this.barriel.getLabel() + ", _br.nex) saved. ";
        this.setLabels();
        this.displayTextfile(s);
    }

    public void baum() {
        ComplexIndelCoding cic = new ComplexIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.PaupCorr.getState(), this.baum.getLabel(), this.borderItem.getState());
        String s = cic.removeFileExtension(this.filename);
        s = s + "_bm.nex";
        this.msg = "matrix (" + this.baum.getLabel() + ")saved to " + s;
        this.setLabels();
        System.out.print(this.baum.getLabel() + " coding done\n");
        this.displayTextfile(s);
    }

    public void complexSimm() {
        this.msg = "\"" + this.complexSimm.getLabel() + "\" has been replaced by \"" + this.complex.getLabel() + "\".";
        this.setLabels();
        this.textArea1.setText("\n\n\t" + this.msg);
    }

    private void missActionPerformed(ActionEvent evt) {
        this.miss();
    }

    public void miss() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.curFile, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.miss.getLabel(), this.borderItem.getState());
        String s = sic.removeFileExtension(this.filename);
        s = s + "_miss.nex";
        System.out.print(s + "\n\n");
        try {
            File f = new File(s);
            FileWriter fw = new FileWriter(f);
            this.writeNexHead(fw, this.miss.getLabel());
            fw.write("BEGIN PAUP;\n\n");
            fw.write("END;\n");
            this.msg = "matrix (" + this.miss.getLabel() + ") saved to " + s;
            this.setLabels();
            System.out.print(this.miss.getLabel() + " coding done\n");
            fw.close();
            this.displayTextfile(s);
        }
        catch (Exception e) {
            System.out.print("\n!!Exception in " + this.miss.getLabel() + " - no file loaded?\n\n");
        }
    }

    private void gappedActionPerformed(ActionEvent evt) {
        this.gapped();
    }

    public void gapped() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.curFile, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.gapped.getLabel(), this.borderItem.getState());
        String s = sic.removeFileExtension(this.filename);
        s = s + "_exclGapped.nex";
        System.out.print(s + "\n\n");
        try {
            File f = new File(s);
            FileWriter fw = new FileWriter(f);
            this.writeNexHead(fw, this.gapped.getLabel());
            fw.write("BEGIN PAUP;\n");
            fw.write("exclude gapped /only;\n");
            fw.write("END;\n");
            this.msg = "matrix (" + this.gapped.getLabel() + ") saved to " + s;
            this.setLabels();
            System.out.print(this.gapped.getLabel() + " coding done\n");
            fw.close();
            this.displayTextfile(s);
        }
        catch (Exception e) {
            System.out.print("\n!!Exception in " + this.gapped.getLabel() + " - no file loaded?\n\n");
        }
    }

    private void fifthActionPerformed(ActionEvent evt) {
        this.fifth();
    }

    public void fifth() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.curFile, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.simple.getLabel(), this.borderItem.getState());
        String s = sic.removeFileExtension(this.filename);
        s = s + "_5th.nex";
        System.out.print(s + "\n\n");
        try {
            File f = new File(s);
            FileWriter fw = new FileWriter(f);
            this.writeNexHead(fw, this.fifth.getLabel());
            this.writeAssumptionsBlock(fw);
            fw.write("BEGIN PAUP;\n\n");
            fw.write("END;\n");
            this.msg = "matrix (" + this.fifth.getLabel() + ") saved to " + s;
            this.setLabels();
            System.out.print(this.fifth.getLabel() + " coding done\n");
            fw.close();
            this.displayTextfile(s);
        }
        catch (Exception e) {
            System.out.print("\n!!Exception in " + this.fifth.getLabel() + " - no file loaded?\n\n");
        }
    }

    public void writeNexHead(FileWriter fw, String st) throws IOException {
        fw.write("#NEXUS\n");
        fw.write("[!matrix with indels coded according to " + st + "]\n");
        Date d = new Date();
        fw.write("[!compiled on " + d + " with SeqState version " + this.version + " build " + this.date + "]\n\n");
        fw.write("BEGIN CHARACTERS;\n");
        fw.write("DIMENSIONS newtaxa ntax=" + this.sequences.size() + " NCHAR=");
        Iterator it = this.sequences.iterator();
        sequence se = (sequence)it.next();
        int charNr = se.sequence.length();
        fw.write(charNr + ";\n");
        fw.write("FORMAT \n");
        fw.write("\tDATATYPE = standard \n");
        fw.write("\tGAP = - \n");
        fw.write("\tMISSING = ? \n");
        fw.write("\tsymbols=\"0123456789A#C$EFG.IJ&L%>OPQ/'TU:*X<Z\" \n");
        fw.write("\tequate=\"R={AG} Y={CT} M={AC} K={GT} S={CG} W={AT} H={ACT} B={CGT} V={ACG} D={AGT} N={ACGT} r={AG} y={CT} m={AC} k={GT} s={CG} w={AT} h={ACT} b={CGT} v={ACG} d={AGT} n={ACGT}\"\n");
        fw.write(";\n");
        fw.write("\nMATRIX\n\n");
        Iterator it0 = this.sequences.iterator();
        sequence s0 = (sequence)it0.next();
        int sequenceLength = s0.sequence.length();
        int nameLength = s0.nameAligned.length();
        this.writeNumbersAbove(1, sequenceLength, nameLength + 1, fw);
        Iterator it2 = this.sequences.iterator();
        while (it2.hasNext()) {
            sequence s = (sequence)it2.next();
            fw.write(s.nameAligned + " " + s.sequence + "\n");
        }
        fw.write(";\nEND;\n");
        fw.write("\n\n");
    }

    public void writeAssumptionsBlock(FileWriter fw) throws IOException {
        fw.write("BEGIN ASSUMPTIONS;\n");
        fw.write("Options Gapmode=newstate;\n");
        fw.write("END;\n");
    }

    public void writeNumbersAbove(int start, int end, int indent, FileWriter fw) throws IOException {
        Vector<String> nrLabels = new Vector<String>();
        String rows = Integer.toString(end);
        int height = rows.length();
        for (int i = start; i <= end; ++i) {
            String nr = Integer.toString(i);
            nrLabels.add(nr);
        }
        for (int c = 0; c < height; ++c) {
            int d;
            if (c == 0) {
                for (d = 0; d < indent - 1; ++d) {
                    fw.write(" ");
                }
                fw.write("[");
            } else {
                for (d = 0; d < indent; ++d) {
                    fw.write(" ");
                }
            }
            Iterator it = nrLabels.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.length() > c) {
                    fw.write(s.charAt(c));
                    continue;
                }
                fw.write(" ");
            }
            if (c == height - 1) {
                fw.write("]");
            }
            fw.write("\n");
        }
        fw.write("\n");
    }

    private void IndelsActionPerformed(ActionEvent evt) {
    }

    private void localizeActionPerformed(ActionEvent evt) {
        this.pm = new ProgressMonitor(this, "Setting primer head positions for " + this.curFile + "...", "", 0, this.primers.size());
        AlignThread l = new AlignThread(this.primers);
        l.start();
        this.msg = "Setting primer head positions...";
        this.setLabels();
    }

    private void addActionPerformed(ActionEvent evt) {
        JDialogNP dNP = new JDialogNP((Frame)this, false);
        dNP.setLocationRelativeTo(this);
        dNP.setTitle("New primer");
        dNP.setVisible(true);
        primer p = dNP.returnPrimer();
        if (dNP.getReturnStatus() == 1) {
            this.primers.add(p);
        }
        this.setLabels();
    }

    private void GapsActionPerformed(ActionEvent evt) {
    }

    private void DesignActionPerformed(ActionEvent evt) {
        this.evaluateDesign();
    }

    private void bootActionPerformed(ActionEvent evt) {
    }

    private void checkboxMenuItem4ActionPerformed(ActionEvent evt) {
    }

    private void StatisticsActionPerformed(ActionEvent evt) {
    }

    private void closeActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void statActionPerformed(ActionEvent evt) {
        Object i;
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.curFile, this.version, this.date, this.filter, this.ignoreMiss.getState(), this.simple.getLabel(), this.borderItem.getState());
        Iterator csi = this.charsets.iterator();
        while (csi.hasNext()) {
            charset cs = (charset)csi.next();
            cs.indels = new Vector();
            Iterator ini = sic.indels.iterator();
            while (ini.hasNext()) {
                i = (Indel)ini.next();
                if (((Indel)i).from < cs.from || ((Indel)i).from > cs.to) continue;
                cs.indels.add(i);
            }
        }
        try {
            File indelStat = new File(this.curFile + ".is");
            FileWriter fw = new FileWriter(indelStat);
            i = this.charsets.iterator();
            fw.write("charset\t#indels\n\n");
            while (i.hasNext()) {
                charset c = (charset)i.next();
                fw.write(c.name + "\t" + c.indels.size() + "\n");
            }
            fw.close();
            this.msg = "indels number per charset written to " + this.curFile + ".is";
            this.setLabels();
            String s = this.curFile + ".is";
            this.displayTextfile(s);
        }
        catch (Exception e) {
            this.msg = "FileWriter problem";
            this.setLabels();
            System.out.print("FileWriter problem");
        }
    }

    private void complexActionPerformed(ActionEvent evt) {
        this.modifiedComplex();
    }

    public void modifiedComplex() {
        ComplexIndelCoding cic = new ComplexIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), true, this.complex.getLabel(), this.borderItem.getState());
        String s = cic.removeFileExtension(this.filename);
        s = s + "_mcic.nex";
        this.msg = "matrix (" + this.complex.getLabel() + ")saved to " + s;
        this.setLabels();
        System.out.print(this.complex.getLabel() + " coding done\n");
        this.displayTextfile(s);
    }

    private void displayTextfile(String s) {
        String txt = "";
        int c = 0;
        try {
            FileReader fr = new FileReader(s);
            for (int a = 0; c != -1 && a < 10000; ++a) {
                c = fr.read();
                if (c == -1) break;
                txt = txt + (char)c;
            }
            fr.close();
            if (c != -1) {
                txt = txt + "\n\n....and so on .. see " + s + " for remaining content";
            }
            this.textArea1.setText(txt);
        }
        catch (Exception e) {
            this.msg = this.msg + " (file cannot be displayed)";
            this.setLabels();
        }
    }

    public void readFileAndAppend(FileWriter fw, File fileToRead) {
        String txt = "";
        int c = 0;
        try {
            FileReader fr = new FileReader(fileToRead);
            while (c != -1 && (c = fr.read()) != -1) {
                fw.write(c);
            }
            fr.close();
        }
        catch (Exception e) {
            this.msg = this.msg + fileToRead + " cannot be written/read)";
            this.setLabels();
        }
    }

    private void simpleActionPerformed(ActionEvent evt) {
        this.simple();
    }

    public void simple() {
        SimpleIndelCoding sic = new SimpleIndelCoding(this.sequences, this.filename, this.version, this.date, this.three.getState(), this.ignoreMiss.getState(), this.simple.getLabel(), this.borderItem.getState());
        String s = sic.removeFileExtension(this.filename);
        s = s + "_sic.nex";
        this.msg = "file (" + this.simple.getLabel() + ")saved to " + s;
        this.setLabels();
        System.out.print("simple indel coding done\n");
        this.displayTextfile(s);
    }

    private void GenBankActionPerformed(ActionEvent evt) {
        FileDialog fd = new FileDialog((Frame)this, "save FASTA, ID + organism name", 1);
        fd.setFile("*.fas");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.GenBankFile = fd.getDirectory() + fd.getFile();
            this.GenBankList = this.GenBankFile + ".xls";
        }
        File GBfasta = new File(this.GenBankFile);
        File GBtable = new File(this.GenBankList);
        try {
            FileWriter fwfas = new FileWriter(GBfasta);
            FileWriter fwtab = new FileWriter(GBtable);
            Collections.sort(this.charsets, this.charSetsByLocation);
            fwtab.write("taxon/ID\t");
            Iterator ii = this.charsets.iterator();
            while (ii.hasNext()) {
                charset cc = (charset)ii.next();
                fwtab.write(cc.name + "\t");
            }
            fwtab.write("\n");
            Iterator seqI = this.sequences.iterator();
            while (seqI.hasNext()) {
                charset cs;
                sequence s = (sequence)seqI.next();
                System.out.println("\n***working on tax " + s.name + "***");
                s.sequence.toUpperCase();
                String buf = "";
                String GBseq = "";
                char ch = '\u0000';
                int beginrealseq = 0;
                int endrealseq = 0;
                boolean beginfound = false;
                boolean endfound = false;
                int gaps = 0;
                int i = s.sequence.length() - 1;
                while (!endfound) {
                    ch = s.sequence.charAt(i);
                    if (ch != '-' && ch != '?') {
                        endrealseq = i;
                        endfound = true;
                    }
                    --i;
                }
                i = 0;
                while (!beginfound) {
                    ch = s.sequence.charAt(i);
                    if (ch != '-' && ch != '?') {
                        beginrealseq = i;
                        beginfound = true;
                    }
                    ++i;
                }
                ++endrealseq;
                ++beginrealseq;
                Iterator it = this.charsets.iterator();
                while (it.hasNext()) {
                    charset cs2 = (charset)it.next();
                    System.out.println("\n" + cs2.name + "(" + (cs2.to - cs2.from + 1) + ")");
                    cs2.valid = true;
                    cs2.gaps = 0;
                    if (cs2.to < beginrealseq) {
                        cs2.valid = false;
                        cs2.gaps = cs2.to - cs2.from + 1;
                        System.out.println(cs2.name + " gaps1: " + cs2.gaps);
                        continue;
                    }
                    if (cs2.from > endrealseq) {
                        cs2.valid = false;
                        cs2.gaps += cs2.to - cs2.from + 1;
                        System.out.println(cs2.name + " gaps2: " + cs2.gaps);
                        continue;
                    }
                    if (cs2.from < beginrealseq) {
                        cs2.gaps = beginrealseq - cs2.from;
                        System.out.println(cs2.name + " gaps3: " + cs2.gaps);
                    }
                    if (cs2.to > endrealseq) {
                        cs2.gaps += cs2.to - endrealseq;
                        System.out.println(cs2.name + " gaps4: " + cs2.gaps);
                    }
                    for (int i2 = cs2.from; i2 < cs2.to; ++i2) {
                        ch = s.sequence.charAt(i2);
                        if (ch != '-') continue;
                        ++cs2.gaps;
                    }
                    System.out.println(cs2.name + " gaps incl \"-\"s: " + cs2.gaps);
                }
                fwtab.write(s.nameGB + "\t");
                ListIterator csI = this.charsets.listIterator();
                while (csI.hasNext()) {
                    ListIterator csI2 = this.charsets.listIterator(csI.nextIndex());
                    cs = (charset)csI.next();
                    cs.fromAbs = cs.from;
                    cs.toAbs = cs.to - cs.gaps;
                    while (csI2.hasPrevious()) {
                        charset cs2 = (charset)csI2.previous();
                        cs.fromAbs -= cs2.gaps;
                        if (csI.hasNext()) {
                            cs.toAbs -= cs2.gaps;
                            continue;
                        }
                        cs.toAbs = Integer.MAX_VALUE;
                    }
                    if (cs.valid) {
                        if (cs.toAbs != Integer.MAX_VALUE) {
                            fwtab.write(cs.fromAbs + "-" + cs.toAbs + "\t");
                        } else {
                            fwtab.write(cs.fromAbs + "-" + "end" + "\t");
                        }
                    } else {
                        cs.fromAbs = 0;
                        cs.toAbs = 0;
                        fwtab.write("--\t");
                    }
                    System.out.print("\t" + cs.name + ": " + cs.from + "-" + cs.to + "  Abs: " + cs.fromAbs + "-" + cs.toAbs + " (" + (cs.toAbs - cs.fromAbs + 1) + ") check:" + (cs.to - cs.from + 1 - cs.gaps) + "\n");
                }
                buf = s.sequence.substring(beginrealseq - 1, endrealseq);
                buf = buf.replace('?', 'N');
                for (int i3 = 0; i3 < buf.length(); ++i3) {
                    ch = buf.charAt(i3);
                    if (ch == '-') continue;
                    GBseq = GBseq + ch;
                    ++gaps;
                }
                fwfas.write(">" + s.name + " [org=" + s.nameGB + "]" + "\n" + GBseq + "\n\n");
                fwtab.write("\n");
                Iterator iii = this.charsets.iterator();
                while (iii.hasNext()) {
                    cs = (charset)iii.next();
                    cs.valid = true;
                }
            }
            fwtab.flush();
            fwtab.close();
            fwfas.flush();
            fwfas.close();
            this.msg = "written to FASTA + domain-specification file *.xls (" + this.GenBankList + ")...";
            this.setLabels();
            System.out.print("Sequences exported to " + GBfasta.getAbsolutePath() + "\n");
            System.out.print("\tand domain information to " + GBtable.getAbsolutePath() + "\n");
            System.out.flush();
        }
        catch (Exception e) {
            System.out.print("problems with FileWriter");
        }
    }

    private void HelpMenuActionPerformed(ActionEvent evt) {
    }

    private void loadPrimersActionPerformed(ActionEvent evt) {
        this.msg = "loading primers and calculating positions in alignment...";
        this.setLabels();
        FileDialog fd = new FileDialog((Frame)this, "Import primers...");
        fd.setFile("*.prs");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.primersLoaded = fd.getDirectory() + fd.getFile();
        }
        ArrayList<primer> npl = new ArrayList<primer>();
        int nr = 0;
        try {
            File file = new File(this.primersLoaded);
            FileReader fr = new FileReader(file);
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            String seq = "";
            String nam = "";
            String forw = "";
            tok.nextToken();
            boolean alreadythere = false;
            int inFile = 0;
            do {
                tok.nextToken();
                if (tok.ttype == -1) break;
                nam = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                seq = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                forw = tok.sval;
                primer p = new primer(1, seq.length() - 1, nam, seq);
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.designedBy = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.comment1 = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.comment2 = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.comment3 = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.publication = tok.sval;
                tok.nextToken();
                if (tok.ttype == -1) break;
                p.isPublished = tok.sval.equalsIgnoreCase("P");
                p.forward = forw.equalsIgnoreCase("F");
                p.size = seq.length();
                p.pureSequence = p.sequence;
                p.sequenceAligned = p.sequence;
                p.oligo53 = p.sequence;
                p.RC();
                p.external = true;
                p.getTriplets();
                p.countNts();
                Iterator pi = this.primers.iterator();
                while (pi.hasNext()) {
                    primer pp = (primer)pi.next();
                    this.setLabels();
                    if (!pp.name.equals(p.name)) continue;
                    alreadythere = true;
                }
                if (!alreadythere) {
                    npl.add(p);
                    ++nr;
                }
                alreadythere = false;
                ++inFile;
            } while (tok.ttype != -1);
            fr.close();
            this.msg = "Loaded " + nr + " primers not already in memory (out of " + inFile + " in file).";
            this.setLabels();
            this.primers.addAll(npl);
        }
        catch (IOException e) {
            this.msg = "no file \"SeqStaterc\"";
            this.setLabels();
        }
    }

    public boolean getHeadPos(primer p) {
        ListIterator li = this.sequences.listIterator();
        while (li.hasNext()) {
            int currentHeadPos = 0;
            sequence s = (sequence)li.next();
            currentHeadPos = this.alignToSequence(p, s.sequence);
            if (currentHeadPos == -1) continue;
            p.headposition = currentHeadPos;
            if (p.forward) {
                p.lastPos = p.headposition;
                p.firstPos = p.headposition - p.sequence.length() + 1;
            } else {
                p.firstPos = p.headposition;
                p.lastPos = p.headposition + p.sequence.length() - 1;
            }
            return true;
        }
        if (p.isAligned) {
            return true;
        }
        p.external = true;
        return false;
    }

    public int alignToSequence(primer p, String sequence2) {
        if (p.isAligned) {
            return -1;
        }
        String primer2 = "";
        primer2 = p.forward ? p.oligo53 : p.RC(p.oligo53);
        boolean currentHeadPos = false;
        int mismatchs = 0;
        for (int i = 0; i < sequence2.length() - primer2.length() - 1; ++i) {
            boolean containsMissingData = false;
            mismatchs = 0;
            String matching = sequence2.substring(i, i + primer2.length());
            for (int k = 0; k < primer2.length(); ++k) {
                if (matching.substring(k, k + 1).equalsIgnoreCase("?") || matching.substring(k, k + 1).equalsIgnoreCase("-") || matching.substring(k, k + 1).equalsIgnoreCase("N")) {
                    mismatchs = primer2.length();
                    continue;
                }
                if (SeqState.equalsDegenerate(primer2.substring(k, k + 1), matching.substring(k, k + 1))) continue;
                ++mismatchs;
            }
            if (mismatchs > 4) continue;
            if (p.forward) {
                return i + primer2.length() - 1;
            }
            return i;
        }
        return -1;
    }

    public int getMin(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private void htmlPrimersActionPerformed(ActionEvent evt) {
        FileDialog fd = new FileDialog((Frame)this, "save primers to...", 1);
        fd.setFile("*.html");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.primersSaved = fd.getDirectory() + fd.getFile();
        }
        this.msg = "writing primers to file...";
        this.setLabels();
        String nam = "";
        String des = "";
        String c1 = "";
        String c2 = "";
        String c3 = "";
        String pub = "";
        String P = "";
        try {
            File f = new File(this.primersSaved);
            FileWriter fw = new FileWriter(f);
            fw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            fw.write("<html>");
            fw.write("<head>");
            fw.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            fw.write("<title>Primer (exported from SeqState</title>");
            fw.write("</head>");
            fw.write("<body>");
            fw.write("<table width=\"100%\"  border=\"1\">");
            Iterator li = this.primers.iterator();
            int nr = 0;
            fw.write("<tr><th align=\"left\" scope=\"col\">name</th><th  align=\"left\" scope=\"col\">5'->3' sequence</th><th  align=\"left\" scope=\"col\">orientation</th><th  align=\"left\" scope=\"col\">designed by</th><th  align=\"left\" scope=\"col\">used for</th><th align=\"left\"  scope=\"col\">target region</th><th  align=\"left\" scope=\"col\">publication</th></tr>");
            while (li.hasNext()) {
                primer p = (primer)li.next();
                if (p.sequence == "outside" || !p.isPublished) continue;
                ++nr;
                fw.write("<tr>");
                nam = p.name.replace(' ', '_');
                fw.write("<td>" + nam + "</td>" + "<td>" + p.oligo53 + "</td>");
                if (p.forward) {
                    fw.write("<td>F</td>");
                } else {
                    fw.write("<td>R</td>");
                }
                des = p.designedBy.replace('_', ' ');
                c1 = p.comment1.replace('_', ' ');
                c2 = p.comment2.replace('_', ' ');
                c3 = p.comment3.replace('_', ' ');
                pub = p.publication.replace('_', ' ');
                fw.write("<td>" + des + "</td><td>" + c1 + "</td><td>" + c3 + "</td><td>" + pub + "</td>");
                fw.write("</tr>");
                fw.write("\n");
            }
            fw.write("</table>");
            fw.write("</body>");
            fw.write("</html>");
            this.msg = "" + nr + " primers saved to " + f.getAbsolutePath();
            this.setLabels();
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            this.msg = "could not create file SeqStaterc";
            this.setLabels();
        }
    }

    private void savePrimersActionPerformed(ActionEvent evt) {
        FileDialog fd = new FileDialog((Frame)this, "save primers to...", 1);
        fd.setFile("*.prs");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.primersSaved = fd.getDirectory() + fd.getFile();
        }
        this.msg = "writing primers to file...";
        this.setLabels();
        String nam = "";
        String des = "";
        String c1 = "";
        String c2 = "";
        String c3 = "";
        String pub = "";
        String P = "";
        try {
            File f = new File(this.primersSaved);
            FileWriter fw = new FileWriter(f);
            fw.write("SeqStaterc\n\n");
            Iterator li = this.primers.iterator();
            int nr = 0;
            while (li.hasNext()) {
                primer p = (primer)li.next();
                if (p.sequence == "outside") continue;
                ++nr;
                nam = p.name.replace(' ', '_');
                fw.write(nam + " " + p.oligo53 + " ");
                if (p.forward) {
                    fw.write("F");
                } else {
                    fw.write("R");
                }
                des = p.designedBy.replace(' ', '_');
                c1 = p.comment1.replace(' ', '_');
                c2 = p.comment2.replace(' ', '_');
                c3 = p.comment3.replace(' ', '_');
                pub = p.publication.replace(' ', '_');
                P = p.isPublished ? "P" : "N";
                fw.write("\t" + des + "\t" + c1 + "\t" + c2 + "\t" + c3 + "\t" + pub + "\t" + P);
                fw.write("\n");
            }
            this.msg = "" + nr + " primers saved to " + f.getAbsolutePath();
            this.setLabels();
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            this.msg = "could not create file SeqStaterc";
            this.setLabels();
        }
    }

    private void wholeDatasetActionPerformed(ActionEvent evt) {
        if (this.sequences.size() < 1) {
            this.msg = "no NEXUS file loaded";
            this.setLabels();
            return;
        }
        this.whole = true;
        CalculateThread c = new CalculateThread();
        c.start();
    }

    private void CharsetsActionPerformed(ActionEvent evt) {
        if (this.checkboxMenuItem1.getState()) {
            this.nrep = 50;
        }
        if (this.checkboxMenuItem2.getState()) {
            this.nrep = 100;
        }
        if (this.checkboxMenuItem3.getState()) {
            this.nrep = 500;
        }
        if (this.checkboxMenuItem4.getState()) {
            this.nrep = 1000;
        }
        if (this.sequences.size() < 1) {
            this.msg = "no NEXUS file loaded";
            this.setLabels();
            return;
        }
        if (this.charsets.size() < 1) {
            this.msg = "no charsets defined";
            this.setLabels();
            return;
        }
        this.pm = new ProgressMonitor(this, "Calculating...", this.filename, 0, this.charsets.size());
        CalculateThread c = new CalculateThread();
        c.start();
    }

    private void GapSettingsActionPerformed(ActionEvent evt) {
        this.msg = "Gap analysis Settings: ";
        this.setLabels();
        JDialog1 d = new JDialog1((Frame)this, true);
        d.setLocationRelativeTo(this);
        d.setValues(this.ignore, this.len, this.maxdis);
        d.setVisible(true);
        String sa = d.geta();
        String sb = d.getb();
        String sc = d.getc();
        this.ignore = Integer.parseInt(sa);
        this.len = Integer.parseInt(sb);
        this.maxdis = Integer.parseInt(sc);
        this.msg = this.msg + "Ignore - " + this.ignore + "bp; read " + this.len + "bp; max. dis. " + this.maxdis + "bp";
        this.setLabels();
    }

    private void showPrimersActionPerformed(ActionEvent evt) {
        this.setLabels();
        JDialogP dP = new JDialogP((Frame)this, true);
        Iterator it = this.primers.iterator();
        while (it.hasNext()) {
            primer p = (primer)it.next();
            if (p.sequence.equalsIgnoreCase("outside") || p.external) continue;
            p.fitToOthers(this.sequences);
        }
        dP.addPrimers(this.primers);
        dP.addTaxa(this.sequences);
        dP.setSize(400, 500);
        dP.setLocationRelativeTo(this);
        dP.setVisible(true);
        this.setLabels();
    }

    private void sortByNameActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byName);
    }

    private void sortByDesignActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byDesign);
    }

    private void sortByLabcodeActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byLabcode);
    }

    private void sortByReferenceActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byReference);
    }

    private void sortByRegionActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byRegion);
    }

    private void sortByTaxaActionPerformed(ActionEvent evt) {
        Collections.sort(this.primers, this.byTaxa);
    }

    private void AboutActionPerformed(ActionEvent evt) {
        JAboutSeqStDialog dA = new JAboutSeqStDialog((Frame)this, true);
        dA.setTitle("SeqState " + this.version + " -- build " + this.date);
        dA.setLocationRelativeTo(this);
        dA.pack();
        dA.setVisible(true);
    }

    private void HelpActionPerformed(ActionEvent evt) {
        this.help();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void help() {
        this.msg = "Loading help ...";
        this.setLabels();
        boolean seemsToWork = false;
        try {
            if (Desktop.isDesktopSupported()) {
                this.desktop = Desktop.getDesktop();
                if (this.desktop.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = null;
                    try {
                        uri = new URI("http://systevol.nees.uni-bonn.de/software/downloads/SeqStateDocu.html");
                        this.desktop.browse(uri);
                        seemsToWork = true;
                        this.msg = "Showing " + uri.toString();
                        this.setLabels();
                        System.out.println(this.msg);
                    }
                    catch (IOException ioe) {
                        System.out.println("The system cannot find the " + uri + " file specified");
                        ioe.printStackTrace();
                    }
                    catch (URISyntaxException use) {
                        System.out.println("Illegal character in path");
                        use.printStackTrace();
                    }
                }
            }
        }
        catch (Exception cnfe) {
            System.out.println("class not found. not 1.6?");
            cnfe.printStackTrace();
        }
        finally {
            if (!seemsToWork) {
                this.openHTMLpane();
            }
        }
    }

    private void openHTMLpane() {
        this.msg = "Online help could not be launched. Trying local ...";
        this.setLabels();
        System.out.println(this.msg);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        URL helpURL = SeqState.class.getResource("rs/SeqStateDocu.html");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: rs/SeqStateDocu.html");
        }
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(500, 600));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JFrame frame = new JFrame("Local Help (unable to load remote files)");
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(editorScrollPane);
        frame.pack();
        frame.setLocationRelativeTo(this);
        frame.setVisible(true);
    }

    private void manualActionPerformed(ActionEvent evt) {
        this.msg = "manual input...";
        this.setLabels();
        JDialog2 d2 = new JDialog2((Frame)this, true);
        d2.setLocationRelativeTo(this);
        d2.setVisible(true);
        d2.setSize(200, 200);
    }

    private void primerSettingsActionPerformed(ActionEvent evt) {
        this.msg = "Primer analysis Settings: ";
        this.setLabels();
        JDialog1 d = new JDialog1((Frame)this, true);
        d.setLocationRelativeTo(this);
        d.setValues(this.ignore, this.len, this.maxdis);
        d.setVisible(true);
        String sa = d.geta();
        String sb = d.getb();
        String sc = d.getc();
        this.ignore = Integer.parseInt(sa);
        this.len = Integer.parseInt(sb);
        this.maxdis = Integer.parseInt(sc);
        this.msg = this.msg + "" + this.ignore + " - " + this.len + " - " + this.maxdis;
        this.setLabels();
    }

    public void evaluateDesign() {
        JDialogP pr = new JDialogP((Frame)this, true);
        pr.setSize(400, 500);
        pr.setLocationRelativeTo(this);
        pr.addPrimers(this.primers);
        pr.setTitle("confirm primers for analysis - delete others: ");
        pr.setVisible(true);
        this.completeSequences.clear();
        if (this.sequences.size() < 1) {
            this.msg = "no NEXUS file loaded";
            this.setLabels();
        } else {
            this.msg = "analysing and writing to file...";
            this.setLabels();
            try {
                int j;
                this.dis = "";
                File f = new File(this.filename + "_table.txt");
                FileWriter fw = new FileWriter(f);
                fw.write("SeqState analysis results for " + this.filename + " \n\n");
                File fl = new File(this.filename + "_list.txt");
                FileWriter fwl = new FileWriter(fl);
                fwl.write("SeqState analysis results for " + this.filename + "\n\n");
                for (j = 0; j < 150; ++j) {
                    fw.write("_");
                }
                fw.write("\n\n");
                fw.write("taxon\tmissing\tprimer\tmismatches\tremaining\tprimer\tmatching\n");
                for (j = 0; j < 150; ++j) {
                    fw.write("_");
                }
                fw.write("\n\n");
                String primerSeq = "n.a.";
                String matching = "n.a.";
                Iterator i = this.sequences.iterator();
                while (i.hasNext()) {
                    sequence s = (sequence)i.next();
                    s.findgaps(this.ignore);
                    Iterator ig = s.gaps.iterator();
                    if (!ig.hasNext()) {
                        this.completeSequences.add(s.name);
                        continue;
                    }
                    fwl.write(s.name + ": ");
                    this.dis = this.dis + s.name + ": ";
                    fw.write(s.name + "\n\t");
                    System.out.println();
                    fwl.write("\n");
                    this.dis = this.dis + "\n";
                    while (ig.hasNext()) {
                        sequence.gap g = (sequence.gap)ig.next();
                        System.out.print(" missing: pos. " + (g.beginning + 1) + "-" + (g.end + 1) + " (gap size: " + g.size + ")");
                        fwl.write(" missing: pos. " + (g.beginning + 1) + "-" + (g.end + 1) + " (gap size: " + g.size + ")");
                        this.dis = this.dis + " missing: pos. " + (g.beginning + 1) + "-" + (g.end + 1) + " (gap size: " + g.size + ")";
                        fw.write(g.beginning + 1 + "-" + (g.end + 1) + " (" + g.size + " pos.)\t");
                        g.findClosePrimers(this.primers, this.maxdis, this.len);
                        ListIterator ip = g.closePrimers.listIterator();
                        if (!ip.hasNext()) {
                            this.newprimers.clear();
                            Primerdesign pd = new Primerdesign(this.sequences, s, g, this.newprimers);
                            System.out.println("\n    10 best new primers suggested:");
                            fwl.write("\n    10 best new primers suggested:\n");
                            this.dis = this.dis + "\n    10 best new primers suggested:\n";
                            fw.write("new suggested:\tfits to (from)\tTm\taligned:\toligo to synthesize:\n");
                            ListIterator nprl = this.newprimers.listIterator();
                            for (int wieviel = 0; nprl.hasNext() && wieviel < 10; ++wieviel) {
                                primer prn = (primer)nprl.next();
                                fw.write("\t\t" + prn.name + "\t");
                                prn.countNts();
                                prn.fitToOthers(this.sequences);
                                if (prn.GC == 0.0) {
                                    fw.write("[deg.]\t[deg.]");
                                } else {
                                    fw.write("" + this.df.format(prn.fitToOthers) + "%(" + this.df.format(prn.validOthers) + "%)\t" + this.df.format(prn.Tm) + "\u00b0C\t");
                                }
                                if (prn.forward) {
                                    fw.write(prn.sequence + ">\t" + prn.sequence + "\n");
                                } else {
                                    fw.write("<" + prn.sequence + "\t");
                                    prn.RC();
                                    fw.write(prn.RCsequence + "\n");
                                }
                                if (prn.forward) {
                                    System.out.println("     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C");
                                    fwl.write("     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n");
                                    this.dis = this.dis + "     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n";
                                    continue;
                                }
                                System.out.println("     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C");
                                System.out.println("        (synthesize " + prn.RCsequence + " )");
                                fwl.write("     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n");
                                this.dis = this.dis + "     " + prn.name + " " + prn.sequence + "; fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n";
                                fwl.write("        (synthesize " + prn.RCsequence + " )\n");
                                this.dis = this.dis + "        (synthesize " + prn.RCsequence + " )\n";
                            }
                            System.out.println("     [available primers are not close enough]");
                            fwl.write("     [available primers are not close enough]\n");
                            this.dis = this.dis + "     [available primers are not close enough]\n";
                            fw.write("\t\t[available primers are not close enough]\n");
                        }
                        System.out.println();
                        fwl.write("\n");
                        this.dis = this.dis + "\n";
                        while (ip.hasNext()) {
                            sequence.gap.Closeprimer p = (sequence.gap.Closeprimer)ip.next();
                            if (p.p.sequence.equals("outside") || p.p.external) continue;
                            primerSeq = p.p.sequenceAligned;
                            matching = s.sequence.substring(p.p.firstPos, p.p.lastPos + 1);
                            int score = 0;
                            boolean head = false;
                            for (int k = 0; k < primerSeq.length(); ++k) {
                                if (SeqState.equalsDegenerate(primerSeq.substring(k, k + 1), matching.substring(k, k + 1))) continue;
                                ++score;
                                if (p.p.forward) {
                                    if (k <= primerSeq.length() - 5) continue;
                                    p.headAffected = true;
                                    continue;
                                }
                                if (k >= 5) continue;
                                p.headAffected = true;
                            }
                            p.mismatches = score;
                        }
                        Collections.sort(g.closePrimers);
                        ListIterator ip2 = g.closePrimers.listIterator();
                        for (int ctr = 1; ip2.hasNext() && ctr <= 3; ++ctr) {
                            sequence.gap.Closeprimer cp = (sequence.gap.Closeprimer)ip2.next();
                            if (ctr == 1 && (cp.headAffected || cp.mismatches >= 3)) {
                                this.newprimers.clear();
                                Primerdesign pd = new Primerdesign(this.sequences, s, g, this.newprimers);
                                System.out.println("    10 best new primers suggested:");
                                fwl.write("    10 best new primers suggested:\n");
                                this.dis = this.dis + "    10 best new primers suggested:\n";
                                fw.write("new suggested:\tfits to (from)\tTm\taligned:\toligo to synthesize:\n");
                                ListIterator nprl = this.newprimers.listIterator();
                                for (int wieviel = 0; nprl.hasNext() && wieviel < 10; ++wieviel) {
                                    primer prn = (primer)nprl.next();
                                    fw.write("\t\t" + prn.name + "\t");
                                    prn.countNts();
                                    prn.fitToOthers(this.sequences);
                                    if (prn.GC == 0.0) {
                                        fw.write("[deg.]\t[deg.]");
                                    } else {
                                        fw.write("" + this.df.format(prn.fitToOthers) + "%(" + this.df.format(prn.validOthers) + "%)\t" + this.df.format(prn.Tm) + "\u00b0C\t");
                                    }
                                    if (prn.forward) {
                                        fw.write(prn.sequence + ">\t" + prn.sequence + "\n");
                                    } else {
                                        fw.write("<" + prn.sequence + "\t");
                                        prn.RC();
                                        fw.write(prn.RCsequence + "\n");
                                    }
                                    if (prn.forward) {
                                        System.out.println("     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C");
                                        fwl.write("     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + ") GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n");
                                        this.dis = this.dis + "     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + ") GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n";
                                        continue;
                                    }
                                    System.out.println("     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C");
                                    System.out.println("        (synthesize " + prn.RCsequence + " )");
                                    fwl.write("     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n");
                                    this.dis = this.dis + "     " + prn.name + " " + prn.sequence + " fits to " + this.df.format(prn.fitToOthers) + "% (" + this.df.format(prn.validOthers) + "%) GC: " + this.df.format(prn.GC) + "% Tm: " + this.df.format(prn.Tm) + "\u00b0C\n";
                                    fwl.write("        (synthesize " + prn.RCsequence + " )\n");
                                    this.dis = this.dis + "        (synthesize " + prn.RCsequence + " )\n";
                                }
                                System.out.print("     [best available, " + cp.p.name + ", has " + cp.mismatches + " mismatches");
                                if (cp.headAffected) {
                                    System.out.println(", head affected].");
                                } else {
                                    System.out.println("].");
                                }
                                fwl.write("     [best available, " + cp.p.name + ", has " + cp.mismatches + " mismatches");
                                this.dis = this.dis + "     [best available, " + cp.p.name + ", has " + cp.mismatches + " mismatches";
                                if (cp.headAffected) {
                                    fwl.write(", head affected].\n");
                                } else {
                                    fwl.write("].\n");
                                }
                                this.dis = cp.headAffected ? this.dis + ", head affected].\n" : this.dis + "].\n";
                                fw.write("\t\t[best available, " + cp.p.name + ", has " + cp.mismatches + " mismatches");
                                if (cp.headAffected) {
                                    fw.write(", head affected].");
                                    break;
                                }
                                fw.write("].\n");
                                break;
                            }
                            System.out.print("  ");
                            fwl.write("  ");
                            this.dis = this.dis + "  ";
                            System.out.print(cp.p.name + "  (remaining gap size: " + cp.remaining + ")");
                            fwl.write(cp.p.name + "  (remaining gap size: " + cp.remaining + ")");
                            this.dis = this.dis + cp.p.name + "  (remaining gap size: " + cp.remaining + ")";
                            fw.write(cp.p.name + "\t");
                            if (!cp.p.sequence.equals("outside") && !cp.p.external) {
                                System.out.println();
                                fwl.write("\n");
                                this.dis = this.dis + "\n";
                                System.out.print("  ");
                                fwl.write("  ");
                                this.dis = this.dis + "  ";
                                System.out.print("  (" + cp.mismatches + " mismatches");
                                fwl.write("  (" + cp.mismatches + " mismatches");
                                this.dis = this.dis + "  (" + cp.mismatches + " mismatches";
                                fw.write("" + cp.mismatches);
                                if (cp.headAffected) {
                                    System.out.println(", primer head affected!)");
                                    fwl.write(", primer head affected!)\n");
                                    this.dis = this.dis + ", primer head affected!)\n";
                                    fw.write(", head!\t");
                                } else {
                                    System.out.println(")");
                                    fwl.write(")\n");
                                    this.dis = this.dis + ")\n";
                                    fw.write("\t");
                                }
                                fw.write(cp.remaining + "\t");
                                primerSeq = cp.p.sequenceAligned;
                                primerSeq = primerSeq.toUpperCase();
                                matching = s.sequence.substring(cp.p.firstPos, cp.p.lastPos + 1);
                                if (cp.p.forward) {
                                    fw.write(primerSeq + ">\t");
                                    System.out.print("\t");
                                    System.out.print(primerSeq);
                                    System.out.print(">");
                                    System.out.print("\n\t" + matching);
                                    fwl.write("\t");
                                    fwl.write(primerSeq);
                                    fwl.write(">");
                                    fwl.write("\n\t" + matching);
                                    this.dis = this.dis + "\t";
                                    this.dis = this.dis + primerSeq;
                                    this.dis = this.dis + ">";
                                    this.dis = this.dis + "\n\t" + matching;
                                } else {
                                    fw.write("<" + primerSeq + "\t");
                                    System.out.print("\t");
                                    System.out.print("<");
                                    System.out.print(primerSeq);
                                    System.out.print("\n\t " + matching);
                                    fwl.write("\t");
                                    fwl.write("<");
                                    fwl.write(primerSeq);
                                    fwl.write("\n\t " + matching);
                                    this.dis = this.dis + "\t";
                                    this.dis = this.dis + "<";
                                    this.dis = this.dis + primerSeq;
                                    this.dis = this.dis + "\n\t " + matching;
                                }
                                fw.write(matching + "\t");
                            } else {
                                fw.write("\t" + cp.remaining);
                            }
                            if (ip2.hasNext() && ctr <= 2) {
                                fw.write("\n\t\t");
                            }
                            System.out.println();
                            fwl.write("\n");
                            this.dis = this.dis + "\n";
                        }
                        if (!ig.hasNext()) continue;
                        fw.write("\n\t");
                    }
                    fw.write("\n");
                    for (int j2 = 0; j2 < 150; ++j2) {
                        fw.write("_");
                    }
                    fw.write("\n");
                    System.out.println();
                    fwl.write("\n");
                    this.dis = this.dis + "\n";
                }
                Iterator cp = this.completeSequences.iterator();
                if (cp.hasNext()) {
                    System.out.println("complete sequences:\n");
                    fw.write("complete sequences:\n\n");
                    fwl.write("complete sequences:\n\n");
                    this.dis = this.dis + "complete sequences:\n\n";
                }
                while (cp.hasNext()) {
                    String c = (String)cp.next();
                    System.out.println(c);
                    fw.write(c + "\n");
                    fwl.write(c + "\n");
                    this.dis = this.dis + c + "\n";
                }
                fw.write("\nassumed length of primer read: " + this.len + "\n");
                fw.write("maximum distance to gap allowed, if read cannot close whole gap: " + this.maxdis + "\n");
                fw.write("gaps of < " + this.ignore + "bp were ignored\n\n");
                fwl.write("\nassumed length of primer read: " + this.len + "\n");
                fwl.write("maximum distance to gap allowed, if read cannot close whole gap: " + this.maxdis + "\n");
                fwl.write("gaps of < " + this.ignore + "bp were ignored\n");
                fwl.write("\n" + this.primers.size() + " primers taken into account:\n");
                fw.write("\n" + this.primers.size() + " primers taken into account:\n");
                this.dis = this.dis + "\n\n" + this.primers.size() + " primers taken into account:\n\n";
                ListIterator iPs = this.primers.listIterator();
                while (iPs.hasNext()) {
                    primer p = (primer)iPs.next();
                    fwl.write(p.name + ", head @ pos. " + p.headposition + "\n");
                    fw.write(p.name + ", head @ pos. " + p.headposition + "\n");
                    this.dis = this.dis + p.name + "\t" + p.pureSequence + "\t" + " head @ pos. " + p.headposition + "\n";
                }
                fw.flush();
                fw.close();
                fwl.flush();
                fwl.close();
                this.msg = "searching Fonts...";
                this.setLabels();
                this.textArea1.setText(this.dis);
                this.msg = "analysis results written to: " + f.getAbsolutePath() + " and ..._list.txt";
                this.setLabels();
            }
            catch (IOException e) {
                this.msg = "could not create output files";
                this.setLabels();
            }
        }
    }

    private void Design2ActionPerformed(ActionEvent evt) {
        this.evaluateDesign();
    }

    private void PrimersActionPerformed(ActionEvent evt) {
    }

    private void FileActionPerformed(ActionEvent evt) {
    }

    private void loadNexusActionPerformed(ActionEvent evt) {
        this.msg = "loading...";
        this.setLabels();
        FileDialog fd = new FileDialog((Frame)this, "Import NEXUS file...");
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.curFile = fd.getFile();
            this.filename = fd.getDirectory() + fd.getFile();
            this.displayTextfile(this.filename);
        }
        try {
            nexim nex = this.readPrimers.getState() ? new nexim(this.filename, this.sequences, this.primers, this.charsets, this.taxsets, true) : new nexim(this.filename, this.sequences, this.primers, this.charsets, this.taxsets, false);
            this.msg = "loaded " + this.filename;
            this.nrOfTaxa = this.sequences.size();
            Iterator i = this.sequences.iterator();
            if (i.hasNext()) {
                sequence s = (sequence)i.next();
                this.nrOfChar = s.sequence.length();
            }
            this.nrOfCharsets = this.charsets.size();
            this.setLabels();
        }
        catch (IOException e) {
            this.msg = this.filename = this.filename + " not found";
            this.setLabels();
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void writeNexToBinary(dataset d, FileWriter fw) throws IOException {
        Iterator it = d.sequences.iterator();
        sequence se = (sequence)it.next();
        int charNr = se.binarySeq.length();
        int orCharNr = se.sequence.length();
        fw.write("#NEXUS\n");
        fw.write("[!" + d.name + "]\n");
        fw.write("[!matrix with " + charNr + " binary characters recoded from an original " + orCharNr + " characters]\n");
        Date date = new Date();
        fw.write("[!compiled on " + date + " with SeqState version " + this.version + " build " + date + "]\n\n");
        fw.write("BEGIN CHARACTERS;\n");
        fw.write("DIMENSIONS newtaxa ntax=" + d.nrOfTaxa + " NCHAR=" + charNr + ";\n\n");
        fw.write("FORMAT \n");
        fw.write("\tDATATYPE = standard \n");
        fw.write("\tGAP = - \n");
        fw.write("\tMISSING = ? \n");
        fw.write("\tSYMBOLS=\"0123456789A#C$EFG.IJ&L%>OPQ/'TU:*X<Z\" \n");
        fw.write("\tEQUATE=\"R={AG} Y={CT} M={AC} K={GT} S={CG} W={AT} H={ACT} B={CGT} V={ACG} D={AGT} N={ACGT} r={AG} y={CT} m={AC} k={GT} s={CG} w={AT} h={ACT} b={CGT} v={ACG} d={AGT} n={ACGT}\"\n");
        fw.write(";\n");
        fw.write("\nMATRIX\n\n");
        Iterator i = d.sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            fw.write(s.nameAligned + " " + s.binarySeq + "\n");
        }
        fw.write(";\n\n");
        fw.write("END;\n\n");
    }

    public void testOutBinary(dataset d) {
        Iterator i = d.sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            System.out.print(s.nameAligned + " " + s.binarySeq + "\n");
        }
        System.out.print("\n\n");
    }

    void setLabels() {
        this.msgLabel.setText(this.msg);
        this.charsLabel.setText("" + this.nrOfChar + "  characters");
        this.taxaLabel.setText("" + this.nrOfTaxa + "  taxa");
        this.charsetsLabel.setText("" + this.nrOfCharsets + "  charsets");
        this.primersLabel.setText("" + this.primers.size() + "  primers");
    }

    public static void main(String[] args) throws IOException {
        System.out.print("Welcome to SeqState \n");
        File f = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "tmp.nex");
        System.out.println(f.getAbsolutePath());
        try {
            PDExchange1 ex = new PDExchange1(args);
            ex.writeFile(f, "NEXUS", true);
            new SeqState(f.getAbsolutePath());
            System.out.println("\ngetting nexus data from " + f.getAbsolutePath());
        }
        catch (PDExchange1.Error e1) {
            System.err.println("Exception: " + e1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            if (args.length <= 1) {
                new SeqState(null);
            }
            if (args.length != 3) {
                return;
            }
            new SeqState(args[0], args[1], args[2]);
        }
    }

    static boolean equalsDegenerate(String b, String a) {
        if (a.equalsIgnoreCase(b)) {
            return true;
        }
        if (a.equalsIgnoreCase("r")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("g")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("y")) {
            if (b.equalsIgnoreCase("c") || b.equalsIgnoreCase("t")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("m")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("c")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("k")) {
            if (b.equalsIgnoreCase("g") || b.equalsIgnoreCase("t")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("s")) {
            if (b.equalsIgnoreCase("c") || b.equalsIgnoreCase("g")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("w")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("t")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("h")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("c") || b.equalsIgnoreCase("t")) {
                return true;
            }
            if (b.equalsIgnoreCase("m") || b.equalsIgnoreCase("w") || b.equalsIgnoreCase("y")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("b")) {
            if (b.equalsIgnoreCase("c") || b.equalsIgnoreCase("g") || b.equalsIgnoreCase("t")) {
                return true;
            }
            if (b.equalsIgnoreCase("s") || b.equalsIgnoreCase("y") || b.equalsIgnoreCase("k")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("v")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("c") || b.equalsIgnoreCase("g")) {
                return true;
            }
            if (b.equalsIgnoreCase("m") || b.equalsIgnoreCase("r") || b.equalsIgnoreCase("s")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("d")) {
            if (b.equalsIgnoreCase("a") || b.equalsIgnoreCase("g") || b.equalsIgnoreCase("t")) {
                return true;
            }
            if (b.equalsIgnoreCase("r") || b.equalsIgnoreCase("w") || b.equalsIgnoreCase("k")) {
                return true;
            }
        } else if (a.equalsIgnoreCase("n")) {
            return true;
        }
        return false;
    }

    class CalculateThread
    extends Thread {
        CalculateThread() {
        }

        public void run() {
            SeqState.this.msg = "writing primers to file...";
            SeqState.this.setLabels();
            try {
                File f = new File(SeqState.this.filename + "_stat.txt");
                SeqState.this.msg = "writing statistics to: " + f.getAbsolutePath();
                SeqState.this.setLabels();
                FileWriter fw = new FileWriter(f);
                SeqState.this.dis = "";
                fw.write("SeqState statistics for " + SeqState.this.filename + " \n\n");
                SeqState.this.dis = SeqState.this.dis + " \n\n";
                String title = "charset\t#chars\tlength range\tmean\tS.D.\t%divergence\tS.E.\t(range)\tti/tv\tS.E.\t(range)\t%variable\t%informative\t%GC\t%A\t%C\t%G\t%T\n\n";
                fw.write(title);
                SeqState.this.dis = SeqState.this.dis + title;
                ListIterator csI = SeqState.this.charsets.listIterator();
                int nrOfCharset = 0;
                if (SeqState.this.whole) {
                    ArrayList<String> parts = new ArrayList<String>();
                    Iterator it = SeqState.this.sequences.iterator();
                    sequence se = (sequence)it.next();
                    parts.add("1-" + se.sequence.length());
                    charset cs = new charset("dataset", parts);
                    cs.stat(SeqState.this.sequences, "whole data set", SeqState.this.nrep, SeqState.this.bootOnOff.getState());
                    cs.var();
                    String values = cs.name + "\t" + cs.alignedLength + "\t" + cs.minLength + "-" + cs.maxLength + "\t" + SeqState.this.df.format(cs.meanLength) + "\t" + SeqState.this.df.format(cs.SDmeanLength) + "\t" + SeqState.this.df.format(cs.pscore * 100.0) + "\t" + SeqState.this.df.format(cs.pse * 100.0) + " \t(" + SeqState.this.df.format(cs.pmin * 100.0) + "-" + SeqState.this.df.format(cs.pmax * 100.0) + ")\t" + SeqState.this.df.format(cs.titv) + "\t" + SeqState.this.df.format(cs.tse) + " \t(" + SeqState.this.df.format(cs.tmin) + "-" + SeqState.this.df.format(cs.tmax) + ")\t" + SeqState.this.df.format(cs.varsites) + "\t" + SeqState.this.df.format(cs.infsites) + "\t" + SeqState.this.df.format(cs.GC) + "\t" + SeqState.this.df.format(cs.A) + "\t" + SeqState.this.df.format(cs.C) + "\t" + SeqState.this.df.format(cs.G) + "\t" + SeqState.this.df.format(cs.T) + "\n";
                    fw.write(values);
                    SeqState.this.dis = SeqState.this.dis + values;
                    SeqState.this.whole = false;
                } else {
                    while (csI.hasNext()) {
                        charset cs = (charset)csI.next();
                        SeqState.this.pm.setNote("character set \"" + cs.name + "\"");
                        cs.stat(SeqState.this.sequences, cs.name, SeqState.this.nrep, SeqState.this.bootOnOff.getState());
                        cs.var();
                        String values = cs.name + "\t" + cs.alignedLength + "\t" + cs.minLength + "-" + cs.maxLength + "\t" + SeqState.this.df.format(cs.meanLength) + "\t" + SeqState.this.df.format(cs.SDmeanLength) + "\t" + SeqState.this.df.format(cs.pscore * 100.0) + "\t" + SeqState.this.df.format(cs.pse * 100.0) + " \t(" + SeqState.this.df.format(cs.pmin * 100.0) + "-" + SeqState.this.df.format(cs.pmax * 100.0) + ")\t" + SeqState.this.df.format(cs.titv) + "\t" + SeqState.this.df.format(cs.tse) + " \t(" + SeqState.this.df.format(cs.tmin) + "-" + SeqState.this.df.format(cs.tmax) + ")\t" + SeqState.this.df.format(cs.varsites) + "\t" + SeqState.this.df.format(cs.infsites) + "\t" + SeqState.this.df.format(cs.GC) + "\t" + SeqState.this.df.format(cs.A) + "\t" + SeqState.this.df.format(cs.C) + "\t" + SeqState.this.df.format(cs.G) + "\t" + SeqState.this.df.format(cs.T) + "\n";
                        fw.write(values);
                        SeqState.this.dis = SeqState.this.dis + values;
                        SeqState.this.pm.setProgress(++nrOfCharset);
                    }
                }
                if (SeqState.this.bootOnOff.getState()) {
                    fw.write("\n\nstandard errors calculated based on " + SeqState.this.nrep + " bootstrap replicates.\n\n");
                } else {
                    fw.write("\n\nNo standard errors were calculated.\n\n");
                }
                fw.write("Lengths and GC content for individual taxa:\n\n");
                SeqState.this.dis = SeqState.this.dis + "\n\nLengths for individual taxa:\n\n";
                Iterator ii = SeqState.this.charsets.iterator();
                fw.write("taxon\t");
                SeqState.this.dis = SeqState.this.dis + "taxon\t";
                while (ii.hasNext()) {
                    charset c = (charset)ii.next();
                    fw.write(c.name + "\t");
                    SeqState.this.dis = SeqState.this.dis + c.name + "\t";
                }
                fw.write("\n");
                SeqState.this.dis = SeqState.this.dis + "\n";
                ListIterator ei = SeqState.this.sequences.listIterator();
                while (ei.hasNext()) {
                    ArrayList<sequence> singleSeq = new ArrayList<sequence>();
                    sequence s = (sequence)ei.next();
                    singleSeq.add(s);
                    ListIterator charIt = SeqState.this.charsets.listIterator();
                    fw.write(s.name + "\t");
                    SeqState.this.dis = SeqState.this.dis + s.name + "\t";
                    while (charIt.hasNext()) {
                        charset charS = (charset)charIt.next();
                        charS.stat(singleSeq, charS.name, SeqState.this.nrep, SeqState.this.bootOnOff.getState());
                        fw.write(charS.meanLength + "\t");
                        SeqState.this.dis = SeqState.this.dis + charS.meanLength + "\t";
                    }
                    fw.write("\n");
                    SeqState.this.dis = SeqState.this.dis + "\n";
                }
                fw.write("\n\n");
                fw.write("GC content for individual taxa:\n\n");
                SeqState.this.dis = SeqState.this.dis + "GC content for individual taxa:\n\n";
                fw.write("taxon\t");
                SeqState.this.dis = SeqState.this.dis + "taxon\t";
                Iterator ii2 = SeqState.this.charsets.iterator();
                while (ii2.hasNext()) {
                    charset c = (charset)ii2.next();
                    fw.write(c.name + "\t");
                    SeqState.this.dis = SeqState.this.dis + c.name + "\t";
                }
                ListIterator ei2 = SeqState.this.sequences.listIterator();
                while (ei2.hasNext()) {
                    ArrayList<sequence> singleSeq = new ArrayList<sequence>();
                    sequence s = (sequence)ei2.next();
                    singleSeq.add(s);
                    ListIterator charIt = SeqState.this.charsets.listIterator();
                    fw.write(s.name + "\t");
                    SeqState.this.dis = SeqState.this.dis + s.name + "\t";
                    while (charIt.hasNext()) {
                        charset charS = (charset)charIt.next();
                        charS.stat(singleSeq, charS.name, SeqState.this.nrep, SeqState.this.bootOnOff.getState());
                        fw.write(SeqState.this.df.format(charS.GC) + "\t");
                        SeqState.this.dis = SeqState.this.dis + SeqState.this.df.format(charS.GC) + "\t";
                    }
                    fw.write("\n");
                    SeqState.this.dis = SeqState.this.dis + "\n";
                }
                fw.flush();
                fw.close();
                SeqState.this.textArea1.setText(SeqState.this.dis);
                SeqState.this.msg = "statistics written to: " + f.getAbsolutePath();
                SeqState.this.setLabels();
            }
            catch (IOException e) {
                SeqState.this.msg = "output File could not be created";
                SeqState.this.setLabels();
                return;
            }
        }
    }

    class AlignThread
    extends Thread {
        ArrayList newprimers;

        AlignThread(ArrayList newPrimers) {
            this.newprimers = newPrimers;
        }

        public void run() {
            Iterator i = this.newprimers.iterator();
            boolean found = false;
            int nrOfPrimers = 0;
            int nrOfHits = 0;
            while (i.hasNext()) {
                primer p = (primer)i.next();
                SeqState.this.pm.setNote(p.name + "...");
                found = SeqState.this.getHeadPos(p);
                if (found) {
                    p.external = false;
                    ++nrOfHits;
                }
                SeqState.this.pm.setProgress(++nrOfPrimers);
            }
            SeqState.this.msg = "Alignment position found for " + nrOfHits++ + " out of " + this.newprimers.size() + " primers. Others set to \"external\".";
            SeqState.this.setLabels();
        }
    }

    class CodeAllThread
    extends Thread {
        CodeAllThread() {
        }

        public void run() {
            try {
                this.runAllThroughCoding();
            }
            catch (Exception e) {
                System.out.print("error");
            }
        }

        public void runAllThroughCoding() throws IOException {
            SeqState.this.filename = SeqState.this.ROSEfilename;
            SeqState.this.filename = SeqState.this.removeFileExtension(SeqState.this.filename);
            String emsg = "error during ";
            String s = " performed on " + SeqState.this.ROSEruns + " data sets in " + SeqState.this.filename;
            try {
                int progress = 0;
                SeqState.this.pm.setNote(SeqState.this.simple.getLabel());
                File f3 = new File(SeqState.this.filename + "_all_sic.nex");
                FileWriter fw3 = new FileWriter(f3);
                Iterator it3 = SeqState.this.datasets.iterator();
                while (it3.hasNext()) {
                    dataset d = (dataset)it3.next();
                    fw3.write("\n\n[!" + d.name + ":]\n\n");
                    SeqState.this.sequences = d.sequences;
                    SeqState.this.simple();
                    File sf3 = new File(SeqState.this.filename + "_sic.nex");
                    SeqState.this.readFileAndAppend(fw3, sf3);
                    sf3.delete();
                    SeqState.this.pm.setProgress(++progress);
                }
                fw3.write("\n\nQUIT;\n");
                fw3.close();
                SeqState.this.msg = SeqState.this.simple.getLabel() + s;
                SeqState.this.setLabels();
                System.out.print(SeqState.this.msg + "\n");
                SeqState.this.pm.setNote(SeqState.this.miss.getLabel());
                File f5 = new File(SeqState.this.filename + "_all_miss.nex");
                FileWriter fw5 = new FileWriter(f5);
                Iterator it5 = SeqState.this.datasets.iterator();
                while (it5.hasNext()) {
                    dataset d = (dataset)it5.next();
                    fw5.write("\n\n[!" + d.name + ":]\n\n");
                    SeqState.this.sequences = d.sequences;
                    SeqState.this.miss();
                    File sf5 = new File(SeqState.this.filename + "_miss.nex");
                    SeqState.this.readFileAndAppend(fw5, sf5);
                    sf5.delete();
                    SeqState.this.pm.setProgress(++progress);
                }
                fw5.write("\n\nQUIT;\n");
                fw5.close();
                SeqState.this.msg = SeqState.this.miss.getLabel() + s;
                SeqState.this.setLabels();
                System.out.print(SeqState.this.msg + "\n");
            }
            catch (Exception e) {
                SeqState.this.msg = "coding of ROSE matrices failed; " + emsg;
                SeqState.this.setLabels();
                System.out.print(SeqState.this.msg);
            }
        }
    }

    class BinaryThread
    extends Thread {
        BinaryThread() {
        }

        public void run() {
            try {
                this.binary();
                SeqState.this.pm.setNote("writing to file...");
                try {
                    String str = "_bin.nex";
                    File f = new File(SeqState.this.ROSEfilename + str);
                    FileWriter fw = new FileWriter(f);
                    fw.write(SeqState.this.PaupIniBlock + "\n\n");
                    Iterator i = SeqState.this.datasets.iterator();
                    while (i.hasNext()) {
                        dataset d = (dataset)i.next();
                        SeqState.this.writeNexToBinary(d, fw);
                        fw.write(SeqState.this.PaupBlock + "\n\n");
                    }
                    fw.write(SeqState.this.endBlock);
                    SeqState.this.msg = "Done." + SeqState.this.datasets.size() + " matrices translated to binary; saved under " + SeqState.this.ROSEfilename + str + "\n";
                    SeqState.this.setLabels();
                    fw.close();
                    SeqState.this.displayTextfile(SeqState.this.ROSEfilename + str);
                    SeqState.this.pm.setProgress(SeqState.this.datasets.size());
                }
                catch (Exception e) {
                    SeqState.this.msg = "problem with binary output";
                    SeqState.this.setLabels();
                    System.out.print("problem with binary output");
                }
            }
            catch (Exception e) {
                String s;
                SeqState.this.msg = s = "problem with BinaryThread";
                SeqState.this.setLabels();
                System.out.print("error");
            }
        }

        public void binary() {
            Iterator ite = SeqState.this.datasets.iterator();
            int progr = 0;
            while (ite.hasNext()) {
                dataset d = (dataset)ite.next();
                SeqState.this.pm.setProgress(progr++);
                SeqState.this.pm.setNote(d.name);
                for (int i = 0; i < d.nrOfChars; ++i) {
                    Iterator it = d.sequences.iterator();
                    String orStates = "";
                    int nrOfStates = 0;
                    boolean b = false;
                    while (it.hasNext()) {
                        sequence s = (sequence)it.next();
                        char a = s.sequence.charAt(i);
                        if (this.stateAlreadyThere(orStates, a)) continue;
                        orStates = orStates + a;
                        ++nrOfStates;
                    }
                    for (int v = 0; v < nrOfStates; ++v) {
                        char z = orStates.charAt(v);
                        Iterator it2 = d.sequences.iterator();
                        while (it2.hasNext()) {
                            sequence s = (sequence)it2.next();
                            if (z == s.sequence.charAt(i)) {
                                s.binarySeq = s.binarySeq + "1";
                                continue;
                            }
                            s.binarySeq = s.binarySeq + "0";
                        }
                    }
                }
            }
        }

        public boolean stateAlreadyThere(String orStates, char a) {
            for (int c = 0; c < orStates.length(); ++c) {
                if (orStates.charAt(c) != a) continue;
                return true;
            }
            return false;
        }
    }
}

