/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Timer;

public class PDExchange1 {
    private static final int version = 67;
    private boolean success = false;
    Timer timeoutchecker;

    public PDExchange1(String[] arg) throws Error, Standalone {
        boolean standalone = true;
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].startsWith("--calledbyphyde")) continue;
            standalone = false;
            break;
        }
        if (standalone) {
            throw new Standalone();
        }
        this.success = false;
        this.timeoutchecker = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PDExchange1.this.success) {
                    System.err.println("\n\nError: Timed out. No connection with PhyDE.");
                    System.exit(-234);
                }
            }
        });
        this.timeoutchecker.setRepeats(false);
        this.timeoutchecker.start();
        if (this.getVersion() < 67) {
            throw new Error("Outdated version of PhyDE");
        }
        this.success = true;
        this.startCommand("_Hi!");
        this.stop();
    }

    public int get(int row, int col) throws Error {
        this.startCommand("getB");
        this.submitInteger(row);
        this.submitInteger(col);
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            this.stopRead();
            return n;
        }
        catch (IOException ex) {
            throw new Error("Failed to read byte");
        }
    }

    public int getNumberOfSequences() throws Error {
        this.startCommand("nseq");
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            this.stopRead();
            return n;
        }
        catch (IOException ex) {
            throw new Error("Failed to read number of sequences");
        }
    }

    public int getNumberOfColumns() throws Error {
        this.startCommand("ncls");
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            this.stopRead();
            return n;
        }
        catch (IOException ex) {
            throw new Error("Failed to read number of columns");
        }
    }

    public byte[] readData(int row, int col, int num) throws Error {
        this.startCommand("read");
        this.submitInteger(row);
        this.submitInteger(col);
        this.submitInteger(num);
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            byte[] b = this.readBytes(n);
            this.stopRead();
            return b;
        }
        catch (IOException ex) {
            throw new Error("Failed to read number of entry titles");
        }
    }

    public Rectangle getSelectedArea() throws Error {
        this.startCommand("selb");
        this.stop();
        try {
            this.startRead();
            Rectangle r = new Rectangle();
            r.x = this.readInteger();
            r.y = this.readInteger();
            r.width = this.readInteger();
            r.height = this.readInteger();
            this.stopRead();
            if (r.x < 0 && r.y < 0 && r.width < 0 && r.height < 0) {
                return null;
            }
            return r;
        }
        catch (IOException ex) {
            throw new Error("Failed to obtain selected area");
        }
    }

    public int getNumberOfEntryTitles() throws Error {
        this.startCommand("nmET");
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            this.stopRead();
            return n;
        }
        catch (IOException ex) {
            throw new Error("Failed to read number of entry titles");
        }
    }

    public String getEntryTitle(int i) throws Error {
        this.startCommand("gtET");
        this.submitInteger(i);
        this.stop();
        try {
            this.startRead();
            String s = this.readString();
            this.stopRead();
            return s;
        }
        catch (IOException ex) {
            throw new Error("Failed to read entry title #" + i);
        }
    }

    public String getSeqEntryWithTitle(int i, String s) throws Error {
        this.startCommand("eVal");
        this.submitInteger(i);
        this.submitString(s);
        this.stop();
        try {
            this.startRead();
            String erg = this.readString();
            this.stopRead();
            return erg;
        }
        catch (IOException ex) {
            throw new Error("Failed to read entry field " + s + " in sequence " + i);
        }
    }

    public String createNewWindow(String title) throws Error {
        this.startCommand("newW");
        this.submitString(title);
        this.stop();
        try {
            this.startRead();
            String winID = this.readString();
            this.stopRead();
            return winID;
        }
        catch (IOException ex) {
            throw new Error("Failed to read window identifier");
        }
    }

    public String openFile(File fp) throws Error {
        this.startCommand("opfl");
        this.submitString(fp.getPath());
        this.stop();
        try {
            this.startRead();
            String winID = this.readString();
            this.stopRead();
            return winID;
        }
        catch (IOException ex) {
            throw new Error("Failed to read window identifier");
        }
    }

    public void writeFile(File fp, String format, boolean sel) throws Error {
        this.startCommand("wrfl");
        this.submitString(fp.getPath());
        this.submitString(format);
        this.submitInteger(sel ? 1 : 0);
        this.stop();
    }

    public void addSequence(String windIdent, String title, String data) {
        this.startCommand("apSq");
        this.submitString(windIdent);
        this.submitString(title);
        this.submitString(data);
        this.stop();
    }

    public int getVersion() throws Error {
        this.startCommand("vers");
        this.stop();
        try {
            this.startRead();
            int n = this.readInteger();
            this.stopRead();
            return n;
        }
        catch (IOException ex) {
            throw new Error("Failed to read integer");
        }
    }

    private void startCommand(String s) {
        System.out.print("@&$" + s);
    }

    private void submitString(String s) {
        this.submitInteger(s.length());
        System.out.print(s);
    }

    private void submitInteger(int k) {
        System.out.print(k + "/");
    }

    private void stop() {
        System.out.print("$&@");
        System.out.flush();
    }

    private void startRead() throws IOException {
        byte[] ch = new byte[]{64, 38, 36};
        byte[] buf = new byte[3];
        System.in.read(buf);
        while (buf[0] != ch[0] || buf[1] != ch[1] || buf[2] != ch[2]) {
            buf[0] = buf[1];
            buf[1] = buf[2];
            buf[2] = (byte)System.in.read();
        }
        return;
    }

    private void stopRead() throws IOException {
        byte[] ch = new byte[3];
        System.in.read(ch);
        if (ch[0] != 36 || ch[1] != 38 || ch[2] != 64) {
            throw new IOException();
        }
    }

    private int readInteger() throws IOException {
        int num = 0;
        int c = System.in.read();
        boolean neg = false;
        if (c == 45) {
            neg = true;
        } else {
            num = c - 48;
        }
        while ((c = System.in.read()) != 47) {
            num = 10 * num + (c - 48);
        }
        if (neg) {
            num = -num;
        }
        return num;
    }

    private String readString() throws IOException {
        int n = this.readInteger();
        byte[] ch = new byte[n];
        System.in.read(ch);
        return new String(ch);
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] ch = new byte[n];
        System.in.read(ch);
        return ch;
    }

    public class Standalone
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public class Error
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String s0;

        Error() {
            this.s0 = "Error";
        }

        Error(String s) {
            this.s0 = s;
        }

        public String toString() {
            return this.s0;
        }
    }
}

