/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class InversionScreener {
    Vector allMatchingRegions = new Vector();
    Vector sequencesV = new Vector();
    String version = "0.2";
    String date = "16.04.07";
    String filename = "";
    int loopsize;
    int lowerMotifBoundary;
    int upperMotifBoundary;
    int costMatrixSize = 15;
    double maxMismatchScore;
    ArrayList sequences;
    double[][] costs = new double[this.costMatrixSize][this.costMatrixSize];

    public InversionScreener(ArrayList sequences, int loopsize, double maxMismatchScore, int lowerMotifBoundary, int upperMotifBoundary, String filename) {
        if (sequences.size() == 0) {
            System.out.print("No data loaded\n");
        }
        this.filename = filename + "_inv.txt";
        this.loopsize = loopsize;
        this.maxMismatchScore = maxMismatchScore;
        this.lowerMotifBoundary = lowerMotifBoundary;
        this.upperMotifBoundary = upperMotifBoundary;
        this.sequencesV.addAll(sequences);
        this.initializeMatrix(this.costs, this.costMatrixSize);
        this.loadCostMatrix();
        Iterator i = sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            s.sequence = this.removeGaps(s.sequence);
            s.sequence = s.sequence.toUpperCase();
            this.checkSingleSequence(s.sequence);
        }
        this.output(this.allMatchingRegions);
    }

    public void output(Vector allMatchingRegions) {
        try {
            File invFile = new File(this.filename);
            FileWriter fw = new FileWriter(invFile);
            fw.write("InversionScreener version " + this.version + " build " + this.date + "\n\n");
            String str = "assumptions: maxloopsize: " + this.loopsize + " maxMismatchScore:" + this.maxMismatchScore + " lowerMotifBoundary:" + this.lowerMotifBoundary + " upperMotifBoundary: " + this.upperMotifBoundary + "\n";
            String f = "Taxon\tNo.\tinversion\tloop\tnoisrevni\tinversion\tloop\tnoisrevni\tsize inversion\tsize loop\n\n";
            fw.write(str + f);
            System.out.print(str + f);
            for (int x = 0; x < allMatchingRegions.size(); ++x) {
                Vector mrv = (Vector)allMatchingRegions.elementAt(x);
                sequence s = (sequence)this.sequencesV.elementAt(x);
                this.outputMatchingRegions(mrv, s.name, s.sequence, fw);
            }
            fw.flush();
            fw.close();
            System.out.print("\nDone.\n");
        }
        catch (IOException e) {
            System.out.print("file problem");
        }
    }

    public void testoutput(ArrayList sequences) {
        System.out.print("\nTest Out InversionScreener " + this.version + " " + this.date + ":\n\n");
        Iterator i = sequences.iterator();
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            System.out.print(s.name + "\n");
        }
    }

    public void testoutput(String seq) {
        System.out.print(seq + " " + seq.length() + "\n");
    }

    String removeGaps(String seq) {
        String seq2 = "";
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == '-') continue;
            seq2 = seq2 + seq.charAt(i);
        }
        return seq2;
    }

    void checkSingleSequence(String seq) {
        Vector matchingRegions = new Vector();
        for (int i = this.lowerMotifBoundary; i < seq.length() - this.lowerMotifBoundary; ++i) {
            if (seq.length() <= 2 * this.lowerMotifBoundary + this.loopsize + 1) {
                System.out.print("sequence too short\n");
                return;
            }
            for (int a = 0; a <= this.loopsize; ++a) {
                this.checkNuPairs(i, seq, a, matchingRegions);
            }
        }
        this.filterRegions(matchingRegions);
        this.allMatchingRegions.add(matchingRegions);
    }

    void checkNuPairs(int i, String seq, int loopext, Vector matchingRegions) {
        int ctr = 0;
        double SumcurScore = 0.0;
        double curScore = 0.0;
        int k = i;
        MatchingRegion mr = new MatchingRegion(i, i, i + loopext + 1, i + loopext + 1);
        for (int j = k + loopext + 1; !(ctr > this.upperMotifBoundary || ctr >= this.lowerMotifBoundary && curScore > this.maxMismatchScore || k < 0 || j >= seq.length()); --k, ++j) {
            char a = seq.charAt(k);
            char b = seq.charAt(j);
            if (a == '?' || b == '?') break;
            curScore = (SumcurScore += this.returnScore(a, b)) / (double)(++ctr);
            if (ctr < this.lowerMotifBoundary || !(curScore <= this.maxMismatchScore)) continue;
            mr.expand(k, j);
            mr.valid = true;
            if (!(this.returnScore(a, b) > 0.5)) continue;
            mr.expand(k + 1, j - 1);
        }
        if (mr.valid) {
            matchingRegions.add(mr);
        }
    }

    double returnScore(char motifChar, char matchingChar) {
        int a = this.getIndex(motifChar);
        int b = this.getIndex(matchingChar);
        if (a == -1 || b == -1) {
            System.out.print("invalid char\n");
            return Double.MAX_VALUE;
        }
        if (a >= b) {
            return this.costs[b][a];
        }
        return this.costs[a][b];
    }

    void initializeMatrix(double[][] costs, int costMatrixSize) {
        for (int i = 0; i < costMatrixSize; ++i) {
            for (int j = 0; j < costMatrixSize; ++j) {
                costs[i][j] = -1.0;
            }
        }
    }

    void outputCostMatrix() {
        System.out.print("cost matrix:\n");
        System.out.print("A\tC\tG\tT\tY\tM\tK\tS\tR\tW\tH\tB\tV\tD\tN\n\n");
        for (int i = 0; i < this.costMatrixSize; ++i) {
            for (int j = 0; j < this.costMatrixSize; ++j) {
                if (j < i) {
                    System.out.print(".");
                } else {
                    System.out.print(this.costs[i][j]);
                }
                System.out.print("\t");
            }
            System.out.print("\n");
        }
    }

    int getIndex(char c) {
        int i = -1;
        switch (c) {
            case 'A': {
                i = 0;
                break;
            }
            case 'C': {
                i = 1;
                break;
            }
            case 'G': {
                i = 2;
                break;
            }
            case 'T': {
                i = 3;
                break;
            }
            case 'Y': {
                i = 4;
                break;
            }
            case 'M': {
                i = 5;
                break;
            }
            case 'K': {
                i = 6;
                break;
            }
            case 'S': {
                i = 7;
                break;
            }
            case 'R': {
                i = 8;
                break;
            }
            case 'W': {
                i = 9;
                break;
            }
            case 'H': {
                i = 10;
                break;
            }
            case 'B': {
                i = 11;
                break;
            }
            case 'V': {
                i = 12;
                break;
            }
            case 'D': {
                i = 13;
                break;
            }
            case 'N': {
                i = 14;
            }
        }
        return i;
    }

    void loadCostMatrix() {
        String costMatrixFile = "dist/COSTS.txt";
        File f = new File(costMatrixFile);
        System.out.print(f.getAbsolutePath());
        try {
            int a;
            FileReader fr = new FileReader(f);
            StreamTokenizer tok = new StreamTokenizer(fr);
            tok.resetSyntax();
            tok.wordChars(33, 255);
            tok.whitespaceChars(0, 32);
            tok.eolIsSignificant(false);
            tok.parseNumbers();
            System.out.println("\n302\n");
            for (a = 0; a < this.costMatrixSize + 1; ++a) {
                tok.nextToken();
                if (tok.ttype != -1) continue;
                return;
            }
            System.out.println("\n310\n");
            for (a = 0; a < this.costMatrixSize; ++a) {
                tok.nextToken();
                if (tok.ttype == -1) {
                    return;
                }
                for (int b = 0; b < this.costMatrixSize; ++b) {
                    tok.nextToken();
                    if (tok.ttype == -1) {
                        return;
                    }
                    if (b < a) continue;
                    this.costs[a][b] = tok.nval;
                }
            }
            System.out.println("\n325\n");
        }
        catch (IOException e) {
            System.out.print("no costMatrixFile \"COSTS.txt\" found in same directory as .jar!\n");
        }
    }

    void outputMatchingRegions(Vector matchingRegions, String name, String seq, FileWriter fw) throws IOException {
        int ctr = 0;
        for (int a = 0; a < matchingRegions.size(); ++a) {
            MatchingRegion mr = (MatchingRegion)matchingRegions.elementAt(a);
            if (mr.subset) continue;
            System.out.print(name + "\t");
            System.out.print("" + ++ctr + "\t");
            fw.write(name + "\t");
            fw.write("" + ctr + "\t");
            mr.output(seq, fw);
        }
    }

    void filterRegions(Vector matchingRegions) {
        for (int a = 0; a < matchingRegions.size(); ++a) {
            MatchingRegion mr1 = (MatchingRegion)matchingRegions.elementAt(a);
            for (int b = a + 1; b < matchingRegions.size(); ++b) {
                if (a == b) continue;
                MatchingRegion mr2 = (MatchingRegion)matchingRegions.elementAt(b);
                if (this.subset(mr1.FivePartBegin, mr2.FivePartBegin, mr1.FivePartEnd, mr2.FivePartEnd)) {
                    mr1.subset = true;
                }
                if (!this.subset(mr2.FivePartBegin, mr1.FivePartBegin, mr2.FivePartEnd, mr1.FivePartEnd)) continue;
                mr2.subset = true;
            }
        }
    }

    boolean subset(int a1, int a2, int b1, int b2) {
        if (a1 > a2 && b1 <= b2) {
            return true;
        }
        return a1 >= a2 && b1 < b2;
    }

    class MatchingRegion {
        String name;
        int ID;
        int FivePartBegin = 0;
        int FivePartEnd = 0;
        int ThreePartBegin = 0;
        int ThreePartEnd = 0;
        boolean valid = false;
        boolean subset = false;
        String motif = "";
        String matchingMotif = "";
        String loop = "";
        String loopdescr = "";

        MatchingRegion(int a, int b, int c, int d) {
            this.FivePartBegin = a;
            this.FivePartEnd = b;
            this.ThreePartBegin = c;
            this.ThreePartEnd = d;
            this.loopdescr = "" + (this.ThreePartBegin - this.FivePartEnd - 1);
            this.rename();
        }

        void rename() {
            this.name = "" + (this.FivePartBegin + 1) + "-" + (this.FivePartEnd + 1) + "\t" + (this.FivePartEnd + 2) + "-" + this.ThreePartBegin + "\t" + (this.ThreePartBegin + 1) + "-" + (this.ThreePartEnd + 1);
        }

        public void expand(int a, int b) {
            this.FivePartBegin = a;
            this.ThreePartEnd = b;
            this.rename();
        }

        public void output(String seq, FileWriter fw) throws IOException {
            System.out.print(this.name + "\t");
            fw.write(this.name + "\t");
            this.motif = seq.substring(this.FivePartBegin, this.FivePartEnd + 1);
            this.loop = seq.substring(this.FivePartEnd + 1, this.ThreePartBegin);
            if (this.loop.length() == 0) {
                this.loop = "-";
                this.loopdescr = "-";
            }
            this.matchingMotif = seq.substring(this.ThreePartBegin, this.ThreePartEnd + 1);
            String dg = this.motif + "\t" + this.loop + "\t" + this.matchingMotif + "\t" + this.motif.length() + "\t" + this.loopdescr + "\n";
            System.out.print(dg);
            fw.write(dg);
        }
    }
}

