/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;

public class IndelScreening {
    ArrayList indels;
    ArrayList sequences;
    boolean filter = false;
    boolean ignore = true;

    public IndelScreening(ArrayList sequences, ArrayList indels, boolean filter, boolean ignore, boolean includeBorderIndels) {
        this.indels = indels;
        this.sequences = sequences;
        ListIterator seqI = sequences.listIterator();
        while (seqI.hasNext()) {
            int beg = 0;
            int end = 0;
            sequence s = (sequence)seqI.next();
            for (int i = 0; i < s.sequence.length(); ++i) {
                if (s.sequence.charAt(i) != '-') continue;
                if (i > 0 && s.sequence.charAt(i - 1) == '?') {
                    while (s.sequence.charAt(i) == '-' && i < s.sequence.length() - 1) {
                        ++i;
                    }
                    continue;
                }
                beg = i + 1;
                while (i < s.sequence.length() && s.sequence.charAt(i) == '-') {
                    ++i;
                }
                if (ignore && i < s.sequence.length() && s.sequence.charAt(i) == '?') continue;
                end = i;
                if (!includeBorderIndels && (beg == 1 || end == s.sequence.length())) continue;
                Indel ind = new Indel(beg, end, sequences.size());
                if (filter) {
                    int mod = (ind.to - ind.from + 1) % 3;
                    System.out.print(mod + "\n");
                    System.out.print("filter activated\n");
                    if (this.indelAlreadyThere(ind) || mod != 0) continue;
                    indels.add(ind);
                    continue;
                }
                if (this.indelAlreadyThere(ind)) continue;
                indels.add(ind);
            }
        }
        this.sort();
        this.assignTaxaInWhich();
    }

    public boolean indelAlreadyThere(Indel indNeu) {
        Iterator ii = this.indels.iterator();
        while (ii.hasNext()) {
            Indel indAlt = (Indel)ii.next();
            if (indAlt.from != indNeu.from || indAlt.to != indNeu.to) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        Collections.sort(this.indels);
        Iterator i = this.indels.iterator();
        int a = 0;
        while (i.hasNext()) {
            Indel ind = (Indel)i.next();
            ind.nr = ++a;
        }
    }

    public void assignTaxaInWhich() {
        Iterator iit = this.indels.iterator();
        while (iit.hasNext()) {
            Indel in = (Indel)iit.next();
            Iterator sit = this.sequences.iterator();
            int taxNr = 0;
            while (sit.hasNext()) {
                sequence s = (sequence)sit.next();
                in.stateInTaxa[taxNr] = this.subset(in, s.sequence) ? 63 : (this.invalid(in, s.sequence) ? 63 : (this.present(in, s.sequence) ? 49 : 48));
                ++taxNr;
            }
            System.out.print(in.name + ":\n");
            System.out.println(in.stateInTaxa);
        }
    }

    public boolean invalid(Indel in, String s) {
        if (this.someOrAllQ(in, s)) {
            return true;
        }
        if (!this.present(in, s)) {
            return false;
        }
        if (in.from == 1 && in.to == s.length()) {
            return true;
        }
        if (in.from == 1) {
            if (this.present(in, s) && s.charAt(in.to) == '?') {
                return true;
            }
            for (int a = in.from; a <= in.to; ++a) {
                if (s.charAt(a - 1) != '?') continue;
                return true;
            }
            return false;
        }
        if (in.to == s.length()) {
            if (this.present(in, s) && s.charAt(in.from - 2) == '?') {
                return true;
            }
            for (int a = in.from; a <= in.to; ++a) {
                if (s.charAt(a - 1) != '?') continue;
                return true;
            }
            return false;
        }
        if (this.present(in, s) && (s.charAt(in.from - 2) == '?' || s.charAt(in.to) == '?')) {
            return true;
        }
        for (int a = in.from; a <= in.to; ++a) {
            if (s.charAt(a - 1) != '?') continue;
            return true;
        }
        return false;
    }

    public boolean subset(Indel in, String s) {
        if (!this.present(in, s)) {
            return false;
        }
        if (in.from == 1 && in.to == s.length()) {
            return false;
        }
        if (in.from == 1 && s.charAt(in.to) == '-') {
            return true;
        }
        if (in.to == s.length()) {
            if (s.charAt(in.from - 2) == '-') {
                return true;
            }
        } else if (s.charAt(in.from - 2) == '-' || s.charAt(in.to) == '-') {
            if (in.nr == 1) {
                System.out.println("subset function for indel " + in.name + " (" + in.nr + ")");
            }
            return true;
        }
        return false;
    }

    public boolean present(Indel in, String s) {
        for (int a = in.from; a <= in.to; ++a) {
            if (s.charAt(a - 1) == '-') continue;
            return false;
        }
        return true;
    }

    public boolean someOrAllQ(Indel in, String s) {
        for (int a = in.from; a <= in.to; ++a) {
            if (s.charAt(a - 1) != '?') continue;
            return true;
        }
        return false;
    }
}

