/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class IndelChar {
    int nr = 0;
    String name;
    int[][] stepmatrix;
    int[][] stepmatrixCorr;
    Vector indelsComprised;
    int fromMin = Integer.MAX_VALUE;
    int toMax = 0;
    char[] statesOfTaxa;
    String[] baumstatesOfTaxa;
    Vector states;
    Vector sequenceblock;
    int taxAnz = 0;
    boolean unord = true;
    boolean codableInPaup = true;
    boolean consistent = false;
    boolean correctionWasRequired = false;
    boolean simm = false;
    boolean corr = false;
    String polymorphic = "";
    ArrayList sequences;

    public IndelChar(Vector indelsComprised, ArrayList sequences, ArrayList indels, boolean simm, boolean corr) {
        int c;
        int b;
        this.taxAnz = sequences.size();
        this.sequences = sequences;
        this.simm = simm;
        this.indelsComprised = indelsComprised;
        this.corr = corr;
        this.defineDimensions();
        this.name = "ind_pos_" + this.fromMin + "_to_" + this.toMax;
        this.statesOfTaxa = new char[this.taxAnz];
        for (int c2 = 0; c2 < this.taxAnz; ++c2) {
            this.statesOfTaxa[c2] = 48;
        }
        this.defineStates();
        this.stepmatrix = new int[this.states.size()][this.states.size()];
        for (b = 0; b < this.states.size(); ++b) {
            for (c = 0; c < this.states.size(); ++c) {
                this.stepmatrix[b][c] = 0;
            }
        }
        this.findSteps();
        if (corr) {
            this.stepmatrixCorr = new int[this.states.size()][this.states.size()];
            for (b = 0; b < this.states.size(); ++b) {
                for (c = 0; c < this.states.size(); ++c) {
                    this.stepmatrixCorr[b][c] = this.stepmatrix[b][c];
                }
            }
            int corrrounds = 0;
            while (!this.consistent) {
                ++corrrounds;
                this.corrSteps();
            }
            for (int b2 = 0; b2 < this.states.size(); ++b2) {
                for (int c3 = 0; c3 < this.states.size(); ++c3) {
                    if (this.stepmatrixCorr[b2][c3] == this.stepmatrix[b2][c3]) continue;
                    this.correctionWasRequired = true;
                }
            }
        }
        this.statesOfTaxa();
    }

    public void defineStates() {
        this.states = new Vector();
        ArrayList stPs = new ArrayList();
        State s = new State(stPs, 0);
        this.states.add(s);
        int stateNr = 0;
        for (int a = 0; a < this.taxAnz; ++a) {
            ArrayList<Indel> stateParts = new ArrayList<Indel>();
            Iterator ii = this.indelsComprised.iterator();
            while (ii.hasNext()) {
                Indel ind = (Indel)ii.next();
                if (ind.stateInTaxa[a] != '1') continue;
                stateParts.add(ind);
            }
            if (stateParts.isEmpty() || this.stateAlreadyThere(stateParts)) continue;
            State st = new State(stateParts, ++stateNr);
            this.states.add(st);
        }
        if (this.states.size() > 32) {
            this.codableInPaup = false;
        }
    }

    public boolean stateAlreadyThere(ArrayList newStateParts) {
        Collections.sort(newStateParts);
        Iterator si = this.states.iterator();
        boolean isequal = false;
        while (si.hasNext()) {
            State st = (State)si.next();
            Collections.sort(st.parts);
            if (st.parts.size() != newStateParts.size()) continue;
            Iterator pi1 = st.parts.iterator();
            Iterator pi2 = newStateParts.iterator();
            boolean allequal = true;
            while (pi1.hasNext()) {
                Indel i1 = (Indel)pi1.next();
                Indel i2 = (Indel)pi2.next();
                if (i2.nr == i1.nr) continue;
                allequal = false;
            }
            if (!allequal) continue;
            isequal = true;
        }
        return isequal;
    }

    public void statesOfTaxa() {
        for (int c = 0; c < this.taxAnz; ++c) {
            Iterator i = this.states.iterator();
            while (i.hasNext()) {
                boolean present = true;
                boolean invalid = false;
                State s = (State)i.next();
                if (s.stateNr == 0) continue;
                int NoPresInSeq = 0;
                Iterator allIndI = this.indelsComprised.iterator();
                while (allIndI.hasNext()) {
                    Indel in1 = (Indel)allIndI.next();
                    if (in1.stateInTaxa[c] == '1') {
                        ++NoPresInSeq;
                    }
                    Iterator si = s.parts.iterator();
                    while (si.hasNext()) {
                        Indel in2 = (Indel)si.next();
                        if (in2 != in1) continue;
                        if (in2.stateInTaxa[c] != '1') {
                            present = false;
                        }
                        if (in2.stateInTaxa[c] != '?') continue;
                        invalid = true;
                    }
                }
                if (NoPresInSeq > s.parts.size()) {
                    present = false;
                }
                if (!present) continue;
                this.statesOfTaxa[c] = s.stateChar;
                if (!invalid) continue;
                this.statesOfTaxa[c] = 63;
            }
        }
        Iterator seqi = this.sequences.iterator();
        int taxindex = 0;
        while (seqi.hasNext()) {
            sequence s = (sequence)seqi.next();
            String sbstr = s.sequence.substring(this.fromMin - 1, this.toMax);
            if (sbstr.contains("?")) {
                this.statesOfTaxa[taxindex] = 63;
            }
            char leftExt = ' ';
            char rightExt = ' ';
            if (this.fromMin - 2 >= 0) {
                leftExt = s.sequence.charAt(this.fromMin - 2);
            }
            if (this.toMax + 1 <= s.sequence.length()) {
                rightExt = s.sequence.charAt(this.toMax);
            }
            if (s.name.equalsIgnoreCase("taxon1")) {
                System.out.println("leftExt: " + leftExt + "\nright: " + rightExt + "\n");
            }
            if (!(this.leftMarginIsNucleotide(sbstr) || leftExt != '?' && leftExt != '-')) {
                this.statesOfTaxa[taxindex] = 63;
            }
            if (!(this.rightMarginIsNucleotide(sbstr) || rightExt != '?' && rightExt != '-')) {
                this.statesOfTaxa[taxindex] = 63;
            }
            ++taxindex;
        }
    }

    public boolean leftMarginIsNucleotide(String s) {
        return s.charAt(0) != '?' && s.charAt(0) != '-';
    }

    public boolean rightMarginIsNucleotide(String s) {
        return s.charAt(s.length() - 1) != '?' && s.charAt(s.length() - 1) != '-';
    }

    public void findSteps() {
        for (int f = 0; f < this.states.size(); ++f) {
            State stFrom = (State)this.states.elementAt(f);
            for (int t = f; t < this.states.size(); ++t) {
                int c;
                if (f == t) continue;
                State stTo = (State)this.states.elementAt(t);
                int minExt = this.getMin(stFrom.minExt, stTo.minExt);
                int maxExt = this.getMax(stFrom.maxExt, stTo.maxExt);
                String from = "";
                String to = "";
                for (int a = minExt; a <= maxExt; ++a) {
                    Iterator fromI = stFrom.parts.iterator();
                    boolean has = false;
                    while (fromI.hasNext()) {
                        Indel iF = (Indel)fromI.next();
                        if (a > iF.to || a < iF.from) continue;
                        has = true;
                        break;
                    }
                    from = has ? from + "0" : from + "1";
                    has = false;
                    Iterator toI = stTo.parts.iterator();
                    while (toI.hasNext()) {
                        Indel iT = (Indel)toI.next();
                        if (a > iT.to || a < iT.from) continue;
                        has = true;
                        break;
                    }
                    to = has ? to + "0" : to + "1";
                }
                String newFrom = "";
                String newTo = "";
                for (int c2 = 0; c2 < from.length() && c2 < to.length(); ++c2) {
                    if (from.charAt(c2) == '0' && to.charAt(c2) == '0') continue;
                    newFrom = newFrom + from.charAt(c2);
                    newTo = newTo + to.charAt(c2);
                }
                if (this.simm) {
                    newFrom = from;
                    newTo = to;
                }
                int ctr = 0;
                for (c = 0; c < newFrom.length() && c < newTo.length(); ++c) {
                    if (newFrom.charAt(c) != '0' || newTo.charAt(c) != '1') continue;
                    ++ctr;
                    while (newFrom.charAt(c) == '0' && newTo.charAt(c) == '1' && c < newFrom.length() - 1) {
                        ++c;
                    }
                }
                for (c = 0; c < newFrom.length() && c < newTo.length(); ++c) {
                    if (newFrom.charAt(c) != '1' || newTo.charAt(c) != '0') continue;
                    ++ctr;
                    while (newFrom.charAt(c) == '1' && newTo.charAt(c) == '0' && c < newFrom.length() - 1) {
                        ++c;
                    }
                }
                if (this.simm) {
                    int c3;
                    int blocksFrom = 0;
                    int blocksTo = 0;
                    for (c3 = 0; c3 < newFrom.length(); ++c3) {
                        if (newFrom.charAt(c3) != '1') continue;
                        ++blocksFrom;
                        while (newFrom.charAt(c3) == '1' && c3 < newFrom.length() - 1) {
                            ++c3;
                        }
                    }
                    for (c3 = 0; c3 < newTo.length(); ++c3) {
                        if (newTo.charAt(c3) != '1') continue;
                        ++blocksTo;
                        while (newTo.charAt(c3) == '1' && c3 < newTo.length() - 1) {
                            ++c3;
                        }
                    }
                }
                this.stepmatrix[f][t] = ctr;
                this.stepmatrix[t][f] = ctr;
            }
        }
    }

    public void corrSteps() {
        boolean inconsistencyPresent = false;
        for (int a = 0; a < this.states.size() - 2; ++a) {
            for (int b = a + 1; b < this.states.size() - 1; ++b) {
                for (int c = b + 1; c < this.states.size(); ++c) {
                    int costAB = this.stepmatrixCorr[a][b];
                    int costAC = this.stepmatrixCorr[a][c];
                    int costBC = this.stepmatrixCorr[b][c];
                    int costABnew = costAB;
                    int costACnew = costAC;
                    int costBCnew = costBC;
                    if (costAB + costAC < costBC) {
                        inconsistencyPresent = true;
                        costACnew = costABnew = Math.round((float)costBC / 2.0f);
                    } else if (costAB + costBC < costAC) {
                        inconsistencyPresent = true;
                        costBCnew = costABnew = Math.round((float)costAC / 2.0f);
                    } else if (costAC + costBC < costAB) {
                        inconsistencyPresent = true;
                        costBCnew = costACnew = Math.round((float)costAB / 2.0f);
                    }
                    this.stepmatrixCorr[a][b] = costABnew;
                    this.stepmatrixCorr[b][a] = costABnew;
                    this.stepmatrixCorr[a][c] = costACnew;
                    this.stepmatrixCorr[c][a] = costACnew;
                    this.stepmatrixCorr[b][c] = costBCnew;
                    this.stepmatrixCorr[c][b] = costBCnew;
                }
            }
        }
        if (!inconsistencyPresent) {
            this.consistent = true;
        }
    }

    public int countBordering(Vector parts, int minExt, int maxExt) {
        Iterator i = parts.iterator();
        int ctr = 0;
        while (i.hasNext()) {
            Indel in = (Indel)i.next();
            if (in.from == minExt && in.to == maxExt) {
                return 2;
            }
            if (in.from != minExt && in.to != maxExt) continue;
            ++ctr;
        }
        return ctr;
    }

    public int countBordering(ArrayList parts, int minExt, int maxExt) {
        Iterator i = parts.iterator();
        int ctr = 0;
        while (i.hasNext()) {
            Indel in = (Indel)i.next();
            if (in.from == minExt && in.to == maxExt) {
                return 2;
            }
            if (in.from != minExt && in.to != maxExt) continue;
            ++ctr;
        }
        return ctr;
    }

    public void defineDimensions() {
        Iterator i = this.indelsComprised.iterator();
        while (i.hasNext()) {
            Indel in = (Indel)i.next();
            this.fromMin = this.getMin(this.fromMin, in.from);
            this.toMax = this.getMax(this.toMax, in.to);
        }
    }

    public void defineDimensions(Vector subsetFrom, Vector subsetTo, int subsetMinExt, int subsetMaxExt) {
    }

    public int getMax(int alt, int neu) {
        if (neu > alt) {
            return neu;
        }
        return alt;
    }

    public int getMin(int alt, int neu) {
        if (neu < alt) {
            return neu;
        }
        return alt;
    }

    public boolean isIdent(Indel from, Indel to) {
        return from.from == to.from && from.to == to.to;
    }

    public boolean isOutside(Indel from, Indel to) {
        return from.to < to.from || to.to < from.from;
    }

    public boolean toIsSubsetSharesOneTerminal(Indel from, Indel to) {
        return to.to == from.to && to.from > from.from || to.from == from.from && to.to < from.to;
    }

    public boolean toIsSubsetSharesNoTerminal(Indel from, Indel to) {
        return from.from < to.from && from.to > to.to;
    }

    public boolean toExtendsAtOneTerminal(Indel from, Indel to) {
        return from.from == to.from && to.to > from.to || from.to == to.to && to.from < from.from;
    }

    public boolean toExtendsAtBothTerminals(Indel from, Indel to) {
        return from.from > to.from && from.to < to.to;
    }

    public boolean Overlaps(Indel from, Indel to) {
        return from.to < to.from && to.from > from.from || from.from < to.to && to.to < from.to;
    }

    public void output() {
        System.out.print("\nchar " + this.nr + " (" + this.fromMin + "-" + this.toMax + "):  ");
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            State st = (State)it.next();
            System.out.print(st.stateChar + " (" + st.name + "), ");
        }
        System.out.print("\n\n");
        for (int c = 0; c < this.states.size(); ++c) {
            State st = (State)this.states.elementAt(c);
            System.out.print(st.stateChar + " ");
        }
        System.out.print("\n\n");
        for (int o = 0; o < this.states.size(); ++o) {
            for (int i = 0; i < this.states.size(); ++i) {
                State stt = (State)this.states.elementAt(o);
                System.out.print(this.stepmatrix[o][i] + " ");
            }
            System.out.print("\n");
        }
    }

    class State {
        String name = "";
        int stateNr = 0;
        ArrayList parts;
        boolean codableInPaup = true;
        int minExt = Integer.MAX_VALUE;
        int maxExt = 0;
        char stateChar = (char)32;
        boolean isPolym = false;

        public State(ArrayList parts, int stateNr) {
            this.parts = parts;
            if (parts.isEmpty()) {
                this.stateNr = 0;
                this.name = "absent";
            } else {
                this.stateNr = stateNr;
                this.name = "indel_";
                Iterator i = parts.iterator();
                while (i.hasNext()) {
                    Indel in = (Indel)i.next();
                    this.name = this.name + "" + in.nr;
                    if (i.hasNext()) {
                        this.name = this.name + "+";
                    }
                    if (in.from < this.minExt) {
                        this.minExt = in.from;
                    }
                    if (in.to <= this.maxExt) continue;
                    this.maxExt = in.to;
                }
            }
            this.getStateChar();
        }

        private void getStateChar() {
            if (this.stateChar > '#') {
                this.codableInPaup = false;
                return;
            }
            int asciChar = this.stateNr + 48;
            if (asciChar >= 48 && asciChar <= 57) {
                this.stateChar = (char)asciChar;
            } else if (asciChar >= 58) {
                this.stateChar = (char)(asciChar += 7);
                switch (this.stateChar) {
                    case 'R': {
                        this.stateChar = (char)47;
                        break;
                    }
                    case 'Y': {
                        this.stateChar = (char)60;
                        break;
                    }
                    case 'M': {
                        this.stateChar = (char)37;
                        break;
                    }
                    case 'K': {
                        this.stateChar = (char)38;
                        break;
                    }
                    case 'S': {
                        this.stateChar = (char)39;
                        break;
                    }
                    case 'W': {
                        this.stateChar = (char)42;
                        break;
                    }
                    case 'H': {
                        this.stateChar = (char)46;
                        break;
                    }
                    case 'B': {
                        this.stateChar = (char)35;
                        break;
                    }
                    case 'V': {
                        this.stateChar = (char)58;
                        break;
                    }
                    case 'D': {
                        this.stateChar = (char)36;
                        break;
                    }
                    case 'N': {
                        this.stateChar = (char)62;
                    }
                }
            }
        }
    }
}

