/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class ComplexIndelCoding {
    Vector indelv;
    ArrayList indels;
    ArrayList sequences;
    String file = "";
    String version = "";
    String date = "";
    Vector characters;
    String st = "";
    char[][] indelCharMatrix;
    int sequenceLength = 0;
    int nameLength = 0;
    boolean corr = false;
    boolean simm = false;
    boolean baum = false;
    boolean mix = false;
    boolean inconsistentPresent = true;
    ArrayList indelsCausingIncons = new ArrayList();

    public ComplexIndelCoding(ArrayList sequences, String filepath, String version, String date, boolean filter, boolean ignore, boolean corr, String st, boolean includeBorderIndels) {
        this.st = st;
        if (st.equalsIgnoreCase("Simmons & Ochoterena (2000) - complex coding")) {
            this.simm = true;
        }
        if (st.equalsIgnoreCase("Baum et al. (1994)")) {
            this.baum = true;
        }
        if (st.equalsIgnoreCase("modified complex coding - inconsistent = simple")) {
            this.mix = true;
            corr = true;
        }
        this.corr = corr;
        this.version = version;
        this.date = date;
        this.indels = new ArrayList();
        this.sequences = sequences;
        Iterator ii = sequences.iterator();
        if (ii.hasNext()) {
            sequence s = (sequence)ii.next();
            this.sequenceLength = s.sequence.length();
        }
        this.file = this.removeFileExtension(filepath);
        IndelScreening is = new IndelScreening(sequences, this.indels, filter, ignore, includeBorderIndels);
        this.indelv = new Vector(this.indels);
        this.characters = new Vector();
        if (this.mix) {
            System.err.println("mix (insconsistent=simple) requested but not supported under MCIC2");
            return;
        }
        this.getCharacters();
        try {
            this.writeComplexCoding();
            System.out.print("\nDone\n");
        }
        catch (Exception e) {
            System.out.print("\n!!Exception in ComplexIndelCoding - ln ~102\n\n");
        }
    }

    public void fillCharMatrix() {
    }

    public void createCharacterMatrix() {
        this.indelCharMatrix = new char[this.sequences.size()][this.characters.size()];
        int seqNr = 0;
        int charNr = 0;
        Iterator si = this.sequences.iterator();
        while (si.hasNext()) {
            sequence sq = (sequence)si.next();
            charNr = 0;
            Iterator ci = this.characters.iterator();
            while (ci.hasNext()) {
                IndelChar ic = (IndelChar)ci.next();
                Iterator csi = ic.states.iterator();
                boolean presenceOfAny = false;
                while (csi.hasNext()) {
                    IndelChar.State s = (IndelChar.State)csi.next();
                    if (s.stateNr == 0) continue;
                    String gapControl = "";
                    Iterator sp = s.parts.iterator();
                    boolean allPartsPresent = true;
                    while (sp.hasNext()) {
                        Indel in = (Indel)sp.next();
                        if (sq.sequence.charAt(in.from - 2) == '-' || sq.sequence.charAt(in.to) == '-') {
                            allPartsPresent = false;
                        }
                        gapControl = gapControl + sq.sequence.substring(in.from - 1, in.to);
                    }
                    if (!allPartsPresent || !this.statePresent(gapControl)) continue;
                    this.indelCharMatrix[seqNr][charNr] = s.stateChar;
                    presenceOfAny = true;
                }
                if (!presenceOfAny) {
                    this.indelCharMatrix[seqNr][charNr] = 48;
                }
                ++charNr;
            }
            ++seqNr;
        }
    }

    public boolean statePresent(String s) {
        for (int a = 0; a < s.length(); ++a) {
            if (s.charAt(a) == '-') continue;
            return false;
        }
        return true;
    }

    public void getCharacters() {
        this.inconsistentPresent = false;
        System.out.print("call of getCh\n");
        int index = 0;
        int curFrom = 0;
        int toMax = 0;
        int lastIndexSubset = 0;
        while (index < this.indelv.size()) {
            int c;
            Indel ind = (Indel)this.indelv.elementAt(index);
            System.out.println("@ " + ind.name);
            curFrom = ind.from;
            toMax = ind.to;
            lastIndexSubset = index;
            if (this.baum) {
                for (c = index; c < this.indelv.size(); ++c) {
                    ind = (Indel)this.indelv.elementAt(c);
                    if (ind.from > toMax) continue;
                    lastIndexSubset = c;
                    toMax = this.getMax(toMax, ind.to);
                }
            } else {
                for (c = index; c < this.indelv.size(); ++c) {
                    ind = (Indel)this.indelv.elementAt(c);
                    if (ind.from > toMax) continue;
                    System.out.println("The NEW MCIC2 method requ.");
                    lastIndexSubset = c;
                    toMax = this.getMax(toMax, ind.to);
                }
            }
            Vector indelsOfChar = new Vector();
            for (int a = index; a <= lastIndexSubset; ++a) {
                indelsOfChar.add(this.indelv.elementAt(a));
            }
            IndelChar ic = new IndelChar(indelsOfChar, this.sequences, this.indels, this.simm, this.corr);
            index = lastIndexSubset + 1;
            if (this.mix) {
                System.err.println("\nmix required - not supported\n");
                continue;
            }
            if (!ic.codableInPaup) continue;
            this.characters.add(ic);
        }
        Iterator ci = this.characters.iterator();
        int b = 1;
        while (ci.hasNext()) {
            IndelChar ic = (IndelChar)ci.next();
            ic.nr = b++;
        }
    }

    public int getMax(int alt, int neu) {
        if (neu > alt) {
            return neu;
        }
        return alt;
    }

    public int getMin(int alt, int neu) {
        if (neu < alt) {
            return neu;
        }
        return alt;
    }

    public void testOutputMatrix() {
        Iterator i = this.sequences.iterator();
        int index = 0;
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            System.out.print(s.name + "\t");
            for (int a = 0; a < this.characters.size(); ++a) {
                System.out.print(this.indelCharMatrix[index][a]);
            }
            System.out.print("\n");
            ++index;
        }
    }

    public void testOutputChars() {
        Iterator sii = this.sequences.iterator();
        while (sii.hasNext()) {
            sequence se = (sequence)sii.next();
            System.out.print(se.name + "\t" + se.sequence + "\n");
        }
        System.out.print("\ndelimited the following chars:\n\n");
        Iterator ci = this.characters.iterator();
        while (ci.hasNext()) {
            IndelChar ic = (IndelChar)ci.next();
            ic.output();
        }
    }

    public void testOutputIndels() {
        Iterator sii = this.sequences.iterator();
        while (sii.hasNext()) {
            sequence se = (sequence)sii.next();
            System.out.print(se.name + "\t" + se.sequence + "\n");
        }
        System.out.print("\n\nindel\textension\n\n");
        Iterator i = this.indels.iterator();
        while (i.hasNext()) {
            Indel ind = (Indel)i.next();
            System.out.print(ind.nr + "\t" + ind.from + "-" + ind.to + "\t");
            for (int b = 0; b < this.sequences.size(); ++b) {
                System.out.print(ind.stateInTaxa[b] + " ");
            }
            System.out.print("\n");
        }
        System.out.print("\n\n");
        Iterator si = this.sequences.iterator();
        int seqNr = 0;
        while (si.hasNext()) {
            sequence s = (sequence)si.next();
            System.out.print(s.name + "\t");
            Iterator ini = this.indels.iterator();
            while (ini.hasNext()) {
                Indel ind = (Indel)ini.next();
                System.out.print(ind.stateInTaxa[seqNr]);
            }
            ++seqNr;
            System.out.print("\n");
        }
    }

    public void writeHumanReadableComplexCoding() throws IOException {
        System.out.println("\nwriting human readable...\n");
        String ff = "_mcic_readable.txt";
        File f = new File(this.file + ff);
        FileWriter fw = new FileWriter(f);
        fw.write("[generated with SeqState version " + this.version + "]\n");
        fw.write("*****************************\n\n" + this.file + "\n\n*****************************\n");
        for (int a = 0; a < this.characters.size(); ++a) {
            IndelChar.State stt;
            int o;
            IndelChar.State st;
            int c;
            IndelChar ic = (IndelChar)this.characters.elementAt(a);
            fw.write("\n\n");
            fw.write("indel character " + ic.nr + ", " + ic.name + ":\n");
            System.out.println("indel character " + ic.nr + ", " + ic.name + ":\n");
            fw.write("corresponding alignment section:\n\n");
            Iterator j = this.sequences.iterator();
            sequence se = (sequence)j.next();
            int nameLength = se.nameAligned.length();
            System.out.println("329\n");
            int border = 0;
            if (ic.fromMin >= 10 && ic.toMax <= se.sequence.length() - 10) {
                border = 10;
            }
            System.out.println("338\n");
            int section_from = ic.fromMin - border;
            int section_to = ic.toMax + border;
            this.writeNumbersAbove(ic.fromMin, ic.toMax, nameLength + 2 + border, fw);
            System.out.println("342\n");
            Iterator ii = this.sequences.iterator();
            int index = 0;
            while (ii.hasNext()) {
                sequence s = (sequence)ii.next();
                System.out.println("349\n");
                fw.write(s.nameAligned + "  ");
                System.out.println("\n" + section_from + " " + section_to + "\n");
                String sec = s.sequence.substring(section_from, section_to);
                fw.write(sec + "    ");
                System.out.println("356\n");
                fw.write(ic.statesOfTaxa[index]);
                System.out.println("359\n");
                fw.write("\n");
                ++index;
            }
            System.out.println("364\n");
            if (ic.states.size() == 2) continue;
            int charNr = this.sequenceLength;
            fw.write("\n\nstepmatrix:\n");
            Iterator it = ic.states.iterator();
            while (it.hasNext()) {
                IndelChar.State st2 = (IndelChar.State)it.next();
                fw.write(st2.stateChar + " (" + st2.name + ": ");
                Iterator pi = st2.parts.iterator();
                while (pi.hasNext()) {
                    Indel in = (Indel)pi.next();
                    fw.write(" " + in.from + "-" + in.to + " ");
                }
                fw.write(") ");
                if (!it.hasNext()) continue;
                fw.write(", ");
            }
            fw.write("\n\n");
            System.out.println("384\n");
            fw.write("    ");
            for (c = 0; c < ic.states.size(); ++c) {
                st = (IndelChar.State)ic.states.elementAt(c);
                fw.write(st.stateChar + " ");
            }
            fw.write("\n\n");
            for (o = 0; o < ic.states.size(); ++o) {
                st = (IndelChar.State)ic.states.elementAt(o);
                fw.write("[" + st.stateChar + "] ");
                for (int i = 0; i < ic.states.size(); ++i) {
                    stt = (IndelChar.State)ic.states.elementAt(o);
                    fw.write(ic.stepmatrixCorr[o][i] + " ");
                }
                fw.write("\n");
            }
            fw.write(";\n\n");
            if (!ic.correctionWasRequired) continue;
            fw.write("[prior to adjustment to satisfy triangle inequality:]\n\n");
            if (this.corr) {
                fw.write("   [");
            } else {
                fw.write("    ");
            }
            for (c = 0; c < ic.states.size(); ++c) {
                st = (IndelChar.State)ic.states.elementAt(c);
                fw.write(st.stateChar + " ");
            }
            fw.write("\n\n");
            for (o = 0; o < ic.states.size(); ++o) {
                st = (IndelChar.State)ic.states.elementAt(o);
                fw.write("[" + st.stateChar + "] ");
                for (int i = 0; i < ic.states.size(); ++i) {
                    stt = (IndelChar.State)ic.states.elementAt(o);
                    fw.write(ic.stepmatrix[o][i] + " ");
                }
                fw.write("\n");
            }
            if (this.corr) {
                fw.write("]");
            }
            fw.write("\n");
        }
        System.out.println("428\n");
        fw.write("\n\nThe full alignment:\n\n");
        Iterator it0 = this.sequences.iterator();
        sequence s0 = (sequence)it0.next();
        this.sequenceLength = s0.sequence.length();
        this.nameLength = s0.nameAligned.length();
        this.writeNumbersAbove(1, this.sequenceLength, this.nameLength + 1, fw);
        Iterator it = this.sequences.iterator();
        while (it.hasNext()) {
            sequence s = (sequence)it.next();
            fw.write(s.nameAligned + " " + s.sequence + "\n");
        }
        System.out.println("442\n");
        fw.write("\n\n");
        fw.write("\n\n");
        fw.flush();
        fw.close();
    }

    public void writeComplexCoding() throws IOException {
        Iterator i;
        try {
            this.writeHumanReadableComplexCoding();
            System.out.println("\nwriteHumanReadableComplexCoding apparently worked.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("writeHuman sucks.\n");
        }
        String ff = "_mcic.nex";
        if (!this.corr) {
            ff = "_mcic_pc.nex";
        }
        if (this.baum) {
            ff = "_bm.nex";
        }
        if (this.simm) {
            ff = "_cic.nex";
        }
        if (this.mix) {
            ff = "_mcic_mix.nex";
        }
        File f = new File(this.file + ff);
        FileWriter fw = new FileWriter(f);
        this.writeComplexNexHead(fw);
        fw.write("\nMATRIX\n\n");
        Iterator it0 = this.sequences.iterator();
        sequence s0 = (sequence)it0.next();
        this.sequenceLength = s0.sequence.length();
        this.nameLength = s0.nameAligned.length();
        this.writeNumbersAbove(1, this.sequenceLength, this.nameLength + 1, fw);
        Iterator it = this.sequences.iterator();
        while (it.hasNext()) {
            sequence s = (sequence)it.next();
            fw.write(s.nameAligned + " " + s.sequence + "\n");
        }
        fw.write("\n\n");
        if (this.mix) {
            fw.write("[! " + (this.characters.size() + this.indelsCausingIncons.size()) + " indel characters coded - " + this.characters.size() + " with \"modified complex\" method, " + this.indelsCausingIncons.size() + " (that would require inconsistent step matrices) using the simple method.] \n\n");
        }
        this.writeNumbersAbove(this.sequenceLength + 1, this.sequenceLength + this.characters.size(), this.nameLength + 1, fw);
        if (this.baum) {
            i = this.characters.iterator();
            while (i.hasNext()) {
                IndelChar ic = (IndelChar)i.next();
                System.out.print(ic.name + ": ");
                Iterator si = ic.states.iterator();
                ic.polymorphic = "{";
                int nrOfOnlyOneGap = 0;
                while (si.hasNext()) {
                    IndelChar.State s = (IndelChar.State)si.next();
                    if (s.stateChar == '0') continue;
                    s.isPolym = true;
                    if (s.parts.size() != 1) continue;
                    ++nrOfOnlyOneGap;
                    s.isPolym = false;
                    ic.polymorphic = ic.polymorphic + s.stateChar;
                    ic.polymorphic = ic.polymorphic + ",";
                }
                ic.polymorphic = nrOfOnlyOneGap < 2 ? ic.polymorphic + "0}" : ic.polymorphic + "}";
                System.out.print(ic.polymorphic + "\n");
                ic.baumstatesOfTaxa = new String[this.sequences.size()];
                for (int ci = 0; ci < this.sequences.size(); ++ci) {
                    ic.baumstatesOfTaxa[ci] = "" + ic.statesOfTaxa[ci];
                }
                for (int b = 0; b < ic.states.size(); ++b) {
                    IndelChar.State st = (IndelChar.State)ic.states.elementAt(b);
                    if (!st.isPolym) continue;
                    for (int c = 0; c < this.sequences.size(); ++c) {
                        if (st.stateChar != ic.statesOfTaxa[c]) continue;
                        ic.baumstatesOfTaxa[c] = ic.polymorphic;
                    }
                }
            }
        }
        i = this.sequences.iterator();
        int index = 0;
        while (i.hasNext()) {
            sequence s = (sequence)i.next();
            fw.write(s.nameAligned + " ");
            for (int a = 0; a < this.characters.size(); ++a) {
                IndelChar ic = (IndelChar)this.characters.elementAt(a);
                if (this.baum) {
                    fw.write(ic.baumstatesOfTaxa[index]);
                    continue;
                }
                fw.write(ic.statesOfTaxa[index]);
            }
            fw.write("\n");
            ++index;
        }
        if (this.mix && this.indelsCausingIncons.size() > 0) {
            fw.write("\n\n");
            this.writeNumbersAbove(this.sequenceLength + this.characters.size() + 1, this.sequenceLength + this.characters.size() + this.indelsCausingIncons.size(), this.nameLength + 1, fw);
            int seqNr = 0;
            Iterator si = this.sequences.iterator();
            while (si.hasNext()) {
                sequence s = (sequence)si.next();
                fw.write(s.nameAligned + " ");
                Iterator ini = this.indelsCausingIncons.iterator();
                while (ini.hasNext()) {
                    Indel ind = (Indel)ini.next();
                    fw.write(ind.stateInTaxa[seqNr]);
                }
                ++seqNr;
                fw.write("\n");
            }
        }
        fw.write(";\nEND;\n\n");
        if (!this.baum) {
            this.writeAssumptionsBlock(fw);
        }
        this.writeSetsBlock(fw);
        this.writePaupBlock(fw);
        this.writeIndelInfo(fw);
        fw.flush();
        fw.close();
    }

    public void writeAssumptionsBlock(FileWriter fw) throws IOException {
        fw.write("BEGIN ASSUMPTIONS;");
        String typeset = "typeset complexIndelCoding = ";
        int charNr = this.sequenceLength;
        Iterator ci = this.characters.iterator();
        while (ci.hasNext()) {
            IndelChar.State stt;
            int i;
            int o;
            IndelChar.State st;
            int c;
            ++charNr;
            IndelChar ic = (IndelChar)ci.next();
            if (ic.states.size() == 2) continue;
            fw.write("\n\n[char " + charNr + ", indel char " + ic.nr + " (" + ic.fromMin + "-" + ic.toMax + "):  ");
            Iterator it = ic.states.iterator();
            while (it.hasNext()) {
                IndelChar.State st2 = (IndelChar.State)it.next();
                fw.write(st2.stateChar + " (" + st2.name + ")");
                if (!it.hasNext()) continue;
                fw.write(", ");
            }
            fw.write("]\n\n");
            typeset = typeset + "stepmatrix" + charNr + ": " + charNr + ",";
            fw.write("usertype stepmatrix" + charNr + " (stepmatrix)=" + ic.states.size() + "\n\n");
            if (this.corr) {
                fw.write("    ");
                for (c = 0; c < ic.states.size(); ++c) {
                    st = (IndelChar.State)ic.states.elementAt(c);
                    fw.write(st.stateChar + " ");
                }
                fw.write("\n\n");
                for (o = 0; o < ic.states.size(); ++o) {
                    st = (IndelChar.State)ic.states.elementAt(o);
                    fw.write("[" + st.stateChar + "] ");
                    for (i = 0; i < ic.states.size(); ++i) {
                        stt = (IndelChar.State)ic.states.elementAt(o);
                        fw.write(ic.stepmatrixCorr[o][i] + " ");
                    }
                    fw.write("\n");
                }
                fw.write(";\n\n");
                if (!ic.correctionWasRequired) continue;
                fw.write("[prior to adjustment to satisfy triangle inequality:]\n\n");
                if (this.corr) {
                    fw.write("   [");
                } else {
                    fw.write("    ");
                }
                for (c = 0; c < ic.states.size(); ++c) {
                    st = (IndelChar.State)ic.states.elementAt(c);
                    fw.write(st.stateChar + " ");
                }
                fw.write("\n\n");
                for (o = 0; o < ic.states.size(); ++o) {
                    st = (IndelChar.State)ic.states.elementAt(o);
                    fw.write("[" + st.stateChar + "] ");
                    for (i = 0; i < ic.states.size(); ++i) {
                        stt = (IndelChar.State)ic.states.elementAt(o);
                        fw.write(ic.stepmatrix[o][i] + " ");
                    }
                    fw.write("\n");
                }
                fw.write(";");
                if (this.corr) {
                    fw.write("]");
                }
                fw.write("\n\n");
                continue;
            }
            fw.write("    ");
            for (c = 0; c < ic.states.size(); ++c) {
                st = (IndelChar.State)ic.states.elementAt(c);
                fw.write(st.stateChar + " ");
            }
            fw.write("\n\n");
            for (o = 0; o < ic.states.size(); ++o) {
                st = (IndelChar.State)ic.states.elementAt(o);
                fw.write("[" + st.stateChar + "] ");
                for (i = 0; i < ic.states.size(); ++i) {
                    stt = (IndelChar.State)ic.states.elementAt(o);
                    fw.write(ic.stepmatrix[o][i] + " ");
                }
                fw.write("\n");
            }
            fw.write(";");
            fw.write("\n\n");
        }
        typeset = typeset.substring(0, typeset.length() - 1);
        typeset = typeset + ";\n";
        fw.write(typeset);
        fw.write(";\n");
        fw.write("\nEND;\n");
    }

    public void writeSetsBlock(FileWriter fw) throws IOException {
        fw.write("\n\nBEGIN SETS;\n");
        Iterator itt = this.sequences.iterator();
        sequence s = (sequence)itt.next();
        int charNr = s.sequence.length();
        if (this.mix) {
            fw.write("  CHARSET indels = " + (charNr + 1) + "-" + (charNr + this.characters.size() + this.indelsCausingIncons.size()) + ";\n");
        } else {
            fw.write("  CHARSET indels = " + (charNr + 1) + "-" + (charNr + this.characters.size()) + ";\n");
        }
        fw.write("END;\n");
    }

    public void writePaupBlock(FileWriter fw) throws IOException {
        fw.write("\nBEGIN PAUP;\n");
        if (!this.baum) {
            fw.write("assume typeset=complexIndelCoding;\n");
        }
        fw.write("END;\n");
    }

    public void writeComplexNexHead(FileWriter fw) throws IOException {
        fw.write("#NEXUS\n");
        fw.write("[!matrix with indels coded according to " + this.st + "]\n");
        Date d = new Date();
        fw.write("[!compiled on " + d + " with SeqState version " + this.version + " build " + this.date + "]\n\n");
        fw.write("BEGIN CHARACTERS;\n");
        fw.write("DIMENSIONS newtaxa ntax=" + this.sequences.size() + " NCHAR=");
        Iterator it = this.sequences.iterator();
        sequence se = (sequence)it.next();
        int charNr = se.sequence.length();
        if (this.mix) {
            fw.write(charNr + this.characters.size() + this.indelsCausingIncons.size() + ";\n");
        } else {
            fw.write(charNr + this.characters.size() + ";\n");
        }
        fw.write("FORMAT \n");
        fw.write("\tDATATYPE = standard \n");
        fw.write("\tGAP = - \n");
        fw.write("\tMISSING = ? \n");
        fw.write("\tSYMBOLS=\"0123456789A#C$EFG.IJ&L%>OPQ/'TU:*X<Z\" \n");
        fw.write("\tEQUATE=\"R={AG} Y={CT} M={AC} K={GT} S={CG} W={AT} H={ACT} B={CGT} V={ACG} D={AGT} N={ACGT} r={AG} y={CT} m={AC} k={GT} s={CG} w={AT} h={ACT} b={CGT} v={ACG} d={AGT} n={ACGT}\"\n");
        fw.write("INTERLEAVE;\n");
        fw.write("CHARSTATELABELS\n");
        Iterator ii = this.characters.iterator();
        while (ii.hasNext()) {
            IndelChar in = (IndelChar)ii.next();
            fw.write("\t" + ++charNr + " " + in.name + "  /");
            Iterator csi = in.states.iterator();
            while (csi.hasNext()) {
                IndelChar.State cs = (IndelChar.State)csi.next();
                fw.write(cs.name + " ");
            }
            if (!ii.hasNext()) continue;
            fw.write(",\n");
        }
        if (this.mix) {
            Iterator iii = this.indelsCausingIncons.iterator();
            while (iii.hasNext()) {
                Indel in = (Indel)iii.next();
                fw.write(",");
                fw.write("\n");
                fw.write("       " + ++charNr + " " + in.name);
            }
        }
        fw.write("\n;\n");
    }

    public String removeFileExtension(String longname) {
        int pos = longname.length();
        for (int i = longname.length() - 1; i >= 0; --i) {
            if (longname.charAt(i) != '.') continue;
            pos = i;
            break;
        }
        return longname.substring(0, pos);
    }

    public void writeNumbersAbove(int start, int end, int indent, FileWriter fw) throws IOException {
        Vector<String> nrLabels = new Vector<String>();
        String rows = Integer.toString(end);
        int height = rows.length();
        for (int i = start; i <= end; ++i) {
            String nr = Integer.toString(i);
            nrLabels.add(nr);
        }
        for (int c = 0; c < height; ++c) {
            int d;
            if (c == 0) {
                for (d = 0; d < indent - 1; ++d) {
                    fw.write(" ");
                }
                fw.write("[");
            } else {
                for (d = 0; d < indent; ++d) {
                    fw.write(" ");
                }
            }
            Iterator it = nrLabels.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.length() > c) {
                    fw.write(s.charAt(c));
                    continue;
                }
                fw.write(" ");
            }
            if (c == height - 1) {
                fw.write("]");
            }
            fw.write("\n");
        }
        fw.write("\n");
    }

    public void writeIndelInfo(FileWriter fw) throws IOException {
        fw.write("\n\n[Indels:\n\nNo.\textension\n\n");
        Iterator ini = this.indels.iterator();
        while (ini.hasNext()) {
            fw.write(" ");
            Indel in = (Indel)ini.next();
            fw.write(in.nr + "\t" + in.from + "-" + in.to + "\n");
        }
        fw.write("]\n\n");
    }

    public void assignTaxaInWhich() {
        Iterator iit = this.indelsCausingIncons.iterator();
        while (iit.hasNext()) {
            Indel in = (Indel)iit.next();
            Iterator sit = this.sequences.iterator();
            int taxNr = 0;
            while (sit.hasNext()) {
                sequence s = (sequence)sit.next();
                in.stateInTaxa[taxNr] = this.subset(in, s.sequence) || this.invalid(in, s.sequence) ? 63 : (this.present(in, s.sequence) ? 49 : 48);
                ++taxNr;
            }
        }
    }

    public boolean invalid(Indel in, String s) {
        if (!this.present(in, s)) {
            return false;
        }
        if (in.from == 1 && in.to == s.length()) {
            return true;
        }
        if (in.from == 1) {
            if (this.present(in, s) && s.charAt(in.to) == '?') {
                return true;
            }
            for (int a = in.from; a <= in.to; ++a) {
                if (s.charAt(a - 1) != '?') continue;
                return true;
            }
            return false;
        }
        if (in.to == s.length()) {
            if (this.present(in, s) && s.charAt(in.from - 2) == '?') {
                return true;
            }
            for (int a = in.from; a <= in.to; ++a) {
                if (s.charAt(a - 1) != '?') continue;
                return true;
            }
            return false;
        }
        if (this.present(in, s) && (s.charAt(in.from - 2) == '?' || s.charAt(in.to) == '?')) {
            return true;
        }
        for (int a = in.from; a <= in.to; ++a) {
            if (s.charAt(a - 1) != '?') continue;
            return true;
        }
        return false;
    }

    public boolean subset(Indel in, String s) {
        if (!this.present(in, s)) {
            return false;
        }
        if (in.from == 1 && in.to == s.length()) {
            return false;
        }
        return in.from == 1 ? s.charAt(in.to) == '-' : (in.to == s.length() ? s.charAt(in.from - 2) == '-' : this.present(in, s) && (s.charAt(in.from - 2) == '-' || s.charAt(in.to) == '-'));
    }

    public boolean present(Indel in, String s) {
        for (int a = in.from; a <= in.to; ++a) {
            if (s.charAt(a - 1) == '-') continue;
            return false;
        }
        return true;
    }
}

