/*
 * JPhyloIO - Event based parsing and stream writing of multiple sequence alignment and tree formats. 
 * Copyright (C) 2015-2019  Ben Stöver, Sarah Wiechers
 * <http://bioinfweb.info/JPhyloIO>
 * 
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package info.bioinfweb.jphyloio.formats.text;


import info.bioinfweb.jphyloio.AbstractEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.DocumentDataAdapter;

import java.io.IOException;
import java.io.Writer;



public abstract class AbstractTextEventWriter<P extends TextWriterStreamDataProvider<? extends AbstractTextEventWriter<P>>> 
		extends AbstractEventWriter<P>  {
	private Writer writer;
	

	protected Writer getWriter() {
		return writer;
	}


	@Override
	protected void doWriteDocument(DocumentDataAdapter document, Writer writer, ReadWriteParameterMap parameters)
			throws IOException {
		this.writer = writer;
	}
}
