/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.utils;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JPhyloIOReadingUtils {
    private static final EventType LITERAL_META_END = new EventType(EventContentType.LITERAL_META, EventTopologyType.END);

    public static void reachElementEnd(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        JPhyloIOEvent jPhyloIOEvent = jPhyloIOEventReader.next();
        while (!jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.END)) {
            if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                JPhyloIOReadingUtils.reachElementEnd(jPhyloIOEventReader);
            }
            jPhyloIOEvent = jPhyloIOEventReader.next();
        }
    }

    public static StringBuilder readLiteralMetadataContentAsStringBuilder(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        JPhyloIOEvent jPhyloIOEvent = jPhyloIOEventReader.next();
        if (!jPhyloIOEvent.getType().equals(LITERAL_META_END)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            do {
                if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META_CONTENT)) {
                    LiteralMetadataContentEvent literalMetadataContentEvent = jPhyloIOEvent.asLiteralMetadataContentEvent();
                    if (bl) {
                        if (literalMetadataContentEvent.getStringValue() == null) {
                            stringBuilder.append(literalMetadataContentEvent.getObjectValue().toString());
                        } else {
                            stringBuilder.append(literalMetadataContentEvent.getStringValue());
                        }
                        bl = literalMetadataContentEvent.isContinuedInNextEvent();
                        continue;
                    }
                    throw new IOException("Another literal metadata content event was encountered, although the sequence was declared to be terminated by the last event.");
                }
                if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.SOLE)) continue;
                JPhyloIOReadingUtils.reachElementEnd(jPhyloIOEventReader);
            } while (!(jPhyloIOEvent = jPhyloIOEventReader.next()).getType().equals(LITERAL_META_END));
            return stringBuilder;
        }
        return null;
    }

    public static String readLiteralMetadataContentAsString(JPhyloIOEventReader jPhyloIOEventReader) throws IOException {
        StringBuilder stringBuilder = JPhyloIOReadingUtils.readLiteralMetadataContentAsStringBuilder(jPhyloIOEventReader);
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static <O> O readLiteralMetadataContentAsObject(JPhyloIOEventReader jPhyloIOEventReader, Class<O> clazz) throws IOException, ClassCastException {
        Object object = null;
        JPhyloIOEvent jPhyloIOEvent = jPhyloIOEventReader.next();
        if (!jPhyloIOEvent.getType().equals(LITERAL_META_END)) {
            do {
                if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META_CONTENT)) {
                    if (object == null) {
                        LiteralMetadataContentEvent literalMetadataContentEvent = jPhyloIOEvent.asLiteralMetadataContentEvent();
                        if (literalMetadataContentEvent.hasObjectValue()) {
                            if (clazz.isInstance(literalMetadataContentEvent.getObjectValue())) {
                                object = literalMetadataContentEvent.getObjectValue();
                                continue;
                            }
                            throw new ClassCastException("The encountered object value does not implement the specified type " + clazz.getCanonicalName() + ".");
                        }
                        throw new IOException("The encountered literal metadata content event did not carry an object value.");
                    }
                    throw new IOException("More than one literal metadata content event was encountered, although a single object value was expected.");
                }
                if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.SOLE)) continue;
                JPhyloIOReadingUtils.reachElementEnd(jPhyloIOEventReader);
            } while (!(jPhyloIOEvent = jPhyloIOEventReader.next()).getType().equals(LITERAL_META_END));
        }
        return (O)object;
    }

    public static <E extends JPhyloIOEvent> List<E> collectEvents(JPhyloIOEventReader jPhyloIOEventReader, Set<EventType> set, Class<E> clazz) throws IOException {
        ArrayList<JPhyloIOEvent> arrayList = new ArrayList<JPhyloIOEvent>();
        while (jPhyloIOEventReader.hasNextEvent()) {
            JPhyloIOEvent jPhyloIOEvent = jPhyloIOEventReader.next();
            if (!clazz.isInstance(jPhyloIOEvent) || !set.contains(jPhyloIOEvent.getType())) continue;
            arrayList.add(jPhyloIOEvent);
        }
        return arrayList;
    }

    public static List<JPhyloIOEvent> collectEvents(JPhyloIOEventReader jPhyloIOEventReader, Set<EventType> set) throws IOException {
        return JPhyloIOReadingUtils.collectEvents(jPhyloIOEventReader, set, JPhyloIOEvent.class);
    }
}

