/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xtg;

import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.xml.AttributeInfo;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLStartElementReader;
import info.bioinfweb.jphyloio.formats.xtg.XTGConstants;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XTGFormattedTextElementReader
extends XMLStartElementReader
implements XTGConstants {
    public XTGFormattedTextElementReader(QName qName, QName qName2, URIOrStringIdentifier uRIOrStringIdentifier, boolean bl, AttributeInfo ... attributeInfoArray) {
        super(qName, qName2, uRIOrStringIdentifier, bl, attributeInfoArray);
    }

    @Override
    public void readEvent(XMLReaderStreamDataProvider xMLReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
        StartElement startElement = xMLEvent.asStartElement();
        boolean bl = XMLUtils.readBooleanAttr((StartElement)startElement, (QName)ATTR_TEXT_IS_DECIMAL, (boolean)false);
        String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)ATTR_TEXT, null);
        if (this.isEdgeMeta()) {
            xMLReaderStreamDataProvider.setCurrentEventCollection(xMLReaderStreamDataProvider.getSourceNode().peek().getNestedEdgeEvents());
        }
        URIOrStringIdentifier uRIOrStringIdentifier = bl ? new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_DOUBLE) : new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_STRING);
        xMLReaderStreamDataProvider.getCurrentEventCollection().add(new ResourceMetadataEvent("meta" + xMLReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, this.getResourcePredicate()), null, null));
        if (string != null) {
            xMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + xMLReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PREDICATE_TEXT), uRIOrStringIdentifier, LiteralContentSequenceType.SIMPLE));
            if (bl) {
                try {
                    xMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(Double.parseDouble(string), string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JPhyloIOReaderException("The value \"" + string + "\" was marked as decimal, but could not be parsed.", xMLEvent.getLocation());
                }
            } else {
                xMLReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent((Object)string, string));
            }
            xMLReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
        }
        this.readAttributes(xMLReaderStreamDataProvider, startElement, "", this.getAttributeInformationMap());
    }
}

