/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.stax;

import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.stax.AbstractMetaXMLReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MetaXMLStreamReader
extends AbstractMetaXMLReader
implements XMLStreamReader {
    private XMLEvent currentEvent;
    private StartElement currentStartElement;
    private List<Attribute> currentAttributes = new ArrayList<Attribute>();
    private List<Namespace> currentNamespaces = new ArrayList<Namespace>();

    public MetaXMLStreamReader(XMLReaderStreamDataProvider<?> xMLReaderStreamDataProvider) {
        super(xMLReaderStreamDataProvider);
    }

    @Override
    public int getAttributeCount() {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.size();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributeLocalName(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getName().getLocalPart();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public QName getAttributeName(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getName();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributeNamespace(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getName().getNamespaceURI();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributePrefix(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getName().getPrefix();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributeType(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getDTDType();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributeValue(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).getValue();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentStartElement.getAttributeByName(new QName(string, string2)).getValue();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public String getCharacterEncodingScheme() {
        if (this.getEventType() == 7) {
            return this.getStreamDataProvider().getStartDocumentEvent().getCharacterEncodingScheme();
        }
        throw new IllegalStateException("This method can only be called on a start document event.");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("To read the next element text this reader must be positioned on a start element.");
        }
        int n = this.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            switch (n) {
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    stringBuffer.append(this.getText());
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 8: {
                    throw new XMLStreamException("The end of the document was reached while reading element text content.");
                }
                case 1: {
                    throw new XMLStreamException("Only text elements are allowed to be nested while reading element text content.");
                }
                default: {
                    throw new XMLStreamException("An unexpected event type was encountered while reading element text content.");
                }
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    @Override
    public String getEncoding() {
        if (this.getEventType() == 7) {
            return null;
        }
        throw new IllegalStateException("This method can only be called on a start document event.");
    }

    @Override
    public int getEventType() {
        return this.currentEvent.getEventType();
    }

    @Override
    public String getLocalName() {
        switch (this.getEventType()) {
            case 1: {
                return this.currentStartElement.getName().getLocalPart();
            }
            case 2: {
                return this.currentEvent.asEndElement().getName().getLocalPart();
            }
            case 9: {
                return ((EntityReference)this.currentEvent).getName();
            }
        }
        throw new IllegalStateException("This method can only be called on a start element, end element or entity reference.");
    }

    @Override
    public Location getLocation() {
        return this.currentEvent.getLocation();
    }

    @Override
    public QName getName() {
        switch (this.getEventType()) {
            case 1: {
                return this.currentStartElement.getName();
            }
            case 2: {
                return this.currentEvent.asEndElement().getName();
            }
        }
        throw new IllegalStateException("This method can only be called on a start element or an end element.");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.getJPhyloIOEventReader().getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        if (this.getEventType() == 1 || this.getEventType() == 2 || this.getEventType() == 13) {
            return this.currentNamespaces.size();
        }
        throw new IllegalStateException("This method can only be called on a start element, end element or namespace.");
    }

    @Override
    public String getNamespacePrefix(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 2 || this.getEventType() == 13) {
            return this.currentNamespaces.get(n).getPrefix();
        }
        throw new IllegalStateException("This method can only be called on a start element, end element or namespace.");
    }

    @Override
    public String getNamespaceURI() {
        switch (this.getEventType()) {
            case 1: {
                return this.currentStartElement.getName().getNamespaceURI();
            }
            case 2: {
                return this.currentEvent.asEndElement().getName().getNamespaceURI();
            }
        }
        throw new IllegalStateException("This method can only be called on a start element or an end element.");
    }

    @Override
    public String getNamespaceURI(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 2 || this.getEventType() == 13) {
            return this.currentNamespaces.get(n).getNamespaceURI();
        }
        throw new IllegalStateException("This method can only be called on a start element, end element or namespace.");
    }

    @Override
    public String getNamespaceURI(String string) {
        if (this.getEventType() == 1 || this.getEventType() == 2 || this.getEventType() == 13) {
            return this.currentStartElement.getNamespaceURI(string);
        }
        throw new IllegalStateException("This method can only be called on a start element, end element or namespace.");
    }

    @Override
    public String getPIData() {
        if (this.getEventType() == 3) {
            return ((ProcessingInstruction)this.currentEvent).getData();
        }
        throw new IllegalStateException("This method can only be called on a processing instruction.");
    }

    @Override
    public String getPITarget() {
        if (this.getEventType() == 3) {
            return ((ProcessingInstruction)this.currentEvent).getTarget();
        }
        throw new IllegalStateException("This method can only be called on a processing instruction.");
    }

    @Override
    public String getPrefix() {
        switch (this.getEventType()) {
            case 1: {
                return this.currentStartElement.getName().getPrefix();
            }
            case 2: {
                return this.currentEvent.asEndElement().getName().getPrefix();
            }
        }
        throw new IllegalStateException("This method can only be called on a start element or an end element.");
    }

    @Override
    public String getText() {
        switch (this.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return this.currentEvent.asCharacters().getData();
            }
            case 5: {
                return ((Comment)this.currentEvent).getText();
            }
            case 9: {
                return ((EntityReference)this.currentEvent).getDeclaration().getReplacementText();
            }
            case 11: {
                return ((DTD)this.currentEvent).getDocumentTypeDeclaration();
            }
        }
        throw new IllegalStateException("This method can only be called on an element containing text (characters, cData, space, comment, entity reference or document type declaration).");
    }

    @Override
    public char[] getTextCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return this.currentEvent.asCharacters().getData().toCharArray();
            }
            case 5: {
                return ((Comment)this.currentEvent).getText().toCharArray();
            }
        }
        throw new IllegalStateException("This method can only be called on an element containing text (characters, cData, space, comment).");
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                System.arraycopy(this.getTextCharacters(), n, cArray, n2, n3);
                return n3;
            }
        }
        throw new IllegalStateException("This method can only be called on an element containing text (characters, cData, space, comment).");
    }

    @Override
    public int getTextLength() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return this.getText().length();
            }
        }
        throw new IllegalStateException("This method can only be called on an element containing text (characters, cData, space, comment).");
    }

    @Override
    public int getTextStart() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return 0;
            }
        }
        throw new IllegalStateException("This method can only be called on an element containing text (characters, cData, space, comment).");
    }

    @Override
    public String getVersion() {
        if (this.getEventType() == 7) {
            return this.getStreamDataProvider().getStartDocumentEvent().getVersion();
        }
        throw new IllegalStateException("This method can only be called on a start document event.");
    }

    @Override
    public boolean hasName() {
        switch (this.getEventType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        if (this.getEventType() == 1 || this.getEventType() == 10) {
            return this.currentAttributes.get(n).isSpecified();
        }
        throw new IllegalStateException("This method can only be called on a start element or attribute.");
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isStandalone() {
        if (this.getEventType() == 7) {
            return this.getStreamDataProvider().getStartDocumentEvent().isStandalone();
        }
        throw new IllegalStateException("This method can only be called on a start document event.");
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.getEventType() == 4 && this.getText().trim().isEmpty();
    }

    @Override
    public int next() throws XMLStreamException {
        XMLEvent xMLEvent = null;
        if (!this.isEndReached()) {
            if (this.getJPhyloIOEventReader().getPreviousEvent().getType().equals(new EventType(EventContentType.LITERAL_META, EventTopologyType.START)) && !this.isStartDocumentFired()) {
                xMLEvent = this.getEventFactory().createStartDocument();
                this.setStartDocumentFired(true);
            } else {
                try {
                    xMLEvent = this.obtainXMLContentEvent(this.getJPhyloIOEventReader().next());
                }
                catch (IOException iOException) {
                    if (iOException.getCause() != null) {
                        throw new XMLStreamException(iOException.getCause());
                    }
                    throw new XMLStreamException("No XML event could be obtained from the underlying reader.");
                }
            }
        } else if (!this.isEndDocumentFired()) {
            xMLEvent = this.getEventFactory().createEndDocument();
            this.setEndDocumentFired(true);
        } else {
            throw new NoSuchElementException("The end of this XML metadata stream was already reached.");
        }
        this.currentEvent = xMLEvent;
        this.evaluateStartElement(xMLEvent);
        return xMLEvent.getEventType();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("An element that could not be skipped was encountered before the next start or end element.");
        }
        return n;
    }

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this.getEventType()) {
            throw new XMLStreamException("The specified event type did not match the type of the current event.");
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("The specified namespace URI did not match the namespace URI of the current event.");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("The specified local name did not match the local name of the current event.");
        }
    }

    @Override
    public boolean standaloneSet() {
        if (this.getEventType() == 7) {
            return this.getStreamDataProvider().getStartDocumentEvent().standaloneSet();
        }
        throw new IllegalStateException("This method can only be called on a start document event.");
    }

    private void evaluateStartElement(XMLEvent xMLEvent) {
        int n = xMLEvent.getEventType();
        switch (n) {
            case 1: {
                this.currentStartElement = xMLEvent.asStartElement();
                this.currentAttributes.clear();
                this.currentNamespaces.clear();
                Iterator<Attribute> iterator = this.currentStartElement.getAttributes();
                while (iterator.hasNext()) {
                    this.currentAttributes.add(iterator.next());
                }
                Iterator<Namespace> iterator2 = this.currentStartElement.getNamespaces();
                while (iterator2.hasNext()) {
                    this.currentNamespaces.add(iterator2.next());
                }
                break;
            }
            case 10: {
                this.currentAttributes.add((Attribute)xMLEvent);
                break;
            }
            case 13: {
                this.currentNamespaces.add((Namespace)xMLEvent);
                break;
            }
        }
    }
}

