/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.stax;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.events.type.EventType;
import info.bioinfweb.jphyloio.formats.xml.JPhyloIOXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.push.JPhyloIOEventListener;
import java.io.IOException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractMetaXMLReader {
    private XMLReaderStreamDataProvider<?> streamDataProvider;
    private MetaEventListener listener = new MetaEventListener();
    private XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private boolean endReached = false;
    private boolean startDocumentFired;
    private boolean endDocumentFired;

    public AbstractMetaXMLReader(XMLReaderStreamDataProvider<?> xMLReaderStreamDataProvider) {
        this.streamDataProvider = xMLReaderStreamDataProvider;
        this.getJPhyloIOEventReader().addEventListener(this.listener);
    }

    protected void setEndReached() {
        this.endReached = true;
        this.getJPhyloIOEventReader().removeEventListener(this.listener);
    }

    protected JPhyloIOXMLEventReader getJPhyloIOEventReader() {
        return (JPhyloIOXMLEventReader)this.streamDataProvider.getEventReader();
    }

    protected XMLReaderStreamDataProvider<?> getStreamDataProvider() {
        return this.streamDataProvider;
    }

    protected XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    protected boolean isEndReached() {
        return this.endReached;
    }

    protected boolean isStartDocumentFired() {
        return this.startDocumentFired;
    }

    protected void setStartDocumentFired(boolean bl) {
        this.startDocumentFired = bl;
    }

    protected boolean isEndDocumentFired() {
        return this.endDocumentFired;
    }

    protected void setEndDocumentFired(boolean bl) {
        this.endDocumentFired = bl;
    }

    public void close() throws XMLStreamException {
    }

    public boolean hasNext() {
        return !this.isEndDocumentFired();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.streamDataProvider.getXMLReader().getProperty(string);
    }

    protected XMLEvent obtainXMLContentEvent(JPhyloIOEvent jPhyloIOEvent) throws XMLStreamException {
        XMLEvent xMLEvent;
        switch (jPhyloIOEvent.getType().getContentType()) {
            case COMMENT: {
                xMLEvent = this.getEventFactory().createComment(jPhyloIOEvent.asCommentEvent().getContent());
                break;
            }
            case LITERAL_META_CONTENT: {
                LiteralMetadataContentEvent literalMetadataContentEvent = jPhyloIOEvent.asLiteralMetadataContentEvent();
                if (literalMetadataContentEvent.hasXMLEventValue()) {
                    xMLEvent = literalMetadataContentEvent.getXMLEvent();
                    break;
                }
                throw new XMLStreamException("No XML event could be obtained from the current metadata content event.");
            }
            default: {
                throw new XMLStreamException("An event with the unexpected content type \"" + (Object)((Object)jPhyloIOEvent.getType().getContentType()) + "\" was encountered in the literal meta subsequence.");
            }
        }
        return xMLEvent;
    }

    private class MetaEventListener
    implements JPhyloIOEventListener {
        private MetaEventListener() {
        }

        @Override
        public void processEvent(JPhyloIOEventReader jPhyloIOEventReader, JPhyloIOEvent jPhyloIOEvent) throws IOException {
            if (jPhyloIOEventReader.peek().getType().equals(new EventType(EventContentType.LITERAL_META, EventTopologyType.END))) {
                AbstractMetaXMLReader.this.setEndReached();
            }
        }
    }
}

