/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml.elementreaders;

import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.xml.AbstractXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.AttributeInfo;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLElementReader;
import info.bioinfweb.jphyloio.formats.xtg.XTGConstants;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.awt.Color;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;

public abstract class AbstractXMLElementReader<P extends XMLReaderStreamDataProvider<? extends AbstractXMLEventReader<P>>>
implements XMLElementReader<P> {
    protected void readAttributes(P p, StartElement startElement, String string, AttributeInfo ... attributeInfoArray) throws JPhyloIOReaderException {
        LinkedHashMap<QName, AttributeInfo> linkedHashMap = new LinkedHashMap<QName, AttributeInfo>();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            linkedHashMap.put(attributeInfoArray[i].getAttributeName(), attributeInfoArray[i]);
        }
        this.readAttributes(p, startElement, string, linkedHashMap);
    }

    protected void readAttributes(P p, StartElement startElement, String string, LinkedHashMap<QName, AttributeInfo> linkedHashMap) throws JPhyloIOReaderException {
        if (linkedHashMap != null && !linkedHashMap.isEmpty()) {
            String string2 = string + "meta";
            for (QName qName : linkedHashMap.keySet()) {
                if (startElement.getAttributeByName(qName) == null) continue;
                String string3 = startElement.getAttributeByName(qName).getValue();
                QName qName2 = linkedHashMap.get(qName).getDatatype();
                Color color = null;
                if (qName2 != null) {
                    ObjectTranslator<?> objectTranslator = ((ReaderStreamDataProvider)p).getParameters().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(qName2);
                    if (objectTranslator != null) {
                        try {
                            color = (Color)objectTranslator.representationToJava(string3, (ReaderStreamDataProvider<?>)p);
                        }
                        catch (InvalidObjectSourceDataException invalidObjectSourceDataException) {
                            throw new JPhyloIOReaderException("The content of the XML attribute \"" + qName + "\" (\"" + string3 + "\") could not be parsed as class " + objectTranslator.getObjectClass().getSimpleName() + ".", startElement.getLocation());
                        }
                    }
                    if (qName2.equals(XTGConstants.DATA_TYPE_COLOR)) {
                        try {
                            color = Color.decode(string3);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                ((ReaderStreamDataProvider)p).getCurrentEventCollection().add(new LiteralMetadataEvent(string2 + ((ReaderStreamDataProvider)p).getIDManager().createNewID(), null, new URIOrStringIdentifier(null, linkedHashMap.get(qName).getPredicate()), new URIOrStringIdentifier(null, linkedHashMap.get(qName).getDatatype()), LiteralContentSequenceType.SIMPLE));
                if (string3 != null) {
                    ((ReaderStreamDataProvider)p).getCurrentEventCollection().add(new LiteralMetadataContentEvent(color, string3));
                }
                ((ReaderStreamDataProvider)p).getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
            }
        }
    }
}

