/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.formats.xml.XMLWriterStreamDataProvider;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLReadWriteUtils {
    public static final String XSI_DEFAULT_PRE = "xsi";
    public static final String XSD_DEFAULT_PRE = "xsd";
    public static final String RDF_DEFAULT_PRE = "rdf";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String NAMESPACE_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns";
    public static final String DEFAULT_NAMESPACE_PREFIX = "p";

    public static String getXSIPrefix(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
        if (string == null || string.isEmpty()) {
            string = XSI_DEFAULT_PRE;
        }
        return string;
    }

    public static String getXSDPrefix(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix("http://www.w3.org/2001/XMLSchema");
        if (string == null || string.isEmpty()) {
            string = XSD_DEFAULT_PRE;
        }
        return string;
    }

    public static String getDefaultNamespacePrefix(XMLStreamWriter xMLStreamWriter, String string, String string2) throws XMLStreamException {
        String string3 = string;
        if (string2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            string3 = XSI_DEFAULT_PRE;
        } else if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
            string3 = XSD_DEFAULT_PRE;
        } else if (string2.equals(NAMESPACE_RDF)) {
            string3 = RDF_DEFAULT_PRE;
        } else if (string2.equals("http://www.nexml.org/2009")) {
            string3 = "nex";
        } else if (string2.equals("http://www.phyloxml.org")) {
            string3 = "phy";
        } else if (string2.equals("http://bioinfweb.info/xmlns/JPhyloIO/General/Predicates/")) {
            string3 = "jpp";
        } else if (string2.equals("http://bioinfweb.info/xmlns/JPhyloIO/General/Attributes/")) {
            string3 = "jpa";
        } else if (string3 == null || string3.isEmpty()) {
            string3 = DEFAULT_NAMESPACE_PREFIX;
        }
        return string3;
    }

    public static void writeCustomXML(XMLStreamWriter xMLStreamWriter, ReadWriteParameterMap readWriteParameterMap, XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 1: {
                StartElement startElement = xMLEvent.asStartElement();
                boolean bl = readWriteParameterMap.getBoolean("info.bioinfweb.jphyloio.customXMLNamespaceHandling", false);
                String string = XMLReadWriteUtils.obtainCustomXMLPrefix(xMLStreamWriter, startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), bl);
                if (string == null || string.isEmpty()) {
                    if (startElement.getName().getNamespaceURI() == null || startElement.getName().getNamespaceURI().isEmpty()) {
                        xMLStreamWriter.writeStartElement(startElement.getName().getLocalPart());
                    } else {
                        xMLStreamWriter.writeStartElement(startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart());
                    }
                } else {
                    xMLStreamWriter.writeStartElement(string, startElement.getName().getLocalPart(), startElement.getName().getNamespaceURI());
                }
                Iterator<Attribute> iterator = startElement.getAttributes();
                while (iterator.hasNext()) {
                    XMLReadWriteUtils.writeAttribute(xMLStreamWriter, iterator.next());
                }
                Iterator<Namespace> iterator2 = startElement.getNamespaces();
                while (iterator2.hasNext()) {
                    Namespace namespace = iterator2.next();
                    if (namespace.getPrefix().equals("")) {
                        xMLStreamWriter.writeDefaultNamespace(namespace.getNamespaceURI());
                        continue;
                    }
                    if (bl) continue;
                    xMLStreamWriter.writeNamespace(XMLReadWriteUtils.obtainCustomXMLPrefix(xMLStreamWriter, namespace.getPrefix(), namespace.getNamespaceURI(), bl), namespace.getNamespaceURI());
                }
                break;
            }
            case 2: {
                xMLStreamWriter.writeEndElement();
                break;
            }
            case 4: 
            case 6: {
                xMLStreamWriter.writeCharacters(xMLEvent.asCharacters().getData());
                break;
            }
            case 12: {
                xMLStreamWriter.writeCData(xMLEvent.asCharacters().getData());
                break;
            }
            case 10: {
                XMLReadWriteUtils.writeAttribute(xMLStreamWriter, (Attribute)xMLEvent);
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                if (!namespace.getPrefix().equals("") && readWriteParameterMap.getBoolean("info.bioinfweb.jphyloio.customXMLNamespaceHandling", false)) break;
                xMLStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                if (processingInstruction.getData() == null) {
                    xMLStreamWriter.writeProcessingInstruction(processingInstruction.getTarget());
                    break;
                }
                xMLStreamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 5: {
                xMLStreamWriter.writeComment(((Comment)xMLEvent).getText());
                break;
            }
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A document type declaration (DTD) with the content \"");
                if (((DTD)xMLEvent).getDocumentTypeDeclaration().length() > 128) {
                    stringBuffer.append(((DTD)xMLEvent).getDocumentTypeDeclaration().substring(0, 128));
                    stringBuffer.append(" [...]");
                } else {
                    stringBuffer.append(((DTD)xMLEvent).getDocumentTypeDeclaration());
                }
                stringBuffer.append("\" was found but can not be written at this position of the document.");
                readWriteParameterMap.getLogger().addWarning(stringBuffer.toString());
                break;
            }
            case 14: {
                readWriteParameterMap.getLogger().addWarning("A notation declaration with the name \"" + ((NotationDeclaration)xMLEvent).getName() + "\" was found butcan not be written at this position of the document.");
                break;
            }
            case 15: {
                readWriteParameterMap.getLogger().addWarning("An entity declaration with the name \"" + ((EntityDeclaration)xMLEvent).getName() + "\" was found butcan not be written at this position of the document.");
                break;
            }
            case 9: {
                xMLStreamWriter.writeEntityRef(((EntityReference)xMLEvent).getName());
                break;
            }
        }
    }

    private static String obtainCustomXMLPrefix(XMLStreamWriter xMLStreamWriter, String string, String string2, boolean bl) throws XMLStreamException {
        if (bl) {
            return xMLStreamWriter.getPrefix(string2);
        }
        return string;
    }

    private static void writeAttribute(XMLStreamWriter xMLStreamWriter, Attribute attribute) throws XMLStreamException {
        String string = xMLStreamWriter.getPrefix(attribute.getName().getNamespaceURI());
        if (string == null || string.isEmpty()) {
            if (attribute.getName().getNamespaceURI() == null || attribute.getName().getNamespaceURI().isEmpty()) {
                xMLStreamWriter.writeAttribute(attribute.getName().getLocalPart(), attribute.getValue());
            } else {
                xMLStreamWriter.writeAttribute(attribute.getName().getNamespaceURI(), attribute.getName().getLocalPart(), attribute.getValue());
            }
        } else {
            xMLStreamWriter.writeAttribute(xMLStreamWriter.getPrefix(attribute.getName().getNamespaceURI()), attribute.getName().getNamespaceURI(), attribute.getName().getLocalPart(), attribute.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void manageLiteralContentMetaNamespaces(XMLWriterStreamDataProvider xMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, LiteralMetadataContentEvent literalMetadataContentEvent) throws XMLStreamException {
        if (literalMetadataContentEvent.hasXMLEventValue()) {
            if (!readWriteParameterMap.getBoolean("info.bioinfweb.jphyloio.customXMLNamespaceHandling", false)) return;
            switch (literalMetadataContentEvent.getXMLEvent().getEventType()) {
                case 1: {
                    Object object;
                    StartElement startElement = literalMetadataContentEvent.getXMLEvent().asStartElement();
                    QName qName = startElement.getName();
                    xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        qName = object.getName();
                        xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
                    }
                    object = startElement.getNamespaces();
                    while (object.hasNext()) {
                        Namespace namespace = (Namespace)object.next();
                        if (namespace.getPrefix().equals("")) continue;
                        xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), namespace.getPrefix(), namespace.getNamespaceURI()), namespace.getNamespaceURI());
                    }
                    return;
                }
                case 10: {
                    Attribute attribute = (Attribute)literalMetadataContentEvent.getXMLEvent();
                    QName qName = attribute.getName();
                    xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
                    return;
                }
                case 13: {
                    Namespace namespace = (Namespace)literalMetadataContentEvent.getXMLEvent();
                    if (namespace.getPrefix().equals("")) return;
                    xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), namespace.getPrefix(), namespace.getNamespaceURI()), namespace.getNamespaceURI());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (!literalMetadataContentEvent.hasObjectValue() || !(literalMetadataContentEvent.getObjectValue() instanceof QName)) return;
        QName qName = (QName)literalMetadataContentEvent.getObjectValue();
        xMLWriterStreamDataProvider.setNamespacePrefix(XMLReadWriteUtils.getDefaultNamespacePrefix(xMLWriterStreamDataProvider.getWriter(), qName.getPrefix(), qName.getNamespaceURI()), qName.getNamespaceURI());
    }
}

