/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.xml;

import info.bioinfweb.jphyloio.AbstractEventReader;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.xml.JPhyloIOXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.XMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLElementReader;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLElementReaderKey;
import info.bioinfweb.jphyloio.formats.xml.stax.MetaXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.stax.MetaXMLStreamReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.semanticweb.owlapi.io.XMLUtils;

public abstract class AbstractXMLEventReader<P extends XMLReaderStreamDataProvider<? extends AbstractXMLEventReader<P>>>
extends AbstractEventReader<P>
implements JPhyloIOXMLEventReader {
    public static final String INTERNAL_USE_NAMESPACE = "http://bioinfweb.info/xmlns/JPhyloIO/internalUse";
    public static final QName TAG_PARENT_OF_ROOT = new QName("http://bioinfweb.info/xmlns/JPhyloIO/internalUse", "root");
    private Map<XMLElementReaderKey, XMLElementReader<P>> elementReaderMap = new HashMap<XMLElementReaderKey, XMLElementReader<P>>();
    private XMLEventReader xmlReader;
    private Stack<QName> encounteredTags = new Stack();
    private NamespaceContext namespaceContext = null;

    public AbstractXMLEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        this(new FileReader(file), readWriteParameterMap);
    }

    public AbstractXMLEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        this(new InputStreamReader(inputStream), readWriteParameterMap);
    }

    public AbstractXMLEventReader(XMLEventReader xMLEventReader, ReadWriteParameterMap readWriteParameterMap) {
        super(readWriteParameterMap, Character.toString('.'));
        this.xmlReader = xMLEventReader;
        this.fillMap();
    }

    public AbstractXMLEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        super(readWriteParameterMap, Character.toString('.'));
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.xmlReader = XMLInputFactory.newInstance().createXMLEventReader(reader);
        this.fillMap();
    }

    protected boolean isAllowDefaultNamespace() {
        return this.getParameters().getBoolean("info.bioinfweb.jphyloio.allowDefaultNamespace", true);
    }

    protected void putElementReader(XMLElementReaderKey xMLElementReaderKey, XMLElementReader<P> xMLElementReader) {
        this.elementReaderMap.put(xMLElementReaderKey, xMLElementReader);
        if (this.isAllowDefaultNamespace()) {
            QName qName = null;
            if (xMLElementReaderKey.getParentTag() != null) {
                qName = new QName(xMLElementReaderKey.getParentTag().getLocalPart());
            }
            QName qName2 = null;
            if (xMLElementReaderKey.getTagName() != null) {
                qName2 = new QName(xMLElementReaderKey.getTagName().getLocalPart());
            }
            this.elementReaderMap.put(new XMLElementReaderKey(qName, qName2, xMLElementReaderKey.getXmlEventType()), xMLElementReader);
        }
    }

    protected abstract void fillMap();

    @Override
    protected void readNextEvent() throws IOException {
        try {
            while (this.getXMLReader().hasNext() && this.getUpcomingEvents().isEmpty()) {
                Object object;
                XMLEvent xMLEvent = this.getXMLReader().nextEvent();
                QName qName = null;
                QName qName2 = null;
                switch (xMLEvent.getEventType()) {
                    case 7: {
                        qName2 = null;
                        break;
                    }
                    case 8: {
                        qName2 = null;
                        break;
                    }
                    case 1: {
                        object = xMLEvent.asStartElement();
                        qName2 = object.getName();
                        this.namespaceContext = object.getNamespaceContext();
                        break;
                    }
                    case 2: {
                        this.getEncounteredTags().pop();
                        qName2 = xMLEvent.asEndElement().getName();
                        break;
                    }
                }
                qName = !this.getEncounteredTags().isEmpty() ? this.getEncounteredTags().peek() : TAG_PARENT_OF_ROOT;
                if (xMLEvent.isStartElement()) {
                    ((XMLReaderStreamDataProvider)this.getStreamDataProvider()).setParentName(qName.getLocalPart());
                    ((XMLReaderStreamDataProvider)this.getStreamDataProvider()).setElementName(qName2.getLocalPart());
                }
                if ((object = this.getElementReader(qName, qName2, xMLEvent.getEventType())) != null) {
                    object.readEvent((XMLReaderStreamDataProvider)this.getStreamDataProvider(), xMLEvent);
                }
                if (!xMLEvent.isStartElement()) continue;
                this.getEncounteredTags().push(qName2);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JPhyloIOReaderException("The underlying XML reader threw an exception, when trying to read the next event.", xMLStreamException);
        }
    }

    protected XMLElementReader<P> getElementReader(QName qName, QName qName2, int n) {
        XMLElementReader<P> xMLElementReader = this.elementReaderMap.get(new XMLElementReaderKey(qName, qName2, n));
        if (xMLElementReader == null && (xMLElementReader = this.elementReaderMap.get(new XMLElementReaderKey(null, qName2, n))) == null && (xMLElementReader = this.elementReaderMap.get(new XMLElementReaderKey(qName, null, n))) == null) {
            xMLElementReader = this.elementReaderMap.get(new XMLElementReaderKey(null, null, n));
        }
        return xMLElementReader;
    }

    public QName parseQName(String string, StartElement startElement) throws JPhyloIOReaderException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        QName qName = null;
        if (string != null) {
            if (string.contains(":")) {
                string2 = string.substring(0, string.indexOf(":"));
                string3 = string.substring(string.indexOf(":") + 1);
                if (!XMLUtils.isNCName((CharSequence)string2)) {
                    string2 = null;
                }
                if ((string4 = startElement.getNamespaceContext().getNamespaceURI(string2)) == null) {
                    if (string2.equals("xsd")) {
                        string4 = "http://www.w3.org/2001/XMLSchema";
                    } else {
                        string2 = null;
                    }
                }
            }
            qName = string2 == null ? new QName(startElement.getNamespaceContext().getNamespaceURI(""), string) : new QName(string4, string3, string2);
        }
        return qName;
    }

    @Override
    protected P createStreamDataProvider() {
        return (P)new XMLReaderStreamDataProvider<AbstractXMLEventReader>(this);
    }

    public XMLEventReader getXMLReader() {
        return this.xmlReader;
    }

    protected Stack<QName> getEncounteredTags() {
        return this.encounteredTags;
    }

    protected Map<XMLElementReaderKey, XMLElementReader<P>> getElementReaderMap() {
        return this.elementReaderMap;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public MetaXMLEventReader createMetaXMLEventReader() throws IllegalStateException {
        if (this.getPreviousEvent().getType().getContentType().equals((Object)EventContentType.LITERAL_META) && this.getPreviousEvent().asLiteralMetadataEvent().getSequenceType().equals((Object)LiteralContentSequenceType.XML) || this.getParentInformation().getDirectParentContentType().equals((Object)EventContentType.LITERAL_META) && this.getParentInformation().getDirectParent().asLiteralMetadataEvent().getSequenceType().equals((Object)LiteralContentSequenceType.XML)) {
            return new MetaXMLEventReader((XMLReaderStreamDataProvider)this.getStreamDataProvider());
        }
        throw new IllegalStateException("An instance of MetaXMLEventReader can only be created while this instance is located inside a literal metadata subsequence with the sequence type XML.");
    }

    @Override
    public MetaXMLStreamReader createMetaXMLStreamReader() throws IllegalStateException {
        if (this.getPreviousEvent().getType().getContentType().equals((Object)EventContentType.LITERAL_META) && this.getPreviousEvent().asLiteralMetadataEvent().getSequenceType().equals((Object)LiteralContentSequenceType.XML) || this.getParentInformation().getDirectParentContentType().equals((Object)EventContentType.LITERAL_META) && this.getParentInformation().getDirectParent().asLiteralMetadataEvent().getSequenceType().equals((Object)LiteralContentSequenceType.XML)) {
            return new MetaXMLStreamReader((XMLReaderStreamDataProvider)this.getStreamDataProvider());
        }
        throw new IllegalStateException("An instance of MetaXMLEventReader can only be created while this instance is located inside a literal metadata subsequence with the sequence type XML.");
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.getXMLReader().close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JPhyloIOReaderException("The underlying XML reader throw an exception, when trying to close it.", xMLStreamException);
        }
    }
}

