/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.text;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.AbstractEventReader;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractTextEventReader<P extends TextReaderStreamDataProvider<? extends AbstractTextEventReader<P>>>
extends AbstractEventReader<P> {
    private PeekReader reader;
    protected boolean lineConsumed = true;

    public AbstractTextEventReader(PeekReader peekReader, ReadWriteParameterMap readWriteParameterMap, String string) {
        super(readWriteParameterMap, string);
        this.reader = peekReader;
    }

    public AbstractTextEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap, String string) throws IOException {
        super(readWriteParameterMap, string);
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.reader = new PeekReader(reader);
    }

    public AbstractTextEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap, String string) throws IOException {
        this(new InputStreamReader(inputStream), readWriteParameterMap, string);
    }

    public AbstractTextEventReader(File file, ReadWriteParameterMap readWriteParameterMap, String string) throws IOException {
        this(new FileReader(file), readWriteParameterMap, string);
    }

    @Override
    protected P createStreamDataProvider() {
        return (P)new TextReaderStreamDataProvider<AbstractTextEventReader>(this);
    }

    protected List<String> createTokenList(CharSequence charSequence) {
        ArrayList<String> arrayList = new ArrayList<String>(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            arrayList.add(Character.toString(c));
        }
        return arrayList;
    }

    protected void consumeWhiteSpaceAndComments(char c, char c2) throws IOException {
        int n = this.getReader().peek();
        while (n != -1 && (Character.isWhitespace(n) || (char)n == c)) {
            if ((char)n == c) {
                this.getReader().skip(1L);
                this.readComment(c, c2);
            } else {
                this.getReader().skip(1L);
            }
            n = this.getReader().peek();
        }
    }

    protected void readComment(char c, char c2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        try {
            char c3 = this.getReader().readChar();
            int n2 = 0;
            int n3 = this.getParameters().getMaxCommentLength();
            while (n != 0 || c3 != c2) {
                if (c3 == c) {
                    ++n;
                } else if (c3 == c2) {
                    --n;
                }
                stringBuilder.append(c3);
                if (++n2 >= n3) {
                    c3 = this.getReader().peekChar();
                    this.getCurrentEventCollection().add(new CommentEvent(stringBuilder.toString(), c3 == '\uffffffff' || c3 != c2));
                    stringBuilder.delete(0, stringBuilder.length());
                    n2 = 0;
                }
                c3 = this.getReader().readChar();
            }
            if (stringBuilder.length() > 0) {
                this.getCurrentEventCollection().add(new CommentEvent(stringBuilder.toString(), false));
            }
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file inside a comment.", (StreamLocationProvider)this.getReader());
        }
    }

    private JPhyloIOEvent eventFromCharacters(String string, CharSequence charSequence) throws IOException {
        List<String> list = this.createTokenList(charSequence);
        if (list.isEmpty()) {
            return null;
        }
        return this.getSequenceTokensEventManager().createEvent(string, list);
    }

    protected JPhyloIOEvent readCharacters(String string) throws IOException {
        PeekReader.ReadResult readResult = this.getReader().readLine(this.getParameters().getMaxTokensToRead());
        this.lineConsumed = readResult.isCompletelyRead();
        return this.eventFromCharacters(string, readResult.getSequence());
    }

    protected JPhyloIOEvent readCharacters(String string, char c, char c2) throws IOException {
        Pattern pattern = Pattern.compile(".*(\\n|\\r|\\" + c + ")");
        PeekReader.ReadResult readResult = this.getReader().readRegExp(this.getParameters().getMaxTokensToRead(), pattern, false);
        char c3 = StringUtils.lastChar((CharSequence)readResult.getSequence());
        JPhyloIOEvent jPhyloIOEvent = this.eventFromCharacters(string, StringUtils.cutEnd((CharSequence)readResult.getSequence(), (int)1));
        if (jPhyloIOEvent != null) {
            this.getCurrentEventCollection().add(jPhyloIOEvent);
        }
        if (c3 == c) {
            this.readComment(c, c2);
        } else if (StringUtils.isNewLineChar((char)c3)) {
            int n = this.getReader().peek();
            if (n != -1 && c3 == '\r' && (char)n == '\n') {
                this.getReader().skip(1L);
            }
            this.lineConsumed = true;
        } else {
            this.lineConsumed = false;
        }
        return jPhyloIOEvent;
    }

    protected String readToken(char c, char c2, char c3, char c4) throws IOException {
        PeekReader peekReader = this.getReader();
        StringBuilder stringBuilder = new StringBuilder();
        char c5 = peekReader.peekChar();
        while (!Character.isWhitespace(c5) && c5 != c && c5 != c4) {
            if (c5 == c2) {
                peekReader.skip(1L);
                this.readComment(c2, c3);
            } else {
                stringBuilder.append(c5);
                peekReader.skip(1L);
            }
            c5 = peekReader.peekChar();
        }
        return stringBuilder.toString();
    }

    protected KeyValueInformation readKeyValueInformation(char c, char c2, char c3, char c4) throws IOException {
        PeekReader peekReader = this.getReader();
        String string = this.readToken(c, c2, c3, c4).toLowerCase();
        this.consumeWhiteSpaceAndComments(c2, c3);
        String string2 = "";
        char c5 = ' ';
        if (peekReader.peekChar() == c4) {
            peekReader.skip(1L);
            this.consumeWhiteSpaceAndComments(c2, c3);
            char c6 = peekReader.peekChar();
            if (c6 == '\'') {
                c5 = '\'';
            } else if (c6 == '\"') {
                c5 = '\"';
            }
            if (c5 != ' ') {
                peekReader.skip(1L);
                string2 = peekReader.readUntil(Character.toString(c5)).getSequence().toString();
            } else {
                string2 = this.readToken(c, c2, c3, c4);
            }
            this.consumeWhiteSpaceAndComments(c2, c3);
        }
        return new KeyValueInformation(string, string2, c5);
    }

    protected PeekReader getReader() {
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }
}

