/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.receivers;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLColorTranslator;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLPredicateInfo;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLPredicateTreatment;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLPrivateConstants;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PropertyOwner;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLMetaDataReceiver;
import info.bioinfweb.jphyloio.objecttranslation.ObjectTranslator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class PhyloXMLSpecificPredicatesDataReceiver
extends PhyloXMLMetaDataReceiver {
    private Stack<QName> predicates = new Stack();
    private Stack<Integer> childIndices = new Stack();
    private QName currentDatatype;
    private boolean writeAppliesTo = false;
    private boolean writeElement = true;

    public PhyloXMLSpecificPredicatesDataReceiver(PhyloXMLWriterStreamDataProvider phyloXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, PropertyOwner propertyOwner, QName qName) {
        super(phyloXMLWriterStreamDataProvider, readWriteParameterMap, propertyOwner);
        this.predicates.push(qName);
        this.childIndices.push(0);
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().contains(literalMetadataEvent.getID()) && this.writeElement) {
            int n = 0;
            this.writeElement = true;
            PhyloXMLPredicateInfo phyloXMLPredicateInfo = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(literalMetadataEvent.getPredicate().getURI());
            if (literalMetadataEvent.getPredicate().getURI() != null) {
                if (literalMetadataEvent.getPredicate().getURI().getNamespaceURI().equals("http://bioinfweb.info/xmlns/JPhyloIO/PhyloXML/Predicates/") && !Arrays.asList(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getAllowedChildren()).contains(literalMetadataEvent.getPredicate().getURI())) {
                    throw new InconsistentAdapterDataException("The element \"" + literalMetadataEvent.getPredicate().getURI().getLocalPart() + "\" is not allowed to occur under the element \"" + this.predicates.peek().getLocalPart() + "\".");
                }
                block3: for (QName qName : ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getAllowedChildren()) {
                    boolean bl;
                    ++n;
                    if (!qName.equals(literalMetadataEvent.getPredicate().getURI()) && (!qName.equals(PhyloXMLPrivateConstants.IDENTIFIER_CUSTOM_XML) && !qName.equals(PhyloXMLPrivateConstants.IDENTIFIER_ANY_PREDICATE) || phyloXMLPredicateInfo != null)) continue;
                    boolean bl2 = phyloXMLPredicateInfo != null && phyloXMLPredicateInfo.getTreatment().equals((Object)PhyloXMLPredicateTreatment.ATTRIBUTE) && n > this.childIndices.peek();
                    boolean bl3 = phyloXMLPredicateInfo != null && phyloXMLPredicateInfo.getTreatment().equals((Object)PhyloXMLPredicateTreatment.VALUE) && n > this.childIndices.peek();
                    boolean bl4 = phyloXMLPredicateInfo != null && !phyloXMLPredicateInfo.getTreatment().equals((Object)PhyloXMLPredicateTreatment.ATTRIBUTE) && !phyloXMLPredicateInfo.getTreatment().equals((Object)PhyloXMLPredicateTreatment.VALUE) && n >= this.childIndices.peek();
                    boolean bl5 = bl = phyloXMLPredicateInfo == null && n >= this.childIndices.peek();
                    if (bl2 || bl3 || bl4 || bl) {
                        this.childIndices.pop();
                        this.childIndices.push(n);
                        if (phyloXMLPredicateInfo != null) {
                            this.predicates.push(literalMetadataEvent.getPredicate().getURI());
                            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
                            switch (phyloXMLPredicateInfo.getTreatment()) {
                                case TAG_AND_VALUE: {
                                    QName qName2 = phyloXMLPredicateInfo.getTranslation();
                                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(qName2.getNamespaceURI(), qName2.getLocalPart());
                                    if (literalMetadataEvent.getOriginalType() == null) continue block3;
                                    this.currentDatatype = literalMetadataEvent.getOriginalType().getURI();
                                    break;
                                }
                            }
                            continue;
                        }
                        if (qName.equals(PhyloXMLPrivateConstants.IDENTIFIER_CUSTOM_XML)) {
                            this.predicates.push(PhyloXMLPrivateConstants.IDENTIFIER_CUSTOM_XML);
                            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
                            continue;
                        }
                        if (!qName.equals(PhyloXMLPrivateConstants.IDENTIFIER_ANY_PREDICATE) || this.predicates.peek().equals(PhyloXMLPrivateConstants.IDENTIFIER_NODE)) continue;
                        this.predicates.push(PhyloXMLPrivateConstants.IDENTIFIER_ANY_PREDICATE);
                        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
                        this.writeAppliesTo = true;
                        if (literalMetadataEvent.getOriginalType() != null) {
                            this.currentDatatype = literalMetadataEvent.getOriginalType().getURI();
                        }
                        if (this.predicates.peek().equals(PREDICATE_ANNOTATION)) {
                            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_PROPERTY.getLocalPart());
                        }
                        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_REF.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().getPrefix(literalMetadataEvent.getPredicate().getURI().getNamespaceURI()) + ":" + literalMetadataEvent.getPredicate().getURI().getLocalPart());
                        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_DATATYPE.getLocalPart(), "xsd:" + literalMetadataEvent.getOriginalType().getURI().getLocalPart());
                        continue;
                    }
                    throw new InconsistentAdapterDataException("Metaevents with PhyloXML-specific predicates must be given in the correct order. Attributes can only be written once.");
                }
            }
        } else {
            this.writeElement = false;
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        if (this.writeElement) {
            switch (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTreatment()) {
                case VALUE: {
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(literalMetadataContentEvent.toString());
                    this.predicates.pop();
                    break;
                }
                case TAG_AND_VALUE: {
                    if (this.writeAppliesTo) {
                        ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_APPLIES_TO.getLocalPart(), this.getPropertyOwner().toString().toLowerCase());
                        this.writeAppliesTo = false;
                    }
                    if (literalMetadataContentEvent.hasObjectValue() && this.predicates.peek().equals(PREDICATE_COLOR)) {
                        PhyloXMLColorTranslator phyloXMLColorTranslator = new PhyloXMLColorTranslator();
                        phyloXMLColorTranslator.writeXMLRepresentation(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter(), literalMetadataContentEvent.getObjectValue(), (WriterStreamDataProvider<?>)this.getStreamDataProvider());
                        break;
                    }
                    ObjectTranslator<?> objectTranslator = this.getParameterMap().getObjectTranslatorFactory().getDefaultTranslatorWithPossiblyInvalidNamespace(this.currentDatatype);
                    String string = this.processLiteralContent(literalMetadataContentEvent, objectTranslator, this.currentDatatype);
                    if (string == null) break;
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(string);
                    break;
                }
                case ATTRIBUTE: {
                    QName qName = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTranslation();
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), literalMetadataContentEvent.toString());
                    this.predicates.pop();
                    if (!qName.equals(ATTR_APPLIES_TO)) break;
                    this.writeAppliesTo = false;
                    break;
                }
                case CUSTOM_XML: {
                    if (!literalMetadataContentEvent.hasXMLEventValue()) break;
                    this.writeCustomXMLTag(literalMetadataContentEvent.getXMLEvent());
                    break;
                }
            }
        }
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().contains(resourceMetadataEvent.getID())) {
            int n = 0;
            this.writeElement = true;
            if (resourceMetadataEvent.getRel().getURI().getNamespaceURI().equals("http://bioinfweb.info/xmlns/JPhyloIO/PhyloXML/Predicates/") && !Arrays.asList(((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getAllowedChildren()).contains(resourceMetadataEvent.getRel().getURI())) {
                throw new InconsistentAdapterDataException("The element \"" + resourceMetadataEvent.getRel().getURI().getLocalPart() + "\" is not allowed to occur under the element \"" + this.predicates.peek().getLocalPart() + "\".");
            }
            for (QName qName : ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getAllowedChildren()) {
                ++n;
                if (!qName.equals(resourceMetadataEvent.getRel().getURI())) continue;
                if (n >= this.childIndices.peek()) {
                    this.childIndices.pop();
                    this.childIndices.push(n);
                    ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(resourceMetadataEvent.getID());
                    this.predicates.push(resourceMetadataEvent.getRel().getURI());
                    this.childIndices.push(-1);
                    switch (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(resourceMetadataEvent.getRel().getURI()).getTreatment()) {
                        case TAG: {
                            QName qName2 = ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(resourceMetadataEvent.getRel().getURI()).getTranslation();
                            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(qName2.getNamespaceURI(), qName2.getLocalPart());
                            break;
                        }
                        case VALUE: {
                            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(resourceMetadataEvent.getHRef().toString());
                            break;
                        }
                    }
                    continue;
                }
                throw new InconsistentAdapterDataException("The metaevent with the predicate \"" + resourceMetadataEvent.getRel().getURI().getLocalPart() + "\" was not nested under the element \"" + this.predicates.peek() + "\" in the correct order.");
            }
        } else {
            this.writeElement = false;
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTreatment().equals((Object)PhyloXMLPredicateTreatment.TAG_AND_VALUE) && jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
            this.predicates.pop();
        } else if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTreatment().equals((Object)PhyloXMLPredicateTreatment.TAG) && jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.RESOURCE_META) && this.predicates.size() > 1) {
            if (!this.predicates.peek().equals(PREDICATE_PROPERTY)) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
            }
            this.predicates.pop();
            this.childIndices.pop();
        } else if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTreatment().equals((Object)PhyloXMLPredicateTreatment.VALUE) && jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.RESOURCE_META) && this.predicates.size() > 1) {
            this.predicates.pop();
            this.childIndices.pop();
        } else if (((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getPredicateInfoMap().get(this.predicates.peek()).getTreatment().equals((Object)PhyloXMLPredicateTreatment.CUSTOM_XML)) {
            this.predicates.pop();
            if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.RESOURCE_META)) {
                this.childIndices.pop();
            }
        }
    }
}

