/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml.receivers;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PropertyOwner;
import info.bioinfweb.jphyloio.formats.phyloxml.receivers.PhyloXMLMetaDataReceiver;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class PhyloXMLPropertyMetadataReceiver
extends PhyloXMLMetaDataReceiver {
    private boolean isProperty = false;
    private QName currentPredicate;
    private QName ref;
    private QName datatype;
    private String appliesTo;
    private String unit;
    private String idRef;
    private String value;

    public PhyloXMLPropertyMetadataReceiver(PhyloXMLWriterStreamDataProvider phyloXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, PropertyOwner propertyOwner) {
        super(phyloXMLWriterStreamDataProvider, readWriteParameterMap, propertyOwner);
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        if (this.isProperty) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(literalMetadataEvent.getID());
            this.currentPredicate = literalMetadataEvent.getPredicate().getURI();
            if (!(this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_APPLIES_TO) || this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_UNIT) || this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_ID_REF))) {
                this.ref = literalMetadataEvent.getPredicate().getURI();
                if (literalMetadataEvent.getOriginalType() != null) {
                    this.datatype = literalMetadataEvent.getOriginalType().getURI();
                } else {
                    throw new InconsistentAdapterDataException("A property element must specify a datatype.");
                }
            }
        }
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        if (this.isProperty) {
            if (this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_APPLIES_TO)) {
                this.appliesTo = literalMetadataContentEvent.getStringValue();
            } else if (this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_UNIT)) {
                this.unit = literalMetadataContentEvent.getStringValue();
            } else if (this.currentPredicate.equals(PREDICATE_PROPERTY_ATTR_ID_REF)) {
                this.idRef = literalMetadataContentEvent.getStringValue();
            } else {
                this.value = literalMetadataContentEvent.getStringValue();
            }
        }
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        if (resourceMetadataEvent.getRel().getURI() != null && resourceMetadataEvent.getRel().getURI().equals(PREDICATE_PROPERTY)) {
            this.isProperty = true;
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getMetaIDs().remove(resourceMetadataEvent.getID());
        }
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        if (jPhyloIOEvent.getType().getContentType().equals((Object)EventContentType.RESOURCE_META) && this.isProperty && this.ref != null && this.datatype != null) {
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeStartElement(TAG_PROPERTY.getLocalPart());
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_REF.getLocalPart(), ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().getPrefix(this.ref.getNamespaceURI()) + ":" + this.ref.getLocalPart());
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_DATATYPE.getLocalPart(), "xsd:" + this.datatype.getLocalPart());
            if (this.appliesTo != null) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_APPLIES_TO.getLocalPart(), this.appliesTo);
            } else {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_APPLIES_TO.getLocalPart(), this.getPropertyOwner().toString().toLowerCase());
            }
            if (this.idRef != null) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_ID_REF.getLocalPart(), this.idRef);
            }
            if (this.unit != null) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeAttribute(ATTR_UNIT.getLocalPart(), this.unit);
            }
            if (this.value != null) {
                ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeCharacters(this.value);
            }
            ((PhyloXMLWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().writeEndElement();
        }
    }
}

