/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phyloxml;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.WriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.phyloxml.PhyloXMLConstants;
import info.bioinfweb.jphyloio.objecttranslation.InvalidObjectSourceDataException;
import info.bioinfweb.jphyloio.objecttranslation.implementations.AbstractObjectTranslator;
import java.awt.Color;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;

public class PhyloXMLColorTranslator
extends AbstractObjectTranslator<Color>
implements PhyloXMLConstants {
    @Override
    public Class<Color> getObjectClass() {
        return Color.class;
    }

    @Override
    public boolean hasStringRepresentation() {
        return false;
    }

    @Override
    public String javaToRepresentation(Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws UnsupportedOperationException, ClassCastException {
        throw new UnsupportedOperationException("PhyloXML color definitions can only be represented as structured XML.");
    }

    @Override
    public void writeXMLRepresentation(XMLStreamWriter xMLStreamWriter, Object object, WriterStreamDataProvider<?> writerStreamDataProvider) throws IOException, XMLStreamException {
        Color color = (Color)object;
        xMLStreamWriter.writeStartElement(TAG_RED.getLocalPart());
        xMLStreamWriter.writeCharacters(Integer.toString(color.getRed()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement(TAG_GREEN.getLocalPart());
        xMLStreamWriter.writeCharacters(Integer.toString(color.getGreen()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement(TAG_BLUE.getLocalPart());
        xMLStreamWriter.writeCharacters(Integer.toString(color.getBlue()));
        xMLStreamWriter.writeEndElement();
    }

    @Override
    public Color representationToJava(String string, ReaderStreamDataProvider<?> readerStreamDataProvider) throws InvalidObjectSourceDataException, UnsupportedOperationException {
        throw new UnsupportedOperationException("PhyloXML color definitions can only be read from structured XML.");
    }

    @Override
    public Color readXMLRepresentation(XMLEventReader xMLEventReader, ReaderStreamDataProvider<?> readerStreamDataProvider) throws IOException, XMLStreamException, InvalidObjectSourceDataException {
        Color color = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        HashSet<QName> hashSet = new HashSet<QName>();
        XMLEvent xMLEvent = xMLEventReader.peek();
        while (!xMLEvent.isEndElement() || hashSet.contains(xMLEvent.asEndElement().getName())) {
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                QName qName = xMLEvent2.asStartElement().getName();
                hashSet.add(qName);
                if (qName.equals(TAG_RED)) {
                    string = xMLEventReader.getElementText();
                } else if (qName.equals(TAG_GREEN)) {
                    string2 = xMLEventReader.getElementText();
                } else if (qName.equals(TAG_BLUE)) {
                    string3 = xMLEventReader.getElementText();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)xMLEventReader);
                }
            }
            xMLEvent = xMLEventReader.peek();
        }
        if (string != null && string2 != null && string3 != null) {
            try {
                color = new Color(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidObjectSourceDataException("The encountered XML could not be parsed to a color object.");
            }
        }
        return color;
    }
}

