/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.phylip;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.phylip.AbstractPhylipEventReader;
import info.bioinfweb.jphyloio.formats.text.TextReaderStreamDataProvider;
import info.bioinfweb.jphyloio.utils.IDToNameManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PhylipEventReader
extends AbstractPhylipEventReader<TextReaderStreamDataProvider<PhylipEventReader>> {
    private boolean allowInterleavedParsing = true;
    private List<String> sequenceNames = new ArrayList<String>();
    private int currentSequenceIndex = 0;
    private IDToNameManager sequenceIDToNameManager = new IDToNameManager("seq");

    public PhylipEventReader(BufferedReader bufferedReader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(bufferedReader, readWriteParameterMap);
        this.init();
    }

    public PhylipEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(file, readWriteParameterMap);
        this.init();
    }

    public PhylipEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(inputStream, readWriteParameterMap);
        this.init();
    }

    public PhylipEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        super(reader, readWriteParameterMap);
        this.init();
    }

    private void init() {
        this.allowInterleavedParsing = this.getParameters().getBoolean("info.bioinfweb.jphyloio.allowInterleavedParsing", true);
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.phylip";
    }

    private void increaseSequenceIndex() {
        ++this.currentSequenceIndex;
        if ((long)this.currentSequenceIndex >= this.getSequenceCount()) {
            this.currentSequenceIndex = (int)((long)this.currentSequenceIndex - this.getSequenceCount());
        }
    }

    @Override
    protected void readNextEvent() throws IOException {
        if (this.isBeforeFirstAccess()) {
            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.START));
        } else {
            switch (this.getPreviousEvent().getType().getContentType()) {
                case DOCUMENT: {
                    if (!this.getPreviousEvent().getType().getTopologyType().equals((Object)EventTopologyType.START)) break;
                    this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.ALIGNMENT, "matrix" + this.getIDManager().createNewID(), null, null));
                    this.readMatrixDimensions();
                    break;
                }
                case ALIGNMENT: {
                    this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.DOCUMENT, EventTopologyType.END));
                    break;
                }
                case LITERAL_META: {
                    if (this.getSequenceCount() == 0L) {
                        this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                        break;
                    }
                }
                case SEQUENCE: 
                case SEQUENCE_TOKENS: {
                    JPhyloIOEvent jPhyloIOEvent;
                    if (this.lineConsumed) {
                        while (this.getReader().isNewLineNext()) {
                            this.getReader().consumeNewLine();
                        }
                        if (!this.allowInterleavedParsing || (long)this.sequenceNames.size() < this.getSequenceCount()) {
                            this.currentSequenceName = this.readSequenceName();
                            this.sequenceNames.add(this.currentSequenceName);
                        } else if (this.allowInterleavedParsing) {
                            this.currentSequenceName = this.sequenceNames.get(this.currentSequenceIndex);
                        } else {
                            throw new JPhyloIOReaderException("Interleaved Phylip format found, although interleaved parsing was not allowed.", (StreamLocationProvider)this.getReader());
                        }
                        if (!this.getPreviousEvent().getType().getContentType().equals((Object)EventContentType.LITERAL_META)) {
                            this.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, this.getSequenceTokensEventManager().getCurrentPosition() >= this.getCharacterCount()));
                        }
                        this.increaseSequenceIndex();
                        if (this.getReader().peek() == -1) {
                            this.getCurrentEventCollection().add(new ConcreteJPhyloIOEvent(EventContentType.ALIGNMENT, EventTopologyType.END));
                            break;
                        }
                        this.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, this.sequenceIDToNameManager.getID(this.currentSequenceName), this.currentSequenceName, null));
                    }
                    if ((jPhyloIOEvent = this.readCharacters(this.currentSequenceName)) != null) {
                        this.getCurrentEventCollection().add(jPhyloIOEvent);
                        break;
                    }
                    this.readNextEvent();
                    break;
                }
                default: {
                    throw new InternalError("Impossible case");
                }
            }
        }
    }
}

