/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.pde;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.io.W3CXSConstants;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.LabeledIDEvent;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.PartEndEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.pde.PDEConstants;
import info.bioinfweb.jphyloio.formats.pde.PDEMetaColumnDefintion;
import info.bioinfweb.jphyloio.formats.pde.PDEMetaColumnType;
import info.bioinfweb.jphyloio.formats.pde.PDEReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.xml.AbstractXMLEventReader;
import info.bioinfweb.jphyloio.formats.xml.AttributeInfo;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.AbstractXMLElementReader;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.CommentElementReader;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.StartDocumentElementReader;
import info.bioinfweb.jphyloio.formats.xml.elementreaders.XMLElementReaderKey;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.map.ListOrderedMap;

public class PDEEventReader
extends AbstractXMLEventReader<PDEReaderStreamDataProvider>
implements PDEConstants {
    private static final Pattern META_DEFINITION_PATTERN = Pattern.compile("(\\d+)\\s+\\\"([^\\\"]*)\\\"\\s+(\\w+)\\s*");

    private static XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException, IOException {
        try {
            inputStream = new BufferedInputStream(inputStream);
            inputStream.mark(1024);
            inputStream = new GZIPInputStream(inputStream);
        }
        catch (ZipException zipException) {
            inputStream.reset();
        }
        return XMLInputFactory.newInstance().createXMLEventReader(inputStream);
    }

    public PDEEventReader(File file, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        this(new FileInputStream(file), readWriteParameterMap);
    }

    public PDEEventReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        super(PDEEventReader.createXMLEventReader(inputStream), readWriteParameterMap);
    }

    public PDEEventReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException, XMLStreamException {
        super(reader, readWriteParameterMap);
    }

    public PDEEventReader(XMLEventReader xMLEventReader, ReadWriteParameterMap readWriteParameterMap) {
        super(xMLEventReader, readWriteParameterMap);
    }

    @Override
    public String getFormatID() {
        return "info.bioinfweb.jphyloio.pde";
    }

    @Override
    protected void fillMap() {
        this.putElementReader(new XMLElementReaderKey(null, null, 7), new StartDocumentElementReader());
        this.putElementReader(new XMLElementReaderKey(null, null, 8), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.DOCUMENT));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ROOT, TAG_DESCRIPTION, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + pDEReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PDEConstants.PREDICATE_DESCRIPTION), new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_STRING), LiteralContentSequenceType.SIMPLE));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_DESCRIPTION, null, 4), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                boolean bl = pDEReaderStreamDataProvider.getXMLReader().peek().isCharacters();
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(xMLEvent.asCharacters().getData(), bl));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ROOT, TAG_DESCRIPTION, 2), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ROOT, TAG_ALIGNMENT, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                StartElement startElement = xMLEvent.asStartElement();
                String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)PDEConstants.ATTR_DATATYPE, null);
                CharacterStateSetType characterStateSetType = null;
                characterStateSetType = string != null && string.equals("dna") ? CharacterStateSetType.DNA : CharacterStateSetType.AMINO_ACID;
                pDEReaderStreamDataProvider.setCharacterSetType(characterStateSetType);
                pDEReaderStreamDataProvider.setAlignmentLength(XMLUtils.readIntAttr((StartElement)startElement, (QName)PDEConstants.ATTR_ALIGNMENT_LENGTH, (int)0));
                pDEReaderStreamDataProvider.setSequenceCount(XMLUtils.readIntAttr((StartElement)startElement, (QName)PDEConstants.ATTR_SEQUENCE_COUNT, (int)0));
                pDEReaderStreamDataProvider.setCreateAlignmentStart(true);
                pDEReaderStreamDataProvider.setCreateAlignmentEnd(false);
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ROOT, TAG_ALIGNMENT, 2), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                if (pDEReaderStreamDataProvider.isCreateAlignmentEnd()) {
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.ALIGNMENT));
                    pDEReaderStreamDataProvider.setCreateAlignmentEnd(false);
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ALIGNMENT, TAG_HEADER, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                String string = "otus" + pDEReaderStreamDataProvider.getIDManager().createNewID();
                pDEReaderStreamDataProvider.setOtuListID(string);
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.OTU_LIST, string, null));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ALIGNMENT, TAG_HEADER, 2), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.OTU_LIST));
                PDEEventReader.this.createAlignmentStart(pDEReaderStreamDataProvider);
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_META_TYPE_DEFINITIONS, null, 4), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                String string = xMLEvent.asCharacters().getData();
                if (string.matches("\\s+")) return;
                if (pDEReaderStreamDataProvider.hasIncompleteToken()) {
                    string = pDEReaderStreamDataProvider.getIncompleteToken() + string;
                }
                Matcher matcher = META_DEFINITION_PATTERN.matcher(string);
                int n = 0;
                while (matcher.find(n)) {
                    int n2 = Integer.parseInt(matcher.group(1));
                    pDEReaderStreamDataProvider.getMetaColumns().put(n2, new PDEMetaColumnDefintion(n2, matcher.group(2), PDEMetaColumnType.parseColumnType(matcher.group(3))));
                    n = matcher.end();
                }
                if ((string = string.substring(n)).length() > 0) {
                    if (!pDEReaderStreamDataProvider.getXMLReader().peek().isCharacters()) throw new JPhyloIOReaderException("Invalid meta column definition in " + PDEConstants.TAG_META_TYPE_DEFINITIONS.getLocalPart() + " tag ending with \"" + string + "\" found.", xMLEvent.getLocation());
                    pDEReaderStreamDataProvider.setIncompleteToken(string);
                    return;
                } else {
                    pDEReaderStreamDataProvider.setIncompleteToken(null);
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_HEADER, TAG_SEQUENCE_INFORMATION, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.setCurrentSequenceIndex(XMLUtils.readIntAttr((StartElement)xMLEvent.asStartElement(), (QName)PDEConstants.ATTR_SEQUENCE_INDEX, (int)-1));
                pDEReaderStreamDataProvider.getSequenceInformations().add((Map<Integer, String>)new ListOrderedMap());
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_SEQUENCE_INFORMATION, TAG_SEQUENCE_META_INFORMATION, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                String string;
                StartElement startElement = xMLEvent.asStartElement();
                int n = XMLUtils.readIntAttr((StartElement)startElement, (QName)PDEConstants.ATTR_ID, (int)0);
                String string2 = null;
                XMLEvent xMLEvent2 = ((PDEEventReader)pDEReaderStreamDataProvider.getEventReader()).getXMLReader().peek();
                if (xMLEvent2.getEventType() == 4 && !(string = xMLEvent2.asCharacters().getData()).matches("\\s+")) {
                    string2 = string;
                }
                int n2 = pDEReaderStreamDataProvider.getCurrentSequenceIndex();
                pDEReaderStreamDataProvider.getSequenceInformations().get(n2).put(n, string2);
                if (n == 1) {
                    String string3 = "otu" + pDEReaderStreamDataProvider.getIDManager().createNewID();
                    pDEReaderStreamDataProvider.getSequenceIndexToOTUID().put(n2, string3);
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LabeledIDEvent(EventContentType.OTU, string3, string2));
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.OTU));
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ALIGNMENT, TAG_CHARSETS, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                if (pDEReaderStreamDataProvider.isCreateAlignmentStart()) {
                    PDEEventReader.this.createAlignmentStart(pDEReaderStreamDataProvider);
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_CHARSETS, TAG_CHARSET, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                StartElement startElement = xMLEvent.asStartElement();
                String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)PDEConstants.ATTR_CHARSET_LABEL, null);
                String string2 = startElement.getAttributeByName(PDEConstants.ATTR_COLOR).getValue();
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.CHARACTER_SET, "charSet" + pDEReaderStreamDataProvider.getIDManager().createNewID(), string, pDEReaderStreamDataProvider.getCurrentAlignmentID()));
                if (startElement.getAttributeByName(PDEConstants.ATTR_VISIBILITY) != null) {
                    boolean bl = XMLUtils.readBooleanAttr((StartElement)startElement, (QName)PDEConstants.ATTR_VISIBILITY, (boolean)false);
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + pDEReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PDEConstants.PREDICATE_CHARSET_VISIBILITY), new URIOrStringIdentifier(null, W3CXSConstants.DATA_TYPE_BOOLEAN), LiteralContentSequenceType.SIMPLE));
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(bl, Boolean.toString(bl)));
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
                }
                if (string2 != null) {
                    Color color = Color.decode("#" + string2);
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + pDEReaderStreamDataProvider.getIDManager().createNewID(), null, new URIOrStringIdentifier(null, PDEConstants.PREDICATE_CHARSET_COLOR), LiteralContentSequenceType.SIMPLE));
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LiteralMetadataContentEvent(color, string2));
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_CHARSET, null, 4), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                String string = xMLEvent.asCharacters().getData();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl = true;
                if (pDEReaderStreamDataProvider.getIncompleteToken() != null) {
                    string = pDEReaderStreamDataProvider.getIncompleteToken() + string;
                    pDEReaderStreamDataProvider.setIncompleteToken(null);
                }
                for (int i = 0; i < string.length(); ++i) {
                    Character c = Character.valueOf(string.charAt(i));
                    if (c.charValue() == '-') {
                        bl = false;
                        continue;
                    }
                    if (Character.isWhitespace(c.charValue())) {
                        if (stringBuffer.length() > 0 || stringBuffer2.length() > 0) {
                            if (stringBuffer2.length() == 0) {
                                stringBuffer2.append(stringBuffer.toString());
                            }
                            pDEReaderStreamDataProvider.getCurrentEventCollection().add(new CharacterSetIntervalEvent(Long.parseLong(stringBuffer.toString()) - 1L, Long.parseLong(stringBuffer2.toString())));
                        }
                        bl = true;
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer2.delete(0, stringBuffer2.length());
                        continue;
                    }
                    if (bl) {
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer2.append(c);
                }
                if (PDEEventReader.this.getXMLReader().peek().getEventType() == 4) {
                    String string2 = stringBuffer.toString();
                    if (stringBuffer2.length() > 0) {
                        string2 = string2 + "-" + stringBuffer2.toString();
                    }
                    pDEReaderStreamDataProvider.setIncompleteToken(string2);
                } else if (stringBuffer.length() > 0 || stringBuffer2.length() > 0) {
                    if (stringBuffer2.length() == 0) {
                        stringBuffer2.append(stringBuffer.toString());
                    }
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(new CharacterSetIntervalEvent(Long.parseLong(stringBuffer.toString()) - 1L, Long.parseLong(stringBuffer2.toString())));
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_CHARSETS, TAG_CHARSET, 2), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new PartEndEvent(EventContentType.CHARACTER_SET, true));
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ALIGNMENT, TAG_MATRIX, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                if (pDEReaderStreamDataProvider.isCreateAlignmentStart()) {
                    PDEEventReader.this.createAlignmentStart(pDEReaderStreamDataProvider);
                }
                pDEReaderStreamDataProvider.setCurrentSequenceIndex(0);
                pDEReaderStreamDataProvider.setIncompleteToken("");
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_ALIGNMENT, TAG_MATRIX, 2), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                if (pDEReaderStreamDataProvider.isCreateAlignmentEnd()) {
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.ALIGNMENT));
                    pDEReaderStreamDataProvider.setCreateAlignmentEnd(false);
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_MATRIX, TAG_BLOCK, 1), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                boolean bl;
                this.readAttributes(pDEReaderStreamDataProvider, xMLEvent.asStartElement(), "", new AttributeInfo(PDEConstants.ATTR_ALIGNMENT_LENGTH, ReadWriteConstants.PREDICATE_CHARACTER_COUNT, W3CXSConstants.DATA_TYPE_INT), new AttributeInfo(PDEConstants.ATTR_SEQUENCE_COUNT, ReadWriteConstants.PREDICATE_SEQUENCE_COUNT, W3CXSConstants.DATA_TYPE_INT));
                int n = pDEReaderStreamDataProvider.getCurrentSequenceIndex();
                pDEReaderStreamDataProvider.setCurrentSequenceID("seq" + pDEReaderStreamDataProvider.getIDManager().createNewID());
                String string = null;
                boolean bl2 = bl = n < pDEReaderStreamDataProvider.getSequenceInformations().size();
                if (bl) {
                    string = pDEReaderStreamDataProvider.getSequenceInformations().get(n).get(1);
                }
                pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, pDEReaderStreamDataProvider.getCurrentSequenceID(), string, pDEReaderStreamDataProvider.getSequenceIndexToOTUID().get(n)));
                pDEReaderStreamDataProvider.setCurrentSequenceLength(0);
                if (bl) {
                    PDEEventReader.this.addSequenceMetaData(pDEReaderStreamDataProvider);
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(TAG_BLOCK, null, 4), new AbstractXMLElementReader<PDEReaderStreamDataProvider>(){

            @Override
            public void readEvent(PDEReaderStreamDataProvider pDEReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
                String string = xMLEvent.asCharacters().getData().replaceAll("\\s", "");
                String string2 = pDEReaderStreamDataProvider.getIncompleteToken();
                String string3 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                Character c = Character.valueOf(' ');
                for (int i = 0; i < string.length(); ++i) {
                    int n;
                    Character c2 = Character.valueOf(string.charAt(i));
                    if (!c2.equals(Character.valueOf('\\')) && string2.isEmpty()) {
                        if (arrayList.size() < pDEReaderStreamDataProvider.getAlignmentLength()) {
                            arrayList.add(Character.toString(c2.charValue()));
                            continue;
                        }
                        throw new JPhyloIOReaderException("The sequence with the index \"" + pDEReaderStreamDataProvider.getCurrentSequenceIndex() + "\" was found to be longer than the specified alignment length of " + pDEReaderStreamDataProvider.getAlignmentLength() + ". This is not allowed in PDE files.", xMLEvent.getLocation());
                    }
                    while (i < string.length() && string.charAt(i) != ':' && (string.charAt(i) != 'F' || c.charValue() != 'F')) {
                        c = Character.valueOf(string.charAt(i));
                        string2 = string2 + c;
                        ++i;
                    }
                    if (i == string.length()) {
                        pDEReaderStreamDataProvider.setIncompleteToken(string2);
                        continue;
                    }
                    if (string2.equals("\\F")) {
                        if (arrayList.size() != 0) {
                            pDEReaderStreamDataProvider.getCurrentEventCollection().add(PDEEventReader.this.getSequenceTokensEventManager().createEvent(pDEReaderStreamDataProvider.getCurrentSequenceID(), arrayList));
                            pDEReaderStreamDataProvider.setCurrentSequenceLength(pDEReaderStreamDataProvider.getCurrentSequenceLength() + arrayList.size());
                            arrayList = new ArrayList();
                        }
                        if (pDEReaderStreamDataProvider.getCurrentSequenceLength() != pDEReaderStreamDataProvider.getAlignmentLength()) {
                            throw new JPhyloIOReaderException("The sequence with the index \"" + pDEReaderStreamDataProvider.getCurrentSequenceIndex() + "\" was found to be shorter than the specified alignment length of " + pDEReaderStreamDataProvider.getAlignmentLength() + ". This is not allowed in PDE files.", xMLEvent.getLocation());
                        }
                        pDEReaderStreamDataProvider.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, true));
                        n = pDEReaderStreamDataProvider.getCurrentSequenceIndex() + 1;
                        if (n < pDEReaderStreamDataProvider.getSequenceCount()) {
                            boolean bl;
                            pDEReaderStreamDataProvider.setCurrentSequenceIndex(n);
                            pDEReaderStreamDataProvider.setCurrentSequenceID("seq" + pDEReaderStreamDataProvider.getIDManager().createNewID());
                            boolean bl2 = bl = n < pDEReaderStreamDataProvider.getSequenceInformations().size();
                            if (bl) {
                                string3 = pDEReaderStreamDataProvider.getSequenceInformations().get(n).get(1);
                            }
                            pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.SEQUENCE, pDEReaderStreamDataProvider.getCurrentSequenceID(), string3, pDEReaderStreamDataProvider.getSequenceIndexToOTUID().get(n)));
                            pDEReaderStreamDataProvider.setCurrentSequenceLength(0);
                            if (bl) {
                                PDEEventReader.this.addSequenceMetaData(pDEReaderStreamDataProvider);
                            }
                        }
                    } else if (string2.contains("\\FE")) {
                        string2 = string2.replaceAll("\\\\FE", "");
                        for (n = 0; n < Integer.parseInt(StringUtils.invert((CharSequence)string2)); ++n) {
                            arrayList.add("?");
                        }
                        pDEReaderStreamDataProvider.getCurrentEventCollection().add(PDEEventReader.this.getSequenceTokensEventManager().createEvent(pDEReaderStreamDataProvider.getCurrentSequenceID(), arrayList));
                        pDEReaderStreamDataProvider.setCurrentSequenceLength(pDEReaderStreamDataProvider.getCurrentSequenceLength() + arrayList.size());
                        arrayList = new ArrayList();
                    }
                    string2 = "";
                    pDEReaderStreamDataProvider.setIncompleteToken(string2);
                }
                if (arrayList.size() != 0) {
                    pDEReaderStreamDataProvider.getCurrentEventCollection().add(PDEEventReader.this.getSequenceTokensEventManager().createEvent(pDEReaderStreamDataProvider.getCurrentSequenceID(), arrayList));
                    pDEReaderStreamDataProvider.setCurrentSequenceLength(pDEReaderStreamDataProvider.getCurrentSequenceLength() + arrayList.size());
                    if (pDEReaderStreamDataProvider.getXMLReader().peek().getEventType() != 4) {
                        if (pDEReaderStreamDataProvider.getCurrentSequenceLength() == pDEReaderStreamDataProvider.getAlignmentLength()) {
                            pDEReaderStreamDataProvider.getCurrentEventCollection().add(new PartEndEvent(EventContentType.SEQUENCE, true));
                        } else {
                            throw new JPhyloIOReaderException("The sequence with the index \"" + pDEReaderStreamDataProvider.getCurrentSequenceIndex() + "\" was found to be shorter than the specified alignment length of " + pDEReaderStreamDataProvider.getAlignmentLength() + ". This is not allowed in PDE files.", xMLEvent.getLocation());
                        }
                    }
                }
            }
        });
        this.putElementReader(new XMLElementReaderKey(null, null, 5), new CommentElementReader());
    }

    private void addSequenceMetaData(PDEReaderStreamDataProvider pDEReaderStreamDataProvider) throws JPhyloIOReaderException {
        Map<Integer, String> map = pDEReaderStreamDataProvider.getSequenceInformations().get(pDEReaderStreamDataProvider.getCurrentSequenceIndex());
        URIOrStringIdentifier uRIOrStringIdentifier = null;
        String string = null;
        Object object = null;
        for (int n : map.keySet()) {
            URIOrStringIdentifier uRIOrStringIdentifier2;
            PDEMetaColumnDefintion pDEMetaColumnDefintion = pDEReaderStreamDataProvider.getMetaColumns().get(n);
            if (n == 3) {
                uRIOrStringIdentifier = new URIOrStringIdentifier("NUMBER", null);
                uRIOrStringIdentifier2 = new URIOrStringIdentifier(null, PREDICATE_ACCESS_NUMBER);
            } else if (n == 4) {
                uRIOrStringIdentifier = new URIOrStringIdentifier("STRING", null);
                uRIOrStringIdentifier2 = new URIOrStringIdentifier(null, PREDICATE_COMMENT);
            } else if (n == 1) {
                uRIOrStringIdentifier = null;
                uRIOrStringIdentifier2 = null;
            } else if (n == 2) {
                uRIOrStringIdentifier = null;
                uRIOrStringIdentifier2 = new URIOrStringIdentifier(null, PREDICATE_LINKED_FILE);
            } else {
                uRIOrStringIdentifier2 = new URIOrStringIdentifier(Integer.toString(n), PREDICATE_HAS_LITERAL_METADATA);
                uRIOrStringIdentifier = null;
                string = Integer.toString(n);
                if (pDEMetaColumnDefintion != null) {
                    uRIOrStringIdentifier2 = new URIOrStringIdentifier(pDEMetaColumnDefintion.getName(), PREDICATE_HAS_LITERAL_METADATA);
                    string = pDEMetaColumnDefintion.getName();
                    switch (pDEMetaColumnDefintion.getType()) {
                        case FILE: {
                            uRIOrStringIdentifier2 = new URIOrStringIdentifier(pDEMetaColumnDefintion.getName(), PREDICATE_HAS_RESOURCE_METADATA);
                            break;
                        }
                        case NUMBER: {
                            uRIOrStringIdentifier = new URIOrStringIdentifier(pDEMetaColumnDefintion.getType().toString(), null);
                            try {
                                object = Double.parseDouble(map.get(n));
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        default: {
                            uRIOrStringIdentifier = new URIOrStringIdentifier(pDEMetaColumnDefintion.getType().toString(), null);
                        }
                    }
                }
            }
            if (uRIOrStringIdentifier2 == null) continue;
            if (!uRIOrStringIdentifier2.getURI().equals(PREDICATE_HAS_RESOURCE_METADATA) && !uRIOrStringIdentifier2.getURI().equals(PREDICATE_LINKED_FILE)) {
                if (object == null) {
                    object = map.get(n);
                }
                this.getCurrentEventCollection().add(new LiteralMetadataEvent("meta" + pDEReaderStreamDataProvider.getIDManager().createNewID(), string, uRIOrStringIdentifier2, uRIOrStringIdentifier, LiteralContentSequenceType.SIMPLE));
                this.getCurrentEventCollection().add(new LiteralMetadataContentEvent(object, map.get(n)));
                this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
                object = null;
                continue;
            }
            try {
                File file = new File(map.get(n).replace("\\\\", "\\"));
                URI uRI = file.isAbsolute() ? file.toURI() : new URI(file.getPath());
                this.getCurrentEventCollection().add(new ResourceMetadataEvent("meta" + pDEReaderStreamDataProvider.getIDManager().createNewID(), string, uRIOrStringIdentifier2, uRI, null));
                this.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.RESOURCE_META));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void createAlignmentStart(PDEReaderStreamDataProvider pDEReaderStreamDataProvider) {
        String string = pDEReaderStreamDataProvider.getCurrentAlignmentID();
        if (string == null) {
            string = "matrix" + pDEReaderStreamDataProvider.getIDManager().createNewID();
        }
        pDEReaderStreamDataProvider.setCurrentAlignmentID(string);
        pDEReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(EventContentType.ALIGNMENT, string, null, pDEReaderStreamDataProvider.getOtuListID()));
        pDEReaderStreamDataProvider.getCurrentEventCollection().add(new TokenSetDefinitionEvent(pDEReaderStreamDataProvider.getCharacterSetType(), "tokenSet" + pDEReaderStreamDataProvider.getIDManager().createNewID(), null));
        pDEReaderStreamDataProvider.getCurrentEventCollection().add(new CharacterSetIntervalEvent(0L, pDEReaderStreamDataProvider.getAlignmentLength()));
        pDEReaderStreamDataProvider.getCurrentEventCollection().add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.TOKEN_SET_DEFINITION));
        pDEReaderStreamDataProvider.setCreateAlignmentStart(false);
        pDEReaderStreamDataProvider.setCreateAlignmentEnd(true);
    }

    @Override
    protected PDEReaderStreamDataProvider createStreamDataProvider() {
        return new PDEReaderStreamDataProvider(this);
    }
}

