/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.receivers;

import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SetElementEvent;
import info.bioinfweb.jphyloio.exception.IllegalEventException;
import info.bioinfweb.jphyloio.exception.InconsistentAdapterDataException;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventWriter;
import info.bioinfweb.jphyloio.formats.nexus.NexusWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.receivers.AbstractNexusEventReceiver;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractNexusSetsEventReceiver
extends AbstractNexusEventReceiver {
    public AbstractNexusSetsEventReceiver(NexusWriterStreamDataProvider nexusWriterStreamDataProvider) {
        super(nexusWriterStreamDataProvider);
    }

    protected boolean handleCharacterSetInterval(CharacterSetIntervalEvent characterSetIntervalEvent) throws IOException {
        return false;
    }

    protected abstract boolean handleSetElement(SetElementEvent var1) throws IOException;

    protected void writeElementReference(SetElementEvent setElementEvent) throws IOException {
        ((NexusWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(32);
        String string = this.getParameterMap().getLabelEditingReporter().getEditedLabel(setElementEvent.getLinkedObjectType(), setElementEvent.getLinkedID());
        if (string == null) {
            throw new InconsistentAdapterDataException("A set references the other element with the ID " + setElementEvent.getLinkedID() + " that was not previously written (or is known at all). Referencing (currently) undeclared elements is not possible in Nexus.");
        }
        ((NexusWriterStreamDataProvider)this.getStreamDataProvider()).getWriter().write(NexusEventWriter.formatToken(string));
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        boolean bl = false;
        if (this.getParentEvent() == null) {
            switch (jPhyloIOEvent.getType().getContentType()) {
                case CHARACTER_SET_INTERVAL: {
                    bl = this.handleCharacterSetInterval(jPhyloIOEvent.asCharacterSetIntervalEvent());
                    break;
                }
                case SET_ELEMENT: {
                    bl = this.handleSetElement(jPhyloIOEvent.asSetElementEvent());
                    break;
                }
            }
        }
        if (bl) {
            return true;
        }
        throw IllegalEventException.newInstance(this, this.getParentEvent(), jPhyloIOEvent);
    }
}

