/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.newick.NewickStringReader;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractNexusCommandEventReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.NexusNewickReaderNodeLabelProcessor;
import java.io.EOFException;
import java.io.IOException;

public class TreeReader
extends AbstractNexusCommandEventReader
implements NexusConstants,
ReadWriteConstants {
    private NewickStringReader newickStringReader = null;

    public TreeReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("TREE", new String[]{"TREES"}, nexusReaderStreamDataProvider);
    }

    protected TreeReader(String string, String[] stringArray, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super(string, stringArray, nexusReaderStreamDataProvider);
    }

    protected boolean getExpectENewick() {
        return this.getStreamDataProvider().getParameters().getBoolean("info.bioinfweb.jphyloio.expectENewick", false);
    }

    protected EventContentType getElementContentType() {
        return EventContentType.TREE;
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        try {
            if (this.newickStringReader == null) {
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
                String string = this.getStreamDataProvider().readNexusWord();
                this.getStreamDataProvider().consumeWhiteSpaceAndComments();
                String string2 = this.getStreamDataProvider().getSharedInformationMap().getString("info.bioinfweb.jphyloio.nexus.currentBlockID");
                this.getStreamDataProvider().getElementList(this.getElementContentType(), string2).add(string);
                String string3 = "tree" + this.getStreamDataProvider().getIDManager().createNewID();
                this.getStreamDataProvider().getNexusNameToIDMap(this.getElementContentType(), string2).put(string, string3);
                if (peekReader.peekChar() == '=') {
                    peekReader.read();
                    this.newickStringReader = new NewickStringReader(this.getStreamDataProvider(), string3, string, new NexusNewickReaderNodeLabelProcessor(this.getStreamDataProvider()), this.getExpectENewick());
                } else {
                    throw new JPhyloIOReaderException("Expected \"=\" behind the tree label in the " + this.getCommandName() + " command, but found \"" + peekReader.peekChar() + "\".", (StreamLocationProvider)peekReader);
                }
            }
            return this.newickStringReader.addNextEvents();
        }
        catch (EOFException eOFException) {
            throw new JPhyloIOReaderException("Unexpected end of file inside a Nexus " + this.getCommandName() + " command.", (StreamLocationProvider)peekReader, (Throwable)eOFException);
        }
    }
}

