/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees;

import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.formats.newick.NewickReaderNodeLabelProcessor;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.NexusTranslationTable;
import java.util.Collections;
import java.util.List;

public class NexusNewickReaderNodeLabelProcessor
implements NewickReaderNodeLabelProcessor,
NexusConstants {
    public static final boolean DEFAULT_TRANSLATE_INTERNAL_NODE_NAMES = false;
    private NexusReaderStreamDataProvider streamDataProvider;

    public NexusNewickReaderNodeLabelProcessor(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        this.streamDataProvider = nexusReaderStreamDataProvider;
    }

    @Override
    public String processLabel(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl && !this.streamDataProvider.getParameters().getBoolean("info.bioinfweb.jphyloio.translateInternalNodeNames", false)) {
            return string;
        }
        NexusTranslationTable nexusTranslationTable = this.streamDataProvider.getTreesTranslationTable();
        String string2 = this.streamDataProvider.getCurrentLinkedBlockID("TAXA");
        List<Object> list = string2 == null ? Collections.emptyList() : this.streamDataProvider.getElementList(EventContentType.OTU, string2);
        String string3 = nexusTranslationTable.get(string);
        if (string3 == null) {
            try {
                int n = Integer.parseInt(string) - 1;
                if (n < nexusTranslationTable.size()) {
                    string3 = nexusTranslationTable.get(n);
                } else if (n < list.size()) {
                    string3 = (String)list.get(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (string3 == null) {
                string3 = string;
            }
        }
        return string3;
    }

    @Override
    public String getLinkedOTUID(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.streamDataProvider.getCurrentLinkedBlockID("TAXA");
        if (string2 == null) {
            return null;
        }
        return this.streamDataProvider.getNexusNameToIDMap(EventContentType.OTU, string2).get(string);
    }
}

