/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.CharacterSetIntervalEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.TokenSetDefinitionEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.BufferedEventInfo;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractKeyValueCommandReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class FormatReader
extends AbstractKeyValueCommandReader
implements NexusConstants,
ReadWriteConstants {
    public static final String INFO_KEY_TOKENS_FORMAT = "info.bioinfweb.jphyloio.nexus.tokens";
    public static final String INFO_KEY_INTERLEAVE = "info.bioinfweb.jphyloio.nexus.interleave";
    public static final String INFO_KEY_LABELS = "info.bioinfweb.jphyloio.nexus.labels";
    public static final String INFO_KEY_TRANSPOSE = "info.bioinfweb.jphyloio.nexus.transpose";
    public static final Pattern MIXED_DATA_TYPE_VALUE_PATTERN = Pattern.compile("MIXED\\((.+)\\)", 34);
    public static final Pattern MIXED_DATA_TYPE_SINGLE_SET_PATTERN = Pattern.compile("(.+)\\:([0-9]+)\\-([0-9]+)");
    private boolean continuousData = false;
    private List<BufferedEventInfo<TokenSetDefinitionEvent>> tokenSetInfos = new ArrayList<BufferedEventInfo<TokenSetDefinitionEvent>>();
    private List<SingleTokenDefinitionEvent> singleTokenDefinitionEvents = new ArrayList<SingleTokenDefinitionEvent>();

    public FormatReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("FORMAT", new String[]{"CHARACTERS", "UNALIGNED", "DATA"}, nexusReaderStreamDataProvider);
    }

    private CharacterStateSetType getTokenSetType(String string) {
        if (string.equals("STANDARD")) {
            return CharacterStateSetType.DISCRETE;
        }
        if (string.equals("NUCLEOTIDE")) {
            return CharacterStateSetType.NUCLEOTIDE;
        }
        if (string.equals("DNA")) {
            return CharacterStateSetType.DNA;
        }
        if (string.equals("RNA")) {
            return CharacterStateSetType.RNA;
        }
        if (string.equals("PROTEIN")) {
            return CharacterStateSetType.AMINO_ACID;
        }
        if (string.equals("CONTINUOUS")) {
            this.continuousData = true;
            return CharacterStateSetType.CONTINUOUS;
        }
        return CharacterStateSetType.UNKNOWN;
    }

    private boolean parseMixedDataType(String string) {
        String[] stringArray = string.split("\\,");
        ArrayList<BufferedEventInfo<TokenSetDefinitionEvent>> arrayList = new ArrayList<BufferedEventInfo<TokenSetDefinitionEvent>>(2 * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            BufferedEventInfo<TokenSetDefinitionEvent> bufferedEventInfo;
            Matcher matcher = MIXED_DATA_TYPE_SINGLE_SET_PATTERN.matcher(stringArray[i]);
            if (matcher.matches()) {
                bufferedEventInfo = new BufferedEventInfo<TokenSetDefinitionEvent>(new TokenSetDefinitionEvent(this.getTokenSetType(matcher.group(1).toUpperCase()), "tokenSet" + this.getStreamDataProvider().getIDManager().createNewID(), matcher.group(1)));
                try {
                    bufferedEventInfo.getNestedEvents().add(new CharacterSetIntervalEvent(Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)) + 1L));
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            } else {
                return false;
            }
            arrayList.add(bufferedEventInfo);
        }
        this.tokenSetInfos.addAll(arrayList);
        return true;
    }

    private void addSingleTokenDefinitionEvent(String string, CharacterSymbolMeaning characterSymbolMeaning) {
        this.singleTokenDefinitionEvents.add(new SingleTokenDefinitionEvent("tokenDefinition" + this.getStreamDataProvider().getIDManager().createNewID(), null, string, characterSymbolMeaning, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean processSubcommand(KeyValueInformation keyValueInformation) throws IOException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        String string = keyValueInformation.getOriginalKey().toUpperCase();
        String string2 = keyValueInformation.getValue().toUpperCase();
        if ("TOKENS".equals(string) || "DATATYPE".equals(string) && "CONTINUOUS".equals(string2)) {
            this.getStreamDataProvider().getSharedInformationMap().put((Object)INFO_KEY_TOKENS_FORMAT, (Object)true);
        }
        if ("DATATYPE".equals(string)) {
            object = MIXED_DATA_TYPE_VALUE_PATTERN.matcher(keyValueInformation.getValue());
            if (((Matcher)object).matches()) {
                if (this.parseMixedDataType(((Matcher)object).group(1))) {
                    return true;
                }
            } else {
                if (!this.tokenSetInfos.isEmpty()) throw new JPhyloIOReaderException("Duplicate token set definition in Nexus FORMAT command.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
                this.tokenSetInfos.add(new BufferedEventInfo<TokenSetDefinitionEvent>(new TokenSetDefinitionEvent(this.getTokenSetType(string2), "tokenSet" + this.getStreamDataProvider().getIDManager().createNewID(), keyValueInformation.getValue())));
                bl = true;
            }
        } else if ("INTERLEAVE".equals(string)) {
            this.getStreamDataProvider().getSharedInformationMap().put((Object)INFO_KEY_INTERLEAVE, (Object)true);
        } else if ("NOLABELS".equals(string)) {
            this.getStreamDataProvider().getSharedInformationMap().put((Object)INFO_KEY_LABELS, (Object)false);
        } else if ("TRANSPOSE".equals(string)) {
            this.getStreamDataProvider().getSharedInformationMap().put((Object)INFO_KEY_TRANSPOSE, (Object)true);
        } else if ("MATCHCHAR".equals(string)) {
            this.getStreamDataProvider().getSequenceTokensEventManager().setMatchToken(keyValueInformation.getValue());
            this.addSingleTokenDefinitionEvent(keyValueInformation.getValue(), CharacterSymbolMeaning.MATCH);
            bl = true;
        } else if ("GAP".equals(string)) {
            this.addSingleTokenDefinitionEvent(keyValueInformation.getValue(), CharacterSymbolMeaning.GAP);
            bl = true;
        } else if ("MISSING".equals(string)) {
            this.addSingleTokenDefinitionEvent(keyValueInformation.getValue(), CharacterSymbolMeaning.MISSING);
            bl = true;
        } else if ("SYMBOLS".equals(string)) {
            if (this.continuousData) {
                throw new JPhyloIOReaderException("The subcommand SYMBOLS of " + this.getCommandName() + " is not allowed if " + "DATATYPE" + "=" + "CONTINUOUS" + " was specified.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
            }
            for (int i = 0; i < keyValueInformation.getValue().length(); ++i) {
                char c = keyValueInformation.getValue().charAt(i);
                if (Character.isWhitespace(c)) continue;
                this.addSingleTokenDefinitionEvent(Character.toString(c), CharacterSymbolMeaning.CHARACTER_STATE);
                bl = true;
            }
        }
        if (bl) return bl2;
        object = this.getStreamDataProvider().getCurrentEventCollection();
        object.add(new LiteralMetadataEvent("meta" + this.getStreamDataProvider().getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), new QName("http://bioinfweb.info/xmlns/JPhyloIO/Formats/Nexus/Predicates/", "FORMAT." + string)), LiteralContentSequenceType.SIMPLE));
        object.add(new LiteralMetadataContentEvent(keyValueInformation.getValue(), false));
        object.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
        return true;
    }

    private void removeWaitingCharacterStateEvents() {
        Iterator<SingleTokenDefinitionEvent> iterator = this.singleTokenDefinitionEvents.iterator();
        while (iterator.hasNext()) {
            if (!CharacterSymbolMeaning.CHARACTER_STATE.equals((Object)iterator.next().getMeaning())) continue;
            iterator.remove();
        }
    }

    @Override
    protected boolean addStoredEvents() {
        boolean bl;
        boolean bl2 = bl = !this.tokenSetInfos.isEmpty();
        if (bl) {
            Collection<JPhyloIOEvent> collection = this.getStreamDataProvider().getCurrentEventCollection();
            if (this.tokenSetInfos.size() > 1) {
                this.removeWaitingCharacterStateEvents();
            }
            for (BufferedEventInfo<TokenSetDefinitionEvent> bufferedEventInfo : this.tokenSetInfos) {
                collection.add(bufferedEventInfo.getStartEvent());
                for (SingleTokenDefinitionEvent singleTokenDefinitionEvent : this.singleTokenDefinitionEvents) {
                    collection.add(singleTokenDefinitionEvent);
                    collection.add(new ConcreteJPhyloIOEvent(EventContentType.SINGLE_TOKEN_DEFINITION, EventTopologyType.END));
                }
                collection.addAll(bufferedEventInfo.getNestedEvents());
                collection.add(new ConcreteJPhyloIOEvent(EventContentType.TOKEN_SET_DEFINITION, EventTopologyType.END));
            }
            this.tokenSetInfos.clear();
            this.singleTokenDefinitionEvents.clear();
        }
        return bl;
    }
}

