/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters;

import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.URIOrStringIdentifier;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.AbstractKeyValueCommandReader;
import info.bioinfweb.jphyloio.formats.text.KeyValueInformation;
import java.io.IOException;
import java.util.Collection;
import javax.xml.namespace.QName;

public class DimensionsReader
extends AbstractKeyValueCommandReader
implements NexusConstants,
ReadWriteConstants {
    public static final String INFO_KEY_NTAX = "info.bioinfweb.jphyloio.nexus.ntax";
    public static final String INFO_KEY_CHAR = "info.bioinfweb.jphyloio.nexus.ntax";

    public DimensionsReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("DIMENSIONS", new String[]{"CHARACTERS", "UNALIGNED", "DATA"}, nexusReaderStreamDataProvider);
    }

    @Override
    protected boolean processSubcommand(KeyValueInformation keyValueInformation) throws IOException {
        long l = Long.MIN_VALUE;
        try {
            l = Long.parseLong(keyValueInformation.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Collection<JPhyloIOEvent> collection = this.getStreamDataProvider().getCurrentEventCollection();
        String string = keyValueInformation.getOriginalKey().toUpperCase();
        QName qName = new QName("http://bioinfweb.info/xmlns/JPhyloIO/Formats/Nexus/Predicates/", "DIMENSIONS." + string);
        if (l > 0L) {
            QName qName2 = qName;
            if ("NTAX".equals(string)) {
                this.getStreamDataProvider().getSharedInformationMap().put((Object)"info.bioinfweb.jphyloio.nexus.ntax", (Object)l);
                qName2 = PREDICATE_SEQUENCE_COUNT;
            } else if ("NCHAR".equals(string)) {
                this.getStreamDataProvider().getSharedInformationMap().put((Object)"info.bioinfweb.jphyloio.nexus.ntax", (Object)l);
                qName2 = PREDICATE_CHARACTER_COUNT;
                this.getStreamDataProvider().getMatrixWidthsMap().put((String)this.getStreamDataProvider().getSharedInformationMap().get((Object)"info.bioinfweb.jphyloio.nexus.currentBlockID"), l);
            }
            collection.add(new LiteralMetadataEvent("meta" + this.getStreamDataProvider().getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), qName2), LiteralContentSequenceType.SIMPLE));
            collection.add(new LiteralMetadataContentEvent(l, keyValueInformation.getValue()));
        } else {
            if ("NTAX".equals(string) || "NCHAR".equals(string)) {
                throw new JPhyloIOReaderException("\"" + keyValueInformation.getValue() + "\" is not a valid positive integer. Only positive integer values are valid for NTAX or NCHAR in the Nexus DIMENSIONS command.", (StreamLocationProvider)this.getStreamDataProvider().getDataReader());
            }
            collection.add(new LiteralMetadataEvent("meta" + this.getStreamDataProvider().getIDManager().createNewID(), keyValueInformation.getOriginalKey(), new URIOrStringIdentifier(keyValueInformation.getOriginalKey(), qName), LiteralContentSequenceType.SIMPLE));
            collection.add(new LiteralMetadataContentEvent(keyValueInformation.getValue(), false));
        }
        collection.add(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.LITERAL_META));
        return true;
    }

    @Override
    protected boolean addStoredEvents() {
        return false;
    }
}

