/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.AbstractCharLabelsReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class CharStateLabelsReader
extends AbstractCharLabelsReader
implements NexusConstants,
ReadWriteConstants {
    public CharStateLabelsReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("CHARSTATELABELS", nexusReaderStreamDataProvider);
    }

    private boolean consumeStateNames(Collection<JPhyloIOEvent> collection) throws IOException {
        boolean bl;
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        boolean bl2 = bl = peekReader.peekChar() == '/';
        if (bl) {
            peekReader.skip(1L);
            this.consumeWhiteSpaceAndCommentsToBuffer(collection);
            char c = peekReader.peekChar();
            while (c != ',' && c != ';') {
                String string = this.getStreamDataProvider().readNexusWord();
                if (string.equals("")) {
                    throw new JPhyloIOReaderException("The character '" + c + "' is invalid at this position inside a Nexus " + "CHARSTATELABELS" + " command.", (StreamLocationProvider)peekReader);
                }
                this.consumeWhiteSpaceAndCommentsToBuffer(collection);
                c = peekReader.peekChar();
            }
        }
        return bl;
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        ArrayList<JPhyloIOEvent> arrayList = new ArrayList<JPhyloIOEvent>();
        boolean bl = true;
        boolean bl2 = false;
        while (bl && !bl2) {
            PeekReader peekReader = this.getStreamDataProvider().getDataReader();
            this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
            if (peekReader.peek() == 59) {
                this.getStreamDataProvider().getDataReader().skip(1L);
                this.setAllDataProcessed(true);
                bl = false;
            } else {
                if (peekReader.peek() == 61) {
                    throw new JPhyloIOReaderException("The character " + this.getStreamDataProvider().getDataReader().readChar() + " is not allowed in the Nexus " + "CHARSTATELABELS" + " command.", (StreamLocationProvider)peekReader);
                }
                long l = this.getStreamDataProvider().readPositiveInteger(-1L);
                if (l < 0L) {
                    throw new JPhyloIOReaderException("Invalid character index (starting with '" + peekReader.peekChar() + "') found in Nexus " + "CHARSTATELABELS" + " command.", (StreamLocationProvider)peekReader);
                }
                this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                boolean bl3 = bl2 = !this.consumeStateNames(arrayList);
                if (bl2) {
                    String string = this.getStreamDataProvider().readNexusWord();
                    if (!string.equals("")) {
                        this.addCharacterDefinition(string, l - 1L);
                        this.consumeWhiteSpaceAndCommentsToBuffer(arrayList);
                        this.consumeStateNames(arrayList);
                    } else {
                        throw new JPhyloIOReaderException("The character '" + peekReader.peekChar() + "' is invalid at this position inside a Nexus " + "CHARSTATELABELS" + " command.", (StreamLocationProvider)peekReader);
                    }
                }
                if (peekReader.peek() == 44) {
                    peekReader.skip(1L);
                }
            }
            this.getStreamDataProvider().getCurrentEventCollection().addAll(arrayList);
            arrayList.clear();
        }
        return bl;
    }
}

