/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters;

import info.bioinfweb.commons.io.PeekReader;
import info.bioinfweb.commons.io.StreamLocationProvider;
import info.bioinfweb.jphyloio.ReadWriteConstants;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.AbstractCharLabelsReader;
import java.io.IOException;

public class CharLabelsReader
extends AbstractCharLabelsReader
implements NexusConstants,
ReadWriteConstants {
    private long index = 0L;

    public CharLabelsReader(NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        super("CHARLABELS", nexusReaderStreamDataProvider);
    }

    @Override
    protected boolean doReadNextEvent() throws IOException {
        this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        PeekReader peekReader = this.getStreamDataProvider().getDataReader();
        if (peekReader.peek() == 59) {
            this.getStreamDataProvider().getDataReader().skip(1L);
            this.setAllDataProcessed(true);
            return false;
        }
        if (peekReader.peek() == 61 || peekReader.peek() == 44) {
            throw new JPhyloIOReaderException("The character " + this.getStreamDataProvider().getDataReader().readChar() + " is not allowed in the Nexus " + "CHARLABELS" + " command.", (StreamLocationProvider)peekReader);
        }
        String string = this.getStreamDataProvider().readNexusWord();
        if (!string.equals("")) {
            this.addCharacterDefinition(string, this.index);
            ++this.index;
        }
        this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        return true;
    }
}

