/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders;

import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.NexusCommandEventReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.all.LinkReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.all.TitleReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.CharLabelsReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.CharStateLabelsReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.DimensionsReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.FormatReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.characters.MatrixReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets.CharSetReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets.TaxSetReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.sets.TreeSetReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.taxa.TaxLabelsReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.TranslateReader;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.trees.TreeReader;
import java.util.Map;
import java.util.TreeMap;

public class NexusCommandReaderFactory {
    public static final String ALL_BLOCKS_IDENTIFIER = "ALL BLOCKS";
    public static final char BLOCK_COMMAND_CONNECTOR = '.';
    private Map<String, Class<? extends NexusCommandEventReader>> readers = new TreeMap<String, Class<? extends NexusCommandEventReader>>();

    public static NexusCommandReaderFactory newJPhyloIOInstance() {
        NexusCommandReaderFactory nexusCommandReaderFactory = new NexusCommandReaderFactory();
        nexusCommandReaderFactory.addJPhyloIOReaders();
        return nexusCommandReaderFactory;
    }

    public void addJPhyloIOReaders() {
        this.addReaderClass(TitleReader.class);
        this.addReaderClass(LinkReader.class);
        this.addReaderClass(TaxLabelsReader.class);
        this.addReaderClass(DimensionsReader.class);
        this.addReaderClass(CharLabelsReader.class);
        this.addReaderClass(CharStateLabelsReader.class);
        this.addReaderClass(FormatReader.class);
        this.addReaderClass(MatrixReader.class);
        this.addReaderClass(TranslateReader.class);
        this.addReaderClass(TreeReader.class);
        this.addReaderClass(TaxSetReader.class);
        this.addReaderClass(CharSetReader.class);
        this.addReaderClass(TreeSetReader.class);
    }

    private NexusCommandEventReader createReaderInstance(Class<? extends NexusCommandEventReader> clazz, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) throws IllegalArgumentException {
        try {
            return clazz.getConstructor(NexusReaderStreamDataProvider.class).newInstance(nexusReaderStreamDataProvider);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to create instance with single " + NexusReaderStreamDataProvider.class.getName() + " argument. The specified reader class does not seem to offer the appropriate constructor.", exception);
        }
    }

    public void addReaderClass(Class<? extends NexusCommandEventReader> clazz) throws IllegalArgumentException {
        NexusCommandEventReader nexusCommandEventReader = this.createReaderInstance(clazz, null);
        if (nexusCommandEventReader.getValidBlocks().isEmpty()) {
            this.readers.put("ALL BLOCKS." + nexusCommandEventReader.getCommandName().toUpperCase(), clazz);
        } else {
            for (String string : nexusCommandEventReader.getValidBlocks()) {
                this.readers.put(string.toUpperCase() + '.' + nexusCommandEventReader.getCommandName().toUpperCase(), clazz);
            }
        }
    }

    public NexusCommandEventReader createReader(String string, String string2, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        Class<? extends NexusCommandEventReader> clazz = this.readers.get(string.toUpperCase() + '.' + string2.toUpperCase());
        if (clazz == null) {
            clazz = this.readers.get("ALL BLOCKS." + string2.toUpperCase());
        }
        if (clazz == null) {
            return null;
        }
        try {
            return this.createReaderInstance(clazz, nexusReaderStreamDataProvider);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError("The according reader class does not offer an contructor appropriate contructor.");
        }
    }
}

