/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus.commandreaders;

import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.formats.nexus.NexusReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexus.commandreaders.NexusCommandEventReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractNexusCommandEventReader
implements NexusCommandEventReader {
    private String commandName;
    private Collection<String> validBlocks;
    private boolean allDataProcessed = false;
    private NexusReaderStreamDataProvider streamDataProvider;

    public AbstractNexusCommandEventReader(String string, String[] stringArray, NexusReaderStreamDataProvider nexusReaderStreamDataProvider) {
        this.commandName = string.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].toUpperCase());
        }
        this.validBlocks = Collections.unmodifiableCollection(arrayList);
        this.streamDataProvider = nexusReaderStreamDataProvider;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public Collection<String> getValidBlocks() {
        return this.validBlocks;
    }

    protected boolean isAllDataProcessed() {
        return this.allDataProcessed;
    }

    protected void setAllDataProcessed(boolean bl) {
        this.allDataProcessed = bl;
    }

    protected NexusReaderStreamDataProvider getStreamDataProvider() {
        return this.streamDataProvider;
    }

    protected void consumeWhiteSpaceAndCommentsToBuffer(Collection<JPhyloIOEvent> collection) throws IOException {
        this.getStreamDataProvider().setCurrentEventCollection(collection);
        try {
            this.getStreamDataProvider().consumeWhiteSpaceAndComments();
        }
        finally {
            this.getStreamDataProvider().resetCurrentEventCollection();
        }
    }

    protected abstract boolean doReadNextEvent() throws IOException;

    @Override
    public boolean readNextEvent() throws IOException {
        if (this.isAllDataProcessed()) {
            return false;
        }
        return this.doReadNextEvent();
    }
}

