/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexus;

import info.bioinfweb.jphyloio.JPhyloIOEventReader;
import info.bioinfweb.jphyloio.JPhyloIOEventWriter;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.meta.LiteralContentSequenceType;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.factory.AbstractStartStringSingleFactory;
import info.bioinfweb.jphyloio.formatinfo.DefaultFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.JPhyloIOFormatInfo;
import info.bioinfweb.jphyloio.formatinfo.MetadataModeling;
import info.bioinfweb.jphyloio.formatinfo.MetadataTopologyType;
import info.bioinfweb.jphyloio.formats.JPhyloIOFormatIDs;
import info.bioinfweb.jphyloio.formats.nexus.NexusConstants;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventReader;
import info.bioinfweb.jphyloio.formats.nexus.NexusEventWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeSet;

public class NexusFactory
extends AbstractStartStringSingleFactory
implements NexusConstants,
JPhyloIOFormatIDs {
    public NexusFactory() {
        super("#NEXUS");
    }

    @Override
    public JPhyloIOEventReader getReader(InputStream inputStream, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        return new NexusEventReader(inputStream, readWriteParameterMap);
    }

    @Override
    public JPhyloIOEventReader getReader(Reader reader, ReadWriteParameterMap readWriteParameterMap) throws IOException {
        return new NexusEventReader(reader, readWriteParameterMap);
    }

    @Override
    public JPhyloIOEventWriter getWriter() {
        return new NexusEventWriter();
    }

    @Override
    public boolean hasReader() {
        return true;
    }

    @Override
    public boolean hasWriter() {
        return true;
    }

    @Override
    protected JPhyloIOFormatInfo createFormatInfo() {
        EnumSet<EventContentType[]> enumSet = EnumSet.of(EventContentType.DOCUMENT, new EventContentType[]{EventContentType.LITERAL_META, EventContentType.LITERAL_META_CONTENT, EventContentType.UNKNOWN_COMMAND, EventContentType.COMMENT, EventContentType.OTU_LIST, EventContentType.OTU, EventContentType.OTU_SET, EventContentType.ALIGNMENT, EventContentType.CHARACTER_DEFINITION, EventContentType.SEQUENCE, EventContentType.SEQUENCE_TOKENS, EventContentType.TREE_NETWORK_GROUP, EventContentType.TREE, EventContentType.NODE, EventContentType.EDGE, EventContentType.ROOT_EDGE, EventContentType.TOKEN_SET_DEFINITION, EventContentType.SINGLE_TOKEN_DEFINITION, EventContentType.CHARACTER_SET, EventContentType.CHARACTER_SET_INTERVAL, EventContentType.SET_ELEMENT, EventContentType.OTU_SET, EventContentType.TREE_NETWORK_SET});
        EnumSet<EventContentType[]> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.add((EventContentType[])EventContentType.SINGLE_SEQUENCE_TOKEN);
        EnumMap<EventContentType, MetadataModeling> enumMap = new EnumMap<EventContentType, MetadataModeling>(EventContentType.class);
        enumMap.put(EventContentType.NODE, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        enumMap.put(EventContentType.EDGE, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        EnumMap<EventContentType, MetadataModeling> enumMap2 = new EnumMap<EventContentType, MetadataModeling>((Map<EventContentType, MetadataModeling>)enumMap);
        enumMap2.put(EventContentType.ALIGNMENT, new MetadataModeling(MetadataTopologyType.LITERAL_ONLY, EnumSet.of(LiteralContentSequenceType.SIMPLE)));
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("info.bioinfweb.jphyloio.nexusBlockHandlerMap");
        treeSet.add("info.bioinfweb.jphyloio.nexusCommandReaderFactory");
        treeSet.add("info.bioinfweb.jphyloio.createUnknownCommandEvents");
        treeSet.add("info.bioinfweb.jphyloio.maxTokensToRead");
        treeSet.add("info.bioinfweb.jphyloio.maxCommentLength");
        treeSet.add("info.bioinfweb.jphyloio.replaceMatchTokens");
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet2.add("info.bioinfweb.jphyloio.writerInstance");
        treeSet2.add("info.bioinfweb.jphyloio.logger");
        treeSet2.add("info.bioinfweb.jphyloio.applicationName");
        treeSet2.add("info.bioinfweb.jphyloio.applicationVersion");
        treeSet2.add("info.bioinfweb.jphyloio.applicationURL");
        treeSet2.add("info.bioinfweb.jphyloio.lineSeparator");
        treeSet2.add("info.bioinfweb.jphyloio.sequenceExtensionToken");
        return new DefaultFormatInfo(this, "info.bioinfweb.jphyloio.nexus", "Nexus", enumSet, enumSet2, enumMap, enumMap2, treeSet, treeSet2, new ReadWriteParameterMap(), "Nexus format", "nex", "nexus", "tre", "tree", "con");
    }
}

