/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.commons.bio.CharacterStateSetType;
import info.bioinfweb.commons.bio.CharacterSymbolMeaning;
import info.bioinfweb.commons.bio.CharacterSymbolType;
import info.bioinfweb.commons.bio.SequenceUtils;
import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.events.CommentEvent;
import info.bioinfweb.jphyloio.events.ConcreteJPhyloIOEvent;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleTokenDefinitionEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataContentEvent;
import info.bioinfweb.jphyloio.events.meta.LiteralMetadataEvent;
import info.bioinfweb.jphyloio.events.meta.ResourceMetadataEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLMetaDataReceiver;
import info.bioinfweb.jphyloio.formats.nexml.receivers.NeXMLTokenSetEventReceiver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class NeXMLMolecularDataTokenDefinitionReceiver
extends NeXMLMetaDataReceiver {
    private NeXMLTokenSetEventReceiver receiver;
    private Set<Character> tokens = new HashSet<Character>();

    public NeXMLMolecularDataTokenDefinitionReceiver(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, String string) {
        super(neXMLWriterStreamDataProvider, readWriteParameterMap);
        this.receiver = new NeXMLTokenSetEventReceiver(neXMLWriterStreamDataProvider, readWriteParameterMap, string);
    }

    private void writeDNATokenDefinitions(NeXMLTokenSetEventReceiver neXMLTokenSetEventReceiver) throws IOException, XMLStreamException {
        LinkedHashSet<Character> linkedHashSet = new LinkedHashSet<Character>();
        for (int i = 0; i < "CGAT".length(); ++i) {
            linkedHashSet.add(Character.valueOf("CGAT".charAt(i)));
        }
        for (Character c : SequenceUtils.getNucleotideCharacters()) {
            linkedHashSet.add(c);
        }
        linkedHashSet.removeAll(this.tokens);
        linkedHashSet.remove(Character.valueOf('U'));
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < "CGAT".length(); ++i) {
            arrayList.add(Character.toString("CGAT".charAt(i)));
        }
        arrayList.add(Character.toString('-'));
        this.writeTokenDefinitionEvents(neXMLTokenSetEventReceiver, linkedHashSet, CharacterStateSetType.DNA, arrayList, !this.tokens.contains(Character.valueOf('-')), !this.tokens.contains(Character.valueOf('?')));
    }

    private void writeRNATokenDefinitions(NeXMLTokenSetEventReceiver neXMLTokenSetEventReceiver) throws IOException, XMLStreamException {
        LinkedHashSet<Character> linkedHashSet = new LinkedHashSet<Character>();
        for (int i = 0; i < "CGAU".length(); ++i) {
            linkedHashSet.add(Character.valueOf("CGAU".charAt(i)));
        }
        for (Character c : SequenceUtils.getNucleotideCharacters()) {
            linkedHashSet.add(c);
        }
        linkedHashSet.removeAll(this.tokens);
        linkedHashSet.remove(Character.valueOf('T'));
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < "CGAU".length(); ++i) {
            arrayList.add(Character.toString("CGAU".charAt(i)));
        }
        arrayList.add(Character.toString('-'));
        this.writeTokenDefinitionEvents(neXMLTokenSetEventReceiver, linkedHashSet, CharacterStateSetType.RNA, arrayList, !this.tokens.contains(Character.valueOf('-')), !this.tokens.contains(Character.valueOf('?')));
    }

    private void writeAminoAcidTokenDefinitions(NeXMLTokenSetEventReceiver neXMLTokenSetEventReceiver) throws IOException, XMLStreamException {
        LinkedHashSet<Character> linkedHashSet = new LinkedHashSet<Character>();
        for (Object object : SequenceUtils.getAminoAcidOneLetterCodes((boolean)false)) {
            linkedHashSet.add((Character)object);
        }
        linkedHashSet.add(Character.valueOf('*'));
        for (Object object : SequenceUtils.getAminoAcidOneLetterCodes((boolean)true)) {
            linkedHashSet.add((Character)object);
        }
        linkedHashSet.removeAll(this.tokens);
        linkedHashSet.remove(Character.valueOf('J'));
        ArrayList arrayList = new ArrayList();
        for (Character c : SequenceUtils.getAminoAcidOneLetterCodes((boolean)false)) {
            arrayList.add(Character.toString(c.charValue()));
        }
        arrayList.add(Character.toString('*'));
        arrayList.add(Character.toString('-'));
        this.writeTokenDefinitionEvents(neXMLTokenSetEventReceiver, linkedHashSet, CharacterStateSetType.AMINO_ACID, arrayList, !this.tokens.contains(Character.valueOf('-')), !this.tokens.contains(Character.valueOf('?')));
    }

    private void writeTokenDefinitionEvents(NeXMLTokenSetEventReceiver neXMLTokenSetEventReceiver, Set<Character> set, CharacterStateSetType characterStateSetType, Collection<String> collection, boolean bl, boolean bl2) throws IOException, XMLStreamException {
        Object object;
        for (Character c : set) {
            ArrayList<String> arrayList = null;
            CharacterSymbolType characterSymbolType = CharacterSymbolType.ATOMIC_STATE;
            char[] cArray = new char[]{};
            if (characterStateSetType.equals((Object)CharacterStateSetType.DNA)) {
                cArray = SequenceUtils.nucleotideConstituents((char)c.charValue());
            } else if (characterStateSetType.equals((Object)CharacterStateSetType.RNA)) {
                cArray = SequenceUtils.rnaConstituents((char)c.charValue());
            } else if (characterStateSetType.equals((Object)CharacterStateSetType.AMINO_ACID)) {
                cArray = SequenceUtils.oneLetterAminoAcidConstituents((String)Character.toString(c.charValue()));
            }
            if (cArray.length > 1) {
                arrayList = new ArrayList<String>();
                characterSymbolType = CharacterSymbolType.UNCERTAIN;
                for (int i = 0; i < cArray.length; ++i) {
                    arrayList.add(Character.toString(cArray[i]));
                }
            }
            String string = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("tokenDefinition");
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs(string);
            neXMLTokenSetEventReceiver.doAdd(new SingleTokenDefinitionEvent(string, null, Character.toString(c.charValue()), CharacterSymbolMeaning.CHARACTER_STATE, characterSymbolType, arrayList));
            neXMLTokenSetEventReceiver.doAdd(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_TOKEN_DEFINITION));
        }
        if (bl) {
            object = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("tokenDefinition");
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)object);
            neXMLTokenSetEventReceiver.doAdd(new SingleTokenDefinitionEvent((String)object, "gap", Character.toString('-'), CharacterSymbolMeaning.GAP, CharacterSymbolType.ATOMIC_STATE, null));
            neXMLTokenSetEventReceiver.doAdd(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_TOKEN_DEFINITION));
        }
        if (bl2) {
            object = ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).createNewID("tokenDefinition");
            ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).addToDocumentIDs((String)object);
            neXMLTokenSetEventReceiver.doAdd(new SingleTokenDefinitionEvent((String)object, "missing data", Character.toString('?'), CharacterSymbolMeaning.MISSING, CharacterSymbolType.UNCERTAIN, collection));
            neXMLTokenSetEventReceiver.doAdd(ConcreteJPhyloIOEvent.createEndEvent(EventContentType.SINGLE_TOKEN_DEFINITION));
        }
    }

    public void addRemainingEvents(CharacterStateSetType characterStateSetType) throws IOException, XMLStreamException {
        switch (characterStateSetType) {
            case NUCLEOTIDE: 
            case DNA: {
                this.writeDNATokenDefinitions(this.receiver);
                break;
            }
            case RNA: {
                this.writeRNATokenDefinitions(this.receiver);
                break;
            }
            case AMINO_ACID: {
                this.writeAminoAcidTokenDefinitions(this.receiver);
                break;
            }
        }
    }

    @Override
    protected void handleLiteralMetaStart(LiteralMetadataEvent literalMetadataEvent) throws IOException, XMLStreamException {
        this.receiver.add(literalMetadataEvent);
    }

    @Override
    protected void handleLiteralContentMeta(LiteralMetadataContentEvent literalMetadataContentEvent) throws IOException, XMLStreamException {
        this.receiver.add(literalMetadataContentEvent);
    }

    @Override
    protected void handleResourceMetaStart(ResourceMetadataEvent resourceMetadataEvent) throws IOException, XMLStreamException {
        this.receiver.add(resourceMetadataEvent);
    }

    @Override
    protected void handleMetaEndEvent(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        this.receiver.add(jPhyloIOEvent);
    }

    @Override
    protected void handleComment(CommentEvent commentEvent) throws IOException, XMLStreamException {
        this.receiver.add(commentEvent);
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SINGLE_TOKEN_DEFINITION: {
                if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                    SingleTokenDefinitionEvent singleTokenDefinitionEvent = jPhyloIOEvent.asSingleTokenDefinitionEvent();
                    if (((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().getAlignmentType().equals((Object)CharacterStateSetType.AMINO_ACID)) {
                        if (singleTokenDefinitionEvent.getTokenName().length() > 1) {
                            this.tokens.add(Character.valueOf(SequenceUtils.oneLetterAminoAcidByThreeLetter((String)singleTokenDefinitionEvent.getTokenName())));
                        }
                    } else {
                        this.tokens.add(Character.valueOf(singleTokenDefinitionEvent.getTokenName().charAt(0)));
                    }
                }
                this.receiver.doAdd(jPhyloIOEvent);
            }
        }
        return true;
    }
}

