/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.receivers;

import info.bioinfweb.jphyloio.ReadWriteParameterMap;
import info.bioinfweb.jphyloio.dataadapters.implementations.receivers.AbstractSequenceContentReceiver;
import info.bioinfweb.jphyloio.events.JPhyloIOEvent;
import info.bioinfweb.jphyloio.events.SingleSequenceTokenEvent;
import info.bioinfweb.jphyloio.events.type.EventTopologyType;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLConstants;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLWriterStreamDataProvider;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class NeXMLHandleSequenceDataReceiver
extends AbstractSequenceContentReceiver<NeXMLWriterStreamDataProvider>
implements NeXMLConstants {
    private boolean nestedUnderSingleToken = false;
    private long tokenIndex = 0L;

    public NeXMLHandleSequenceDataReceiver(NeXMLWriterStreamDataProvider neXMLWriterStreamDataProvider, ReadWriteParameterMap readWriteParameterMap, boolean bl) {
        super(neXMLWriterStreamDataProvider, readWriteParameterMap, bl);
    }

    public boolean isNestedUnderSingleToken() {
        return this.nestedUnderSingleToken;
    }

    public void setNestedUnderSingleToken(boolean bl) {
        this.nestedUnderSingleToken = bl;
    }

    public long getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(long l) {
        this.tokenIndex = l;
    }

    protected void handleTokenEnd() throws XMLStreamException {
    }

    @Override
    protected boolean doAdd(JPhyloIOEvent jPhyloIOEvent) throws IOException, XMLStreamException {
        switch (jPhyloIOEvent.getType().getContentType()) {
            case SINGLE_SEQUENCE_TOKEN: {
                if (jPhyloIOEvent.getType().getTopologyType().equals((Object)EventTopologyType.START)) {
                    SingleSequenceTokenEvent singleSequenceTokenEvent = jPhyloIOEvent.asSingleSequenceTokenEvent();
                    this.handleToken(singleSequenceTokenEvent.getToken(), singleSequenceTokenEvent.getLabel());
                    this.setNestedUnderSingleToken(true);
                    if (singleSequenceTokenEvent.getLabel() == null) break;
                    ((NeXMLWriterStreamDataProvider)this.getStreamDataProvider()).getCurrentAlignmentInfo().setWriteCellsTags(true);
                    break;
                }
                this.handleTokenEnd();
                this.setNestedUnderSingleToken(false);
                break;
            }
            case SEQUENCE_TOKENS: {
                for (String string : jPhyloIOEvent.asSequenceTokensEvent().getTokens()) {
                    this.handleToken(string, null);
                    this.handleTokenEnd();
                }
                break;
            }
        }
        return true;
    }
}

