/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.jphyloio.formats.nexml.elementreader;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.jphyloio.events.LinkedLabeledIDEvent;
import info.bioinfweb.jphyloio.events.type.EventContentType;
import info.bioinfweb.jphyloio.exception.JPhyloIOReaderException;
import info.bioinfweb.jphyloio.formats.nexml.NeXMLReaderStreamDataProvider;
import info.bioinfweb.jphyloio.formats.nexml.elementreader.AbstractNeXMLElementReader;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractSetElementReader
extends AbstractNeXMLElementReader {
    private EventContentType setType;
    private QName[] linkedIDsAttributes;
    private EventContentType linkedIDType;

    protected AbstractSetElementReader(EventContentType eventContentType, EventContentType eventContentType2, QName ... qNameArray) {
        this.setType = eventContentType;
        this.linkedIDType = eventContentType2;
        this.linkedIDsAttributes = qNameArray;
    }

    public EventContentType getSetType() {
        return this.setType;
    }

    @Override
    public void readEvent(NeXMLReaderStreamDataProvider neXMLReaderStreamDataProvider, XMLEvent xMLEvent) throws IOException, XMLStreamException {
        StartElement startElement = xMLEvent.asStartElement();
        AbstractNeXMLElementReader.LabeledIDEventInformation labeledIDEventInformation = this.getLabeledIDEventInformation(neXMLReaderStreamDataProvider, startElement);
        neXMLReaderStreamDataProvider.setCurrentSetIsSupported(true);
        neXMLReaderStreamDataProvider.getCurrentEventCollection().add(new LinkedLabeledIDEvent(this.setType, labeledIDEventInformation.id, labeledIDEventInformation.label, neXMLReaderStreamDataProvider.getElementTypeToCurrentIDMap().get((Object)this.linkedIDType)));
        for (int i = 0; i < this.linkedIDsAttributes.length; ++i) {
            String string = XMLUtils.readStringAttr((StartElement)startElement, (QName)this.linkedIDsAttributes[i], null);
            if (string == null) continue;
            String[] stringArray = string.split("\\s+");
            string = null;
            this.processIDs(neXMLReaderStreamDataProvider, stringArray, this.linkedIDsAttributes[i]);
        }
    }

    protected abstract void processIDs(NeXMLReaderStreamDataProvider var1, String[] var2, QName var3) throws JPhyloIOReaderException, XMLStreamException;
}

